/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.X500Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean DEBUG = false;
    private static final String USER_CERT = "userCertificate;binary";
    private static final String CA_CERT = "cACertificate;binary";
    private static final String CROSS_CERT = "crossCertificatePair;binary";
    private static final String CRL = "certificateRevocationList;binary";
    private static final String ARL = "authorityRevocationList;binary";
    private static final String DELTA_CRL = "deltaRevocationList;binary";
    private static final String[] STRING0 = new String[0];
    private static final byte[][] BB0 = new byte[0][];
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private static final int DEFAULT_CACHE_SIZE = 750;
    private static final int DEFAULT_CACHE_LIFETIME = 30;
    private static final int LIFETIME;
    private static final String PROP_LIFETIME = "sun.security.certpath.ldap.cache.lifetime";
    private CertificateFactory cf;
    private DirContext ctx;
    private boolean prefetchCRLs = false;
    private final Cache valueCache;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private int requests = 0;
    private static final Cache certStoreCache;

    public LDAPCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        LDAPCertStoreParameters lparams = (LDAPCertStoreParameters)params;
        this.createInitialDirContext(lparams.getServerName(), lparams.getPort());
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new InvalidAlgorithmParameterException("unable to create CertificateFactory for X.509");
        }
        this.valueCache = LIFETIME == 0 ? Cache.newNullCache() : (LIFETIME < 0 ? Cache.newSoftMemoryCache(750) : Cache.newSoftMemoryCache(750, LIFETIME));
    }

    static synchronized CertStore getInstance(LDAPCertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore lcs = (CertStore)certStoreCache.get(params);
        if (lcs == null) {
            lcs = CertStore.getInstance("LDAP", params);
            certStoreCache.put(params, lcs);
        } else if (debug != null) {
            debug.println("LDAPCertStore.getInstance: cache hit");
        }
        return lcs;
    }

    private void createInitialDirContext(String server, int port) throws InvalidAlgorithmParameterException {
        String url = "ldap://" + server + ":" + port;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        try {
            this.ctx = new InitialDirContext(env);
            Hashtable<?, ?> currentEnv = this.ctx.getEnvironment();
            if (currentEnv.get("java.naming.referral") == null) {
                this.ctx.addToEnvironment("java.naming.referral", "follow");
            }
        }
        catch (NamingException e) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineInit about to throw InvalidAlgorithmParameterException");
                e.printStackTrace();
            }
            InvalidAlgorithmParameterException ee = new InvalidAlgorithmParameterException("unable to create InitialDirContext using supplied parameters");
            ee.initCause(e);
            throw ee;
        }
    }

    private Collection<X509Certificate> getCertificates(LDAPRequest request, String id, X509CertSelector sel) throws CertStoreException {
        byte[][] encodedCert;
        try {
            encodedCert = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCert.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(n);
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert[i]);
            try {
                Certificate cert = this.cf.generateCertificate(bais);
                if (!sel.match(cert)) continue;
                certs.add((X509Certificate)cert);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertificates() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                debug.println("[ " + encoder.encodeBuffer(encodedCert[i]) + " ]");
            }
        }
        return certs;
    }

    private Collection<X509CertificatePair> getCertPairs(LDAPRequest request, String id) throws CertStoreException {
        byte[][] encodedCertPair;
        try {
            encodedCertPair = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCertPair.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509CertificatePair> certPairs = new ArrayList<X509CertificatePair>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CertificatePair certPair = X509CertificatePair.generateCertificatePair(encodedCertPair[i]);
                certPairs.add(certPair);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertPairs() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                debug.println("[ " + encoder.encodeBuffer(encodedCertPair[i]) + " ]");
            }
        }
        return certPairs;
    }

    private Collection<X509Certificate> getMatchingCrossCerts(LDAPRequest request, X509CertSelector forward, X509CertSelector reverse) throws CertStoreException {
        Collection<X509CertificatePair> certPairs = this.getCertPairs(request, CROSS_CERT);
        ArrayList<X509Certificate> matchingCerts = new ArrayList<X509Certificate>();
        for (X509CertificatePair certPair : certPairs) {
            X509Certificate cert;
            if (forward != null && (cert = certPair.getForward()) != null && forward.match(cert)) {
                matchingCerts.add(cert);
            }
            if (reverse == null || (cert = certPair.getReverse()) == null || !reverse.match(cert)) continue;
            matchingCerts.add(cert);
        }
        return matchingCerts;
    }

    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        LDAPRequest request;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() selector: " + String.valueOf(selector));
        }
        if (selector == null) {
            selector = new X509CertSelector();
        }
        if (!(selector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        X509CertSelector xsel = (X509CertSelector)selector;
        int basicConstraints = xsel.getBasicConstraints();
        String subject = xsel.getSubjectAsString();
        String issuer = xsel.getIssuerAsString();
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() basicConstraints: " + basicConstraints);
        }
        if (subject != null) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is not null");
            }
            request = new LDAPRequest(subject);
            if (basicConstraints > -2) {
                request.addRequestedAttribute(CROSS_CERT);
                request.addRequestedAttribute(CA_CERT);
                request.addRequestedAttribute(ARL);
                if (this.prefetchCRLs) {
                    request.addRequestedAttribute(CRL);
                }
            }
            if (basicConstraints < 0) {
                request.addRequestedAttribute(USER_CERT);
            }
            if (basicConstraints > -2) {
                certs.addAll(this.getMatchingCrossCerts(request, xsel, null));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(subject,xsel,null),certs.size(): " + certs.size());
                }
                certs.addAll(this.getCertificates(request, CA_CERT, xsel));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,CA_CERT,xsel),certs.size(): " + certs.size());
                }
            }
            if (basicConstraints < 0) {
                certs.addAll(this.getCertificates(request, USER_CERT, xsel));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,USER_CERT, xsel),certs.size(): " + certs.size());
                }
            }
        } else {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is null");
            }
            if (basicConstraints == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (issuer == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() about to getMatchingCrossCerts...");
        }
        if (issuer != null && basicConstraints > -2) {
            request = new LDAPRequest(issuer);
            request.addRequestedAttribute(CROSS_CERT);
            request.addRequestedAttribute(CA_CERT);
            request.addRequestedAttribute(ARL);
            if (this.prefetchCRLs) {
                request.addRequestedAttribute(CRL);
            }
            certs.addAll(this.getMatchingCrossCerts(request, null, xsel));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(issuer,null,xsel),certs.size(): " + certs.size());
            }
            certs.addAll(this.getCertificates(request, CA_CERT, xsel));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(issuer,CA_CERT,xsel),certs.size(): " + certs.size());
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() returning certs");
        }
        return certs;
    }

    private Collection<X509CRL> getCRLs(LDAPRequest request, String id, X509CRLSelector sel) throws CertStoreException {
        byte[][] encodedCRL;
        try {
            encodedCRL = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCRL.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(n);
        for (int i = 0; i < n; ++i) {
            try {
                CRL crl = this.cf.generateCRL(new ByteArrayInputStream(encodedCRL[i]));
                if (!sel.match(crl)) continue;
                crls.add((X509CRL)crl);
                continue;
            }
            catch (CRLException e) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCRLs() encountered exception while parsing CRL, skipping the bad data: ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                debug.println("[ " + encoder.encodeBuffer(encodedCRL[i]) + " ]");
            }
        }
        return crls;
    }

    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        Collection<Object> issuerNames;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCRLs() selector: " + selector);
        }
        if (selector == null) {
            selector = new X509CRLSelector();
        }
        if (!(selector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector xsel = (X509CRLSelector)selector;
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        X509Certificate certChecking = xsel.getCertificateChecking();
        if (certChecking != null) {
            issuerNames = new HashSet<Object>();
            X500Principal issuer = certChecking.getIssuerX500Principal();
            issuerNames.add(issuer.getName("RFC2253"));
        } else {
            issuerNames = xsel.getIssuerNames();
            if (issuerNames == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        for (Object nameObject : issuerNames) {
            LDAPRequest request;
            Collection<Object> entryCRLs;
            String issuerName;
            block17: {
                block16: {
                    if (nameObject instanceof byte[]) {
                        try {
                            X500Principal issuer = new X500Principal((byte[])nameObject);
                            issuerName = issuer.getName("RFC2253");
                            break block16;
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                    }
                    issuerName = (String)nameObject;
                }
                entryCRLs = Collections.emptySet();
                if (certChecking == null || certChecking.getBasicConstraints() != -1) {
                    request = new LDAPRequest(issuerName);
                    request.addRequestedAttribute(CROSS_CERT);
                    request.addRequestedAttribute(CA_CERT);
                    request.addRequestedAttribute(ARL);
                    if (this.prefetchCRLs) {
                        request.addRequestedAttribute(CRL);
                    }
                    try {
                        entryCRLs = this.getCRLs(request, ARL, xsel);
                        if (entryCRLs.isEmpty()) {
                            this.prefetchCRLs = true;
                        } else {
                            crls.addAll(entryCRLs);
                        }
                    }
                    catch (CertStoreException e) {
                        if (debug == null) break block17;
                        debug.println("LDAPCertStore.engineGetCRLs non-fatal error retrieving ARLs:" + e);
                        e.printStackTrace();
                    }
                }
            }
            if (!entryCRLs.isEmpty() && certChecking != null) continue;
            request = new LDAPRequest(issuerName);
            request.addRequestedAttribute(CRL);
            entryCRLs = this.getCRLs(request, CRL, xsel);
            crls.addAll(entryCRLs);
        }
        return crls;
    }

    static LDAPCertStoreParameters getParameters(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return new SunLDAPCertStoreParameters();
        }
        int port = uri.getPort();
        return port == -1 ? new SunLDAPCertStoreParameters(host) : new SunLDAPCertStoreParameters(host, port);
    }

    static {
        String s = AccessController.doPrivileged(new GetPropertyAction(PROP_LIFETIME));
        LIFETIME = s != null ? Integer.parseInt(s) : 30;
        certStoreCache = Cache.newSoftMemoryCache(185);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LDAPCRLSelector
    extends X509CRLSelector {
        private X509CRLSelector selector;
        private Collection<X500Principal> certIssuers;
        private Collection<X500Principal> issuers;
        private HashSet<Object> issuerNames;

        LDAPCRLSelector(X509CRLSelector selector, Collection<X500Principal> certIssuers, String ldapDN) throws IOException {
            this.selector = selector == null ? new X509CRLSelector() : selector;
            this.certIssuers = certIssuers;
            this.issuerNames = new HashSet();
            this.issuerNames.add(ldapDN);
            this.issuers = new HashSet<X500Principal>();
            this.issuers.add(new X500Name(ldapDN).asX500Principal());
        }

        @Override
        public Collection<X500Principal> getIssuers() {
            return Collections.unmodifiableCollection(this.issuers);
        }

        @Override
        public Collection<Object> getIssuerNames() {
            return Collections.unmodifiableCollection(this.issuerNames);
        }

        @Override
        public BigInteger getMinCRL() {
            return this.selector.getMinCRL();
        }

        @Override
        public BigInteger getMaxCRL() {
            return this.selector.getMaxCRL();
        }

        @Override
        public Date getDateAndTime() {
            return this.selector.getDateAndTime();
        }

        @Override
        public X509Certificate getCertificateChecking() {
            return this.selector.getCertificateChecking();
        }

        @Override
        public boolean match(CRL crl) {
            this.selector.setIssuers(this.certIssuers);
            boolean match = this.selector.match(crl);
            this.selector.setIssuers(this.issuers);
            return match;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LDAPCertSelector
    extends X509CertSelector {
        private X500Principal certSubject;
        private X509CertSelector selector;
        private X500Principal subject;

        LDAPCertSelector(X509CertSelector selector, X500Principal certSubject, String ldapDN) throws IOException {
            this.selector = selector == null ? new X509CertSelector() : selector;
            this.certSubject = certSubject;
            this.subject = new X500Name(ldapDN).asX500Principal();
        }

        @Override
        public X509Certificate getCertificate() {
            return this.selector.getCertificate();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.selector.getSerialNumber();
        }

        @Override
        public X500Principal getIssuer() {
            return this.selector.getIssuer();
        }

        @Override
        public String getIssuerAsString() {
            return this.selector.getIssuerAsString();
        }

        @Override
        public byte[] getIssuerAsBytes() throws IOException {
            return this.selector.getIssuerAsBytes();
        }

        @Override
        public X500Principal getSubject() {
            return this.subject;
        }

        @Override
        public String getSubjectAsString() {
            return this.subject.getName();
        }

        @Override
        public byte[] getSubjectAsBytes() throws IOException {
            return this.subject.getEncoded();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.selector.getSubjectKeyIdentifier();
        }

        @Override
        public byte[] getAuthorityKeyIdentifier() {
            return this.selector.getAuthorityKeyIdentifier();
        }

        @Override
        public Date getCertificateValid() {
            return this.selector.getCertificateValid();
        }

        @Override
        public Date getPrivateKeyValid() {
            return this.selector.getPrivateKeyValid();
        }

        @Override
        public String getSubjectPublicKeyAlgID() {
            return this.selector.getSubjectPublicKeyAlgID();
        }

        @Override
        public PublicKey getSubjectPublicKey() {
            return this.selector.getSubjectPublicKey();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.selector.getKeyUsage();
        }

        @Override
        public Set<String> getExtendedKeyUsage() {
            return this.selector.getExtendedKeyUsage();
        }

        @Override
        public boolean getMatchAllSubjectAltNames() {
            return this.selector.getMatchAllSubjectAltNames();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() {
            return this.selector.getSubjectAlternativeNames();
        }

        @Override
        public byte[] getNameConstraints() {
            return this.selector.getNameConstraints();
        }

        @Override
        public int getBasicConstraints() {
            return this.selector.getBasicConstraints();
        }

        @Override
        public Set<String> getPolicy() {
            return this.selector.getPolicy();
        }

        @Override
        public Collection<List<?>> getPathToNames() {
            return this.selector.getPathToNames();
        }

        @Override
        public boolean match(Certificate cert) {
            this.selector.setSubject(this.certSubject);
            boolean match = this.selector.match(cert);
            this.selector.setSubject(this.subject);
            return match;
        }
    }

    private static class SunLDAPCertStoreParameters
    extends LDAPCertStoreParameters {
        private volatile int hashCode = 0;

        SunLDAPCertStoreParameters(String serverName, int port) {
            super(serverName, port);
        }

        SunLDAPCertStoreParameters(String serverName) {
            super(serverName);
        }

        SunLDAPCertStoreParameters() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LDAPCertStoreParameters)) {
                return false;
            }
            LDAPCertStoreParameters params = (LDAPCertStoreParameters)obj;
            return this.getPort() == params.getPort() && this.getServerName().equalsIgnoreCase(params.getServerName());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getPort();
                this.hashCode = result = 37 * result + this.getServerName().toLowerCase().hashCode();
            }
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LDAPRequest {
        private final String name;
        private Map<String, byte[][]> valueMap;
        private final List<String> requestedAttributes;

        LDAPRequest(String name) {
            this.name = name;
            this.requestedAttributes = new ArrayList<String>(5);
        }

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String attrId) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(attrId);
        }

        byte[][] getValues(String attrId) throws NamingException {
            String cacheKey = this.name + "|" + attrId;
            byte[][] values = (byte[][])LDAPCertStore.this.valueCache.get(cacheKey);
            if (values != null) {
                LDAPCertStore.this.cacheHits++;
                return values;
            }
            LDAPCertStore.this.cacheMisses++;
            Map<String, byte[][]> attrs = this.getValueMap();
            values = attrs.get(attrId);
            return values;
        }

        private Map<String, byte[][]> getValueMap() throws NamingException {
            Attributes attrs;
            if (this.valueMap != null) {
                return this.valueMap;
            }
            this.valueMap = new HashMap<String, byte[][]>(8);
            String[] attrIds = this.requestedAttributes.toArray(STRING0);
            try {
                attrs = LDAPCertStore.this.ctx.getAttributes(this.name, attrIds);
            }
            catch (NameNotFoundException e) {
                attrs = EMPTY_ATTRIBUTES;
            }
            for (String attrId : this.requestedAttributes) {
                Attribute attr = attrs.get(attrId);
                byte[][] values = this.getAttributeValues(attr);
                this.cacheAttribute(attrId, values);
                this.valueMap.put(attrId, values);
            }
            return this.valueMap;
        }

        private void cacheAttribute(String attrId, byte[][] values) {
            String cacheKey = this.name + "|" + attrId;
            LDAPCertStore.this.valueCache.put(cacheKey, values);
        }

        private byte[][] getAttributeValues(Attribute attr) throws NamingException {
            Object values;
            if (attr == null) {
                values = BB0;
            } else {
                values = new byte[attr.size()][];
                int i = 0;
                NamingEnumeration<?> enum_ = attr.getAll();
                while (enum_.hasMore()) {
                    Object obj = enum_.next();
                    if (debug != null && obj instanceof String) {
                        debug.println("LDAPCertStore.getAttrValues() enum.next is a string!: " + obj);
                    }
                    byte[] value = (byte[])obj;
                    values[i++] = value;
                }
            }
            return values;
        }
    }
}

