/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.NetworkInterface;
import sun.nio.ch.SocketOpts;

class SocketOptsImpl
implements SocketOpts {
    private final Dispatcher d;

    SocketOptsImpl(Dispatcher d) {
        this.d = d;
    }

    protected boolean getBoolean(int opt) throws IOException {
        return this.d.getInt(opt) > 0;
    }

    protected void setBoolean(int opt, boolean b) throws IOException {
        this.d.setInt(opt, b ? 1 : 0);
    }

    protected int getInt(int opt) throws IOException {
        return this.d.getInt(opt);
    }

    protected void setInt(int opt, int n) throws IOException {
        this.d.setInt(opt, n);
    }

    protected NetworkInterface getNetworkInterface(int opt) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    protected void setNetworkInterface(int opt, NetworkInterface ni) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    protected void addToString(StringBuffer sb, String s) {
        char c = sb.charAt(sb.length() - 1);
        if (c != '[' && c != '=') {
            sb.append(' ');
        }
        sb.append(s);
    }

    protected void addToString(StringBuffer sb, int n) {
        this.addToString(sb, Integer.toString(n));
    }

    public boolean broadcast() throws IOException {
        return this.getBoolean(32);
    }

    public SocketOpts broadcast(boolean b) throws IOException {
        this.setBoolean(32, b);
        return this;
    }

    public boolean keepAlive() throws IOException {
        return this.getBoolean(8);
    }

    public SocketOpts keepAlive(boolean b) throws IOException {
        this.setBoolean(8, b);
        return this;
    }

    public int linger() throws IOException {
        return this.getInt(128);
    }

    public SocketOpts linger(int n) throws IOException {
        this.setInt(128, n);
        return this;
    }

    public boolean outOfBandInline() throws IOException {
        return this.getBoolean(4099);
    }

    public SocketOpts outOfBandInline(boolean b) throws IOException {
        this.setBoolean(4099, b);
        return this;
    }

    public int receiveBufferSize() throws IOException {
        return this.getInt(4098);
    }

    public SocketOpts receiveBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setInt(4098, n);
        return this;
    }

    public int sendBufferSize() throws IOException {
        return this.getInt(4097);
    }

    public SocketOpts sendBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setInt(4097, n);
        return this;
    }

    public boolean reuseAddress() throws IOException {
        return this.getBoolean(4);
    }

    public SocketOpts reuseAddress(boolean b) throws IOException {
        this.setBoolean(4, b);
        return this;
    }

    protected void toString(StringBuffer sb) throws IOException {
        int n;
        if (this.broadcast()) {
            this.addToString(sb, "broadcast");
        }
        if (this.keepAlive()) {
            this.addToString(sb, "keepalive");
        }
        if ((n = this.linger()) > 0) {
            this.addToString(sb, "linger=");
            this.addToString(sb, n);
        }
        if (this.outOfBandInline()) {
            this.addToString(sb, "oobinline");
        }
        if ((n = this.receiveBufferSize()) > 0) {
            this.addToString(sb, "rcvbuf=");
            this.addToString(sb, n);
        }
        if ((n = this.sendBufferSize()) > 0) {
            this.addToString(sb, "sndbuf=");
            this.addToString(sb, n);
        }
        if (this.reuseAddress()) {
            this.addToString(sb, "reuseaddr");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getInterfaces()[0].getName());
        sb.append('[');
        int i = sb.length();
        try {
            this.toString(sb);
        }
        catch (IOException x) {
            sb.setLength(i);
            sb.append("closed");
        }
        sb.append(']');
        return sb.toString();
    }

    static class IP
    extends SocketOptsImpl
    implements SocketOpts.IP {
        IP(Dispatcher d) {
            super(d);
        }

        public NetworkInterface multicastInterface() throws IOException {
            return this.getNetworkInterface(31);
        }

        public SocketOpts.IP multicastInterface(NetworkInterface ni) throws IOException {
            this.setNetworkInterface(31, ni);
            return this;
        }

        public boolean multicastLoop() throws IOException {
            return this.getBoolean(18);
        }

        public SocketOpts.IP multicastLoop(boolean b) throws IOException {
            this.setBoolean(18, b);
            return this;
        }

        public int typeOfService() throws IOException {
            return this.getInt(3);
        }

        public SocketOpts.IP typeOfService(int tos) throws IOException {
            this.setInt(3, tos);
            return this;
        }

        protected void toString(StringBuffer sb) throws IOException {
            super.toString(sb);
            int n = this.typeOfService();
            if (n > 0) {
                this.addToString(sb, "tos=");
                this.addToString(sb, n);
            }
        }

        public static class TCP
        extends IP
        implements SocketOpts.IP.TCP {
            TCP(Dispatcher d) {
                super(d);
            }

            public boolean noDelay() throws IOException {
                return this.getBoolean(1);
            }

            public SocketOpts.IP.TCP noDelay(boolean b) throws IOException {
                this.setBoolean(1, b);
                return this;
            }

            protected void toString(StringBuffer sb) throws IOException {
                super.toString(sb);
                if (this.noDelay()) {
                    this.addToString(sb, "nodelay");
                }
            }
        }
    }

    static abstract class Dispatcher {
        Dispatcher() {
        }

        abstract int getInt(int var1) throws IOException;

        abstract void setInt(int var1, int var2) throws IOException;
    }
}

