/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.SunToolkit;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsEnvironment;
import sun.font.XRTextRenderer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.java2d.x11.XSurfaceData;
import sun.java2d.xr.XRDrawImage;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRMaskBlit;
import sun.java2d.xr.XRMaskFill;
import sun.java2d.xr.XRPMBlitLoops;
import sun.java2d.xr.XRRenderer;
import sun.java2d.xr.XRSurfaceDataProxy;
import sun.java2d.xr.XRUtils;

public abstract class XRSurfaceData
extends XSurfaceData {
    X11ComponentPeer peer;
    XRGraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_BYTE_A8_X11 = "Byte A8 Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_INT_ARGB_X11 = "Integer ARGB-Pre Pixmap";
    public static final SurfaceType ByteA8X11 = SurfaceType.ByteGray.deriveSubType("Byte A8 Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType IntArgbX11 = SurfaceType.IntArgbPre.deriveSubType("Integer ARGB-Pre Pixmap");
    protected XRRenderer xrpipe;
    protected PixelToShapeConverter xrtxpipe;
    protected TextPipe xrtextpipe;
    protected XRDrawImage xrDrawImage;
    private long xgc;
    public static int validatedPixel = -1;
    public static int validatedPaintState = -1;
    private static Composite validatedComp;
    public static Paint validatedPaint;
    private Region validatedClip;
    private Region validatedGCClip;
    private boolean validatedExposures = true;
    private float validatedExtraAlpha = 1.0f;
    private int validatedFlags;
    private boolean transformInUse = false;
    private AffineTransform validatedSourceTransform = new AffineTransform();
    private int validatedRepeat = 0;
    private int validatedInterpolation = -1;
    private int preferredInterpolation = -1;
    private static LazyPipe lazypipe;

    private static native void initIDs(boolean var0);

    protected native void XRInitSurface(int var1, int var2, int var3, long var4, int var6);

    native void XRInitXRender(long var1, int var3);

    public Raster getRaster(int x, int y, int w, int h) {
        throw new InternalError("not implemented yet");
    }

    public static void initXRSurfaceData() {
        if (!X11GraphicsEnvironment.isX11SurfaceDataInitialized()) {
            boolean cacheGradients = true;
            String xProp = System.getProperty("sun.java2d.xrgradcache");
            if (xProp != null) {
                cacheGradients = !xProp.equalsIgnoreCase("false") && !xProp.equalsIgnoreCase("f");
            }
            XRSurfaceData.initIDs(cacheGradients);
            XRPMBlitLoops.register();
            XRMaskFill.register();
            XRMaskBlit.register();
            X11GraphicsEnvironment.setX11SurfaceDataInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isXRDrawableValid() {
        try {
            SunToolkit.awtLock();
            boolean bl = this.isDrawableValid();
            return bl;
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public SurfaceDataProxy makeProxyFor(SurfaceData srcData) {
        return XRSurfaceDataProxy.createProxy(srcData, this.graphicsConfig);
    }

    public void validatePipe(SunGraphics2D sg2d) {
        TextPipe textpipe;
        boolean validated = false;
        if (!(sg2d.compositeState >= 2 || sg2d.paintState >= 5 && sg2d.composite != null && sg2d.composite instanceof AlphaComposite && ((AlphaComposite)sg2d.composite).getAlpha() != 1.0f)) {
            textpipe = this.xrtextpipe;
        } else {
            super.validatePipe(sg2d);
            textpipe = sg2d.textpipe;
            validated = true;
        }
        PixelToShapeConverter txPipe = null;
        XRRenderer nonTxPipe = null;
        if (sg2d.antialiasHint != 2) {
            if (sg2d.paintState <= 1) {
                if (sg2d.compositeState < 2) {
                    txPipe = this.xrtxpipe;
                    nonTxPipe = this.xrpipe;
                }
            } else if (sg2d.compositeState <= 1 && XRSurfaceData.isPaintValid(sg2d)) {
                txPipe = this.xrtxpipe;
                nonTxPipe = this.xrpipe;
            }
        }
        if (txPipe != null) {
            if (sg2d.transformState >= 3) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = txPipe;
            } else if (sg2d.strokeState != 0) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = nonTxPipe;
            } else {
                sg2d.drawpipe = nonTxPipe;
                sg2d.fillpipe = nonTxPipe;
            }
            sg2d.shapepipe = nonTxPipe;
        } else if (!validated) {
            super.validatePipe(sg2d);
        }
        sg2d.textpipe = textpipe;
        sg2d.imagepipe = this.xrDrawImage;
    }

    protected MaskFill getMaskFill(SunGraphics2D sg2d) {
        if (sg2d.paintState > 1 && !XRSurfaceData.isPaintValid(sg2d)) {
            return null;
        }
        return super.getMaskFill(sg2d);
    }

    public RenderLoops getRenderLoops(SunGraphics2D sg2d) {
        if (sg2d.paintState <= 1 && sg2d.compositeState <= 1) {
            return this.solidloops;
        }
        return super.getRenderLoops(sg2d);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static XRWindowSurfaceData createData(X11ComponentPeer peer) {
        XRGraphicsConfig gc = XRSurfaceData.getGC(peer);
        return new XRWindowSurfaceData(peer, gc, gc.getSurfaceType());
    }

    public static XRPixmapSurfaceData createData(XRGraphicsConfig gc, int width, int height, ColorModel cm, Image image, long drawable, int transparency) {
        int depth = transparency > 1 ? 32 : 24;
        cm = depth == 24 ? new DirectColorModel(depth, 0xFF0000, 65280, 255) : new DirectColorModel(depth, 0xFF0000, 65280, 255, -16777216);
        return new XRPixmapSurfaceData(gc, width, height, image, XRSurfaceData.getSurfaceType(gc, transparency), cm, drawable, transparency, XRUtils.getPictureFormatForTransparency(transparency), depth);
    }

    protected XRSurfaceData(X11ComponentPeer peer, XRGraphicsConfig gc, SurfaceType sType, ColorModel cm, int depth, int transparency) {
        super(sType, cm);
        this.peer = peer;
        this.graphicsConfig = gc;
        this.solidloops = this.graphicsConfig.getSolidLoops(sType);
        this.depth = depth;
        this.initOps(peer, this.graphicsConfig, depth);
        this.setBlitProxyKey(gc.getProxyKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initXRender(int pictureFormat) {
        try {
            SunToolkit.awtLock();
            this.XRInitXRender(this.getNativeOps(), pictureFormat);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public static XRGraphicsConfig getGC(X11ComponentPeer peer) {
        if (peer != null) {
            return (XRGraphicsConfig)peer.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (XRGraphicsConfig)gd.getDefaultConfiguration();
    }

    public abstract boolean canSourceSendExposures(int var1, int var2, int var3, int var4);

    public void validateCopyAreaGC(Region gcClip, boolean needExposures) {
        if (this.validatedGCClip != gcClip) {
            if (gcClip != null) {
                XRSurfaceData.XSetClip(this.xgc, gcClip.getLoX(), gcClip.getLoY(), gcClip.getHiX(), gcClip.getHiY(), gcClip.isRectangular() ? null : gcClip);
            } else {
                XRSurfaceData.XResetClip(this.xgc);
            }
            this.validatedGCClip = gcClip;
        }
        if (this.validatedExposures != needExposures) {
            this.validatedExposures = needExposures;
            XRSurfaceData.XSetGraphicsExposures(this.xgc, needExposures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        if (this.xrpipe == null) {
            if (!this.isXRDrawableValid()) {
                return true;
            }
            this.makePipes();
        }
        CompositeType comptype = sg2d.imageComp;
        if (sg2d.transformState < 3 && (CompositeType.SrcOverNoEa.equals(comptype) || CompositeType.SrcNoEa.equals(comptype))) {
            x += sg2d.transX;
            y += sg2d.transY;
            try {
                SunToolkit.awtLock();
                boolean needExposures = this.canSourceSendExposures(x, y, w, h);
                this.validateCopyAreaGC(sg2d.getCompClip(), needExposures);
                this.xrpipe.devCopyArea(this.getNativeOps(), this.xgc, x, y, x + dx, y + dy, w, h);
            }
            finally {
                SunToolkit.awtUnlock();
            }
            return true;
        }
        return false;
    }

    public static SurfaceType getSurfaceType(XRGraphicsConfig gc, int transparency) {
        SurfaceType sType = null;
        switch (transparency) {
            case 1: {
                sType = IntRgbX11;
                break;
            }
            case 2: 
            case 3: {
                sType = IntArgbX11;
            }
        }
        return sType;
    }

    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    private static native void XRSetForeground(int var0);

    private static native void XRSetComposite(int var0, float var1);

    private static native void XRSetClip(long var0, int var2, int var3, int var4, int var5, Region var6);

    private static native void XRResetClip(long var0);

    private static native void XRSetTransformNative(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native void XRSetTexturePaint(long var0);

    private static native void XRResetPaint();

    private static native void XRSetRepeat(long var0, int var2);

    private static native void XRSetFilter(long var0, int var2);

    private static native void XRSetLinearGradientPaint(float[] var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10, int var11, int var12, int var13, int var14, int var15);

    private static native void XRSetRadialGradientPaint(float[] var0, int[] var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private void XRSetTransform(AffineTransform transform) {
        double[] transformData = new double[6];
        transform.getMatrix(transformData);
        XRSurfaceData.XRSetTransformNative(this.getNativeOps(), XRUtils.XDoubleToFixed(transformData[0]), XRUtils.XDoubleToFixed(transformData[2]), XRUtils.XDoubleToFixed(transformData[4]), XRUtils.XDoubleToFixed(transformData[1]), XRUtils.XDoubleToFixed(transformData[3]), XRUtils.XDoubleToFixed(transformData[5]));
    }

    public void setPreferredInterpolation(int interpolation) {
        this.preferredInterpolation = interpolation;
    }

    void validateAsSource(AffineTransform sxForm, int repeat) {
        this.validateAsSource(sxForm, repeat, this.preferredInterpolation);
    }

    void validateAsSource(AffineTransform sxForm, int repeat, int interpolation) {
        if (this.validatedClip != null) {
            this.validatedClip = null;
            XRSurfaceData.XRResetClip(this.getNativeOps());
        }
        if (this.validatedRepeat != repeat) {
            this.validatedRepeat = repeat;
            XRSurfaceData.XRSetRepeat(this.getNativeOps(), repeat);
        }
        if (sxForm == null) {
            if (this.transformInUse) {
                this.validatedSourceTransform.setToIdentity();
                this.XRSetTransform(this.validatedSourceTransform);
                this.transformInUse = false;
            }
        } else if (!this.transformInUse || this.transformInUse && !sxForm.equals(this.validatedSourceTransform)) {
            this.validatedSourceTransform.setTransform(sxForm.getScaleX(), sxForm.getShearY(), sxForm.getShearX(), sxForm.getScaleY(), sxForm.getTranslateX(), sxForm.getTranslateY());
            this.XRSetTransform(this.validatedSourceTransform);
            this.transformInUse = true;
        }
        if (interpolation != this.validatedInterpolation) {
            XRSurfaceData.XRSetFilter(this.getNativeOps(), interpolation);
            this.validatedInterpolation = interpolation;
        }
    }

    private void setComposite(Composite comp) {
        if (!(comp instanceof AlphaComposite)) {
            throw new InternalError("Composite accaleration not implemented for: " + comp.getClass().getName());
        }
        AlphaComposite aComp = (AlphaComposite)comp;
        this.validatedExtraAlpha = aComp.getAlpha();
        XRSurfaceData.XRSetComposite(XRUtils.j2dAlphaCompToXR(aComp.getRule()), this.validatedExtraAlpha);
    }

    public int[] convertToIntArgbPixels(Color[] colors, boolean linear) {
        int[] pixels = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            pixels[i] = this.colorToIntArgbPixel(colors[i], linear);
        }
        return pixels;
    }

    public int colorToIntArgbPixel(Color c, boolean linear) {
        int rgb = c.getRGB();
        int a = rgb >>> 24;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        if (linear) {
            r = BufferedPaints.convertSRGBtoLinearRGB(r);
            g = BufferedPaints.convertSRGBtoLinearRGB(g);
            b = BufferedPaints.convertSRGBtoLinearRGB(b);
        }
        a = (int)((float)a * this.validatedExtraAlpha);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static boolean isPaintValid(SunGraphics2D sg2d) {
        if (sg2d.paintState == 4) {
            RadialGradientPaint grad = (RadialGradientPaint)sg2d.paint;
            return grad.getFocusPoint().equals(grad.getCenterPoint());
        }
        return true;
    }

    private void setGradientPaint(SunGraphics2D sg2d, GradientPaint paint, boolean useMask) {
        int[] pixels = this.convertToIntArgbPixels(new Color[]{paint.getColor1(), paint.getColor2()}, false);
        float[] fractions = new float[]{0.0f, 1.0f};
        Point2D pt1 = paint.getPoint1();
        Point2D pt2 = paint.getPoint2();
        AffineTransform at = (AffineTransform)sg2d.transform.clone();
        try {
            at.invert();
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        double[] transformData = new double[6];
        at.getMatrix(transformData);
        int repeat = paint.isCyclic() ? 3 : 2;
        XRSurfaceData.XRSetLinearGradientPaint(fractions, pixels, XRUtils.XDoubleToFixed(pt1.getX()), XRUtils.XDoubleToFixed(pt1.getY()), XRUtils.XDoubleToFixed(pt2.getX()), XRUtils.XDoubleToFixed(pt2.getY()), 2, repeat, useMask, false, XRUtils.XDoubleToFixed(transformData[0]), XRUtils.XDoubleToFixed(transformData[2]), XRUtils.XDoubleToFixed(transformData[4]), XRUtils.XDoubleToFixed(transformData[1]), XRUtils.XDoubleToFixed(transformData[3]), XRUtils.XDoubleToFixed(transformData[5]));
    }

    public void setLinearGradientPaint(SunGraphics2D sg2d, LinearGradientPaint paint, boolean useMask) {
        boolean linear = paint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        Color[] colors = paint.getColors();
        int numStops = colors.length;
        Point2D pt1 = paint.getStartPoint();
        Point2D pt2 = paint.getEndPoint();
        AffineTransform at = paint.getTransform();
        at.preConcatenate(sg2d.transform);
        int cycleMethod = XRUtils.getRepeatForCycleMethod(paint.getCycleMethod());
        float[] fractions = paint.getFractions();
        int[] pixels = this.convertToIntArgbPixels(colors, linear);
        try {
            at.invert();
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        double[] transformData = new double[6];
        at.getMatrix(transformData);
        XRSurfaceData.XRSetLinearGradientPaint(fractions, pixels, XRUtils.XDoubleToFixed(pt1.getX()), XRUtils.XDoubleToFixed(pt1.getY()), XRUtils.XDoubleToFixed(pt2.getX()), XRUtils.XDoubleToFixed(pt2.getY()), numStops, cycleMethod, useMask, linear, XRUtils.XDoubleToFixed(transformData[0]), XRUtils.XDoubleToFixed(transformData[2]), XRUtils.XDoubleToFixed(transformData[4]), XRUtils.XDoubleToFixed(transformData[1]), XRUtils.XDoubleToFixed(transformData[3]), XRUtils.XDoubleToFixed(transformData[5]));
    }

    public void setRadialGradientPaint(SunGraphics2D sg2d, RadialGradientPaint paint) {
        boolean linear = paint.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        Color[] colors = paint.getColors();
        int numStops = colors.length;
        Point2D center = paint.getCenterPoint();
        Point2D focus = paint.getFocusPoint();
        int cycleMethod = XRUtils.getRepeatForCycleMethod(paint.getCycleMethod());
        float[] fractions = paint.getFractions();
        int[] pixels = this.convertToIntArgbPixels(colors, linear);
        float radius = paint.getRadius();
        double cx = center.getX();
        double cy = center.getY();
        double fx = focus.getX();
        double fy = focus.getY();
        AffineTransform at = paint.getTransform();
        at.preConcatenate(sg2d.transform);
        focus = at.transform(focus, focus);
        at.translate(cx, cy);
        at.rotate(fx - cx, fy - cy);
        try {
            at.invert();
        }
        catch (Exception e) {
            at.setToScale(0.0, 0.0);
        }
        focus = at.transform(focus, focus);
        fx = Math.min(focus.getX(), 0.99);
        double[] transformData = new double[6];
        at.getMatrix(transformData);
        XRSurfaceData.XRSetRadialGradientPaint(fractions, pixels, XRUtils.XDoubleToFixed(fx), numStops, cycleMethod, false, linear, XRUtils.XDoubleToFixed(0.0), XRUtils.XDoubleToFixed(radius), XRUtils.XDoubleToFixed(transformData[0]), XRUtils.XDoubleToFixed(transformData[2]), XRUtils.XDoubleToFixed(transformData[4]), XRUtils.XDoubleToFixed(transformData[1]), XRUtils.XDoubleToFixed(transformData[3]), XRUtils.XDoubleToFixed(transformData[5]));
    }

    private TexturePaint setTexturePaint(SunGraphics2D sg2d, TexturePaint paint, boolean useMask) {
        SurfaceData dstData = sg2d.surfaceData;
        BufferedImage bi = paint.getImage();
        SurfaceData srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null);
        if (!(srcData instanceof XRSurfaceData) && !((srcData = dstData.getSourceSurfaceData(paint.getImage(), 0, CompositeType.SrcOver, null)) instanceof XRSurfaceData)) {
            return null;
        }
        XRSurfaceData x11SrcData = (XRSurfaceData)srcData;
        AffineTransform at = (AffineTransform)sg2d.transform.clone();
        Rectangle2D anchor = paint.getAnchorRect();
        at.translate(anchor.getX(), anchor.getY());
        at.scale(anchor.getWidth() / (double)bi.getWidth(), anchor.getHeight() / (double)bi.getHeight());
        try {
            at.invert();
        }
        catch (NoninvertibleTransformException ex) {
            at.setToIdentity();
        }
        x11SrcData.validateAsSource(at, 1, XRUtils.ATransOpToXRQuality(sg2d.interpolationType));
        XRSurfaceData.XRSetTexturePaint(srcData.getNativeOps());
        return paint;
    }

    public void setPaint(SunGraphics2D sg2d, Paint paint) {
        if (sg2d != null) {
            if (sg2d.paintState <= 1) {
                XRSurfaceData.XRResetPaint();
            } else {
                switch (sg2d.paintState) {
                    case 2: {
                        this.setGradientPaint(sg2d, (GradientPaint)paint, false);
                        validatedPaint = paint;
                        break;
                    }
                    case 3: {
                        this.setLinearGradientPaint(sg2d, (LinearGradientPaint)paint, false);
                        validatedPaint = paint;
                        break;
                    }
                    case 4: {
                        this.setRadialGradientPaint(sg2d, (RadialGradientPaint)paint);
                        validatedPaint = paint;
                        break;
                    }
                    case 5: {
                        validatedPaint = this.setTexturePaint(sg2d, (TexturePaint)paint, false);
                        break;
                    }
                    default: {
                        throw new InternalError("should not reach");
                    }
                }
            }
        }
    }

    public void validate(Region clip, Composite comp, AffineTransform xform, Paint paint, SunGraphics2D sg2d, int flags) {
        boolean updatePaint;
        boolean updateClip = clip != this.validatedClip;
        boolean bl = updatePaint = paint != validatedPaint || paint == null;
        if (!this.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        if (updateClip) {
            if (clip != null) {
                XRSurfaceData.XRSetClip(this.getNativeOps(), clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY(), clip.isRectangular() ? null : clip);
            } else {
                XRSurfaceData.XRResetClip(this.getNativeOps());
            }
            this.validatedClip = clip;
        }
        if (comp != validatedComp || flags != this.validatedFlags) {
            if (comp != null) {
                this.setComposite(comp);
            } else {
                comp = AlphaComposite.getInstance(3);
                this.setComposite(comp);
            }
            updatePaint = true;
            validatedComp = comp;
            this.validatedFlags = flags;
        }
        if (sg2d != null && validatedPixel != sg2d.pixel) {
            validatedPixel = sg2d.pixel;
            XRSurfaceData.XRSetForeground(validatedPixel);
        }
        if (updatePaint) {
            if (paint != null) {
                this.setPaint(sg2d, paint);
            } else {
                XRSurfaceData.XRResetPaint();
            }
            validatedPaint = paint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePipes() {
        if (this.xrpipe == null) {
            try {
                SunToolkit.awtLock();
                this.xgc = XRSurfaceData.XCreateGC(this.getNativeOps());
                this.xrpipe = XRRenderer.getInstance();
                this.xrtxpipe = new PixelToShapeConverter(this.xrpipe);
                this.xrtextpipe = new XRTextRenderer();
                this.xrDrawImage = new XRDrawImage();
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
    }

    static {
        lazypipe = new LazyPipe();
    }

    public static class LazyPipe
    extends ValidatePipe {
        public boolean validate(SunGraphics2D sg2d) {
            XRSurfaceData xsd = (XRSurfaceData)sg2d.surfaceData;
            if (!xsd.isXRDrawableValid()) {
                return false;
            }
            xsd.makePipes();
            return super.validate(sg2d);
        }
    }

    public static class XRPixmapSurfaceData
    extends XRSurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;

        public XRPixmapSurfaceData(XRGraphicsConfig gc, int width, int height, Image image, SurfaceType sType, ColorModel cm, long drawable, int transparency, int pictFormat, int depth) {
            super(null, gc, sType, cm, depth, transparency);
            this.width = width;
            this.height = height;
            this.offscreenImage = image;
            this.transparency = transparency;
            this.initSurface(depth, width, height, drawable, pictFormat);
            this.makePipes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initSurface(int depth, int width, int height, long drawable, int pictFormat) {
            try {
                SunToolkit.awtLock();
                this.XRInitSurface(depth, width, height, drawable, pictFormat);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }

        public SurfaceData getReplacement() {
            return XRPixmapSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return x < 0 || y < 0 || x + w > this.width || y + h > this.height;
        }

        public void flush() {
            this.invalidate();
            this.flushNativeSurface();
        }

        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class XRWindowSurfaceData
    extends XRSurfaceData {
        public XRWindowSurfaceData(X11ComponentPeer peer, XRGraphicsConfig gc, SurfaceType sType) {
            super(peer, gc, sType, peer.getColorModel(), peer.getColorModel().getPixelSize(), 1);
            if (this.isXRDrawableValid()) {
                this.initXRender(XRUtils.getPictureFormatForTransparency(1));
                this.makePipes();
            }
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle r = this.peer.getBounds();
            r.y = 0;
            r.x = 0;
            return r;
        }

        public boolean canSourceSendExposures(int x, int y, int w, int h) {
            return true;
        }

        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

