/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.Color;
import java.awt.Transparency;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import sun.awt.X11GraphicsConfig;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.x11.X11SurfaceData;

public abstract class X11SurfaceDataProxy
extends SurfaceDataProxy
implements Transparency {
    X11GraphicsConfig x11gc;

    public static SurfaceDataProxy createProxy(SurfaceData srcData, X11GraphicsConfig dstConfig) {
        if (srcData instanceof X11SurfaceData) {
            return UNCACHED;
        }
        ColorModel cm = srcData.getColorModel();
        int transparency = cm.getTransparency();
        if (transparency == 1) {
            return new Opaque(dstConfig);
        }
        if (transparency == 2) {
            if (cm instanceof IndexColorModel && cm.getPixelSize() == 8) {
                return new Bitmask(dstConfig);
            }
            if (cm instanceof DirectColorModel) {
                DirectColorModel dcm = (DirectColorModel)cm;
                int colormask = dcm.getRedMask() | dcm.getGreenMask() | dcm.getBlueMask();
                int alphamask = dcm.getAlphaMask();
                if ((colormask & 0xFF000000) == 0 && (alphamask & 0xFF000000) != 0) {
                    return new Bitmask(dstConfig);
                }
            }
        }
        return UNCACHED;
    }

    public X11SurfaceDataProxy(X11GraphicsConfig x11gc) {
        this.x11gc = x11gc;
    }

    public SurfaceData validateSurfaceData(SurfaceData srcData, SurfaceData cachedData, int w, int h) {
        if (cachedData == null) {
            cachedData = X11SurfaceData.createData(this.x11gc, w, h, this.x11gc.getColorModel(), null, 0L, this.getTransparency());
        }
        return cachedData;
    }

    public static class Bitmask
    extends X11SurfaceDataProxy {
        public Bitmask(X11GraphicsConfig x11gc) {
            super(x11gc);
        }

        public int getTransparency() {
            return 2;
        }

        public boolean isSupportedOperation(SurfaceData srcData, int txtype, CompositeType comp, Color bgColor) {
            if (txtype >= 3) {
                return false;
            }
            if (bgColor != null && bgColor.getTransparency() != 1) {
                return false;
            }
            return CompositeType.SrcOverNoEa.equals(comp) || CompositeType.SrcNoEa.equals(comp) && bgColor != null;
        }
    }

    public static class Opaque
    extends X11SurfaceDataProxy {
        public Opaque(X11GraphicsConfig x11gc) {
            super(x11gc);
        }

        public int getTransparency() {
            return 1;
        }

        public boolean isSupportedOperation(SurfaceData srcData, int txtype, CompositeType comp, Color bgColor) {
            return txtype < 3 && (CompositeType.SrcOverNoEa.equals(comp) || CompositeType.SrcNoEa.equals(comp));
        }
    }
}

