/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.BitSet;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.TextAreaDocument;

public class FormView
extends ComponentView
implements ActionListener {
    @Deprecated
    public static final String SUBMIT = new String("Submit Query");
    @Deprecated
    public static final String RESET = new String("Reset");
    static final String PostDataProperty = "javax.swing.JEditorPane.postdata";
    private short maxIsPreferred;

    public FormView(Element elem) {
        super(elem);
    }

    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        HTML.Tag t = (HTML.Tag)attr.getAttribute(StyleConstants.NameAttribute);
        JComponent c = null;
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        if (t == HTML.Tag.INPUT) {
            c = this.createInputComponent(attr, model);
        } else if (t == HTML.Tag.SELECT) {
            if (model instanceof OptionListModel) {
                JList list = new JList((ListModel)model);
                int size = HTML.getIntegerAttributeValue(attr, HTML.Attribute.SIZE, 1);
                list.setVisibleRowCount(size);
                list.setSelectionModel((ListSelectionModel)model);
                c = new JScrollPane(list);
            } else {
                c = new JComboBox((ComboBoxModel)model);
                this.maxIsPreferred = (short)3;
            }
        } else if (t == HTML.Tag.TEXTAREA) {
            JTextArea area = new JTextArea((Document)model);
            int rows = HTML.getIntegerAttributeValue(attr, HTML.Attribute.ROWS, 1);
            area.setRows(rows);
            int cols = HTML.getIntegerAttributeValue(attr, HTML.Attribute.COLS, 20);
            this.maxIsPreferred = (short)3;
            area.setColumns(cols);
            c = new JScrollPane(area, 22, 32);
        }
        if (c != null) {
            c.setAlignmentY(1.0f);
        }
        return c;
    }

    private JComponent createInputComponent(AttributeSet attr, Object model) {
        JComponent c = null;
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        if (type.equals("submit") || type.equals("reset")) {
            String value = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if (value == null) {
                value = type.equals("submit") ? UIManager.getString("FormView.submitButtonText") : UIManager.getString("FormView.resetButtonText");
            }
            JButton button = new JButton(value);
            if (model != null) {
                button.setModel((ButtonModel)model);
                button.addActionListener(this);
            }
            c = button;
            this.maxIsPreferred = (short)3;
        } else if (type.equals("image")) {
            JButton button;
            String srcAtt = (String)attr.getAttribute(HTML.Attribute.SRC);
            try {
                URL base = ((HTMLDocument)this.getElement().getDocument()).getBase();
                URL srcURL = new URL(base, srcAtt);
                ImageIcon icon = new ImageIcon(srcURL);
                button = new JButton(icon);
            }
            catch (MalformedURLException e) {
                button = new JButton(srcAtt);
            }
            if (model != null) {
                button.setModel((ButtonModel)model);
                button.addMouseListener(new MouseEventListener());
            }
            c = button;
            this.maxIsPreferred = (short)3;
        } else if (type.equals("checkbox")) {
            c = new JCheckBox();
            if (model != null) {
                c.setModel((JToggleButton.ToggleButtonModel)model);
            }
            this.maxIsPreferred = (short)3;
        } else if (type.equals("radio")) {
            c = new JRadioButton();
            if (model != null) {
                ((JRadioButton)c).setModel((JToggleButton.ToggleButtonModel)model);
            }
            this.maxIsPreferred = (short)3;
        } else if (type.equals("text")) {
            JTextField field;
            int size = HTML.getIntegerAttributeValue(attr, HTML.Attribute.SIZE, -1);
            if (size > 0) {
                field = new JTextField();
                field.setColumns(size);
            } else {
                field = new JTextField();
                field.setColumns(20);
            }
            c = field;
            if (model != null) {
                field.setDocument((Document)model);
            }
            field.addActionListener(this);
            this.maxIsPreferred = (short)3;
        } else if (type.equals("password")) {
            int size;
            JPasswordField field = new JPasswordField();
            c = field;
            if (model != null) {
                field.setDocument((Document)model);
            }
            field.setColumns((size = HTML.getIntegerAttributeValue(attr, HTML.Attribute.SIZE, -1)) > 0 ? size : 20);
            field.addActionListener(this);
            this.maxIsPreferred = (short)3;
        } else if (type.equals("file")) {
            int size;
            JTextField field = new JTextField();
            if (model != null) {
                field.setDocument((Document)model);
            }
            field.setColumns((size = HTML.getIntegerAttributeValue(attr, HTML.Attribute.SIZE, -1)) > 0 ? size : 20);
            JButton browseButton = new JButton(UIManager.getString("FormView.browseFileButtonText"));
            Box box = Box.createHorizontalBox();
            box.add(field);
            box.add(Box.createHorizontalStrut(5));
            box.add(browseButton);
            browseButton.addActionListener(new BrowseFileAction(attr, (Document)model));
            c = box;
            this.maxIsPreferred = (short)3;
        }
        return c;
    }

    public float getMaximumSpan(int axis) {
        switch (axis) {
            case 0: {
                if ((this.maxIsPreferred & 1) == 1) {
                    super.getMaximumSpan(axis);
                    return this.getPreferredSpan(axis);
                }
                return super.getMaximumSpan(axis);
            }
            case 1: {
                if ((this.maxIsPreferred & 2) == 2) {
                    super.getMaximumSpan(axis);
                    return this.getPreferredSpan(axis);
                }
                return super.getMaximumSpan(axis);
            }
        }
        return super.getMaximumSpan(axis);
    }

    public void actionPerformed(ActionEvent evt) {
        Element element = this.getElement();
        StringBuffer dataBuffer = new StringBuffer();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        AttributeSet attr = element.getAttributes();
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        if (type.equals("submit")) {
            this.getFormData(dataBuffer);
            this.submitData(dataBuffer.toString());
        } else if (type.equals("reset")) {
            this.resetForm();
        } else if (type.equals("text") || type.equals("password")) {
            if (this.isLastTextOrPasswordField()) {
                this.getFormData(dataBuffer);
                this.submitData(dataBuffer.toString());
            } else {
                this.getComponent().transferFocus();
            }
        }
    }

    protected void submitData(String data) {
        URL actionURL;
        boolean isPostMethod;
        String method;
        Element form = this.getFormElement();
        AttributeSet attrs = form.getAttributes();
        HTMLDocument doc = (HTMLDocument)form.getDocument();
        URL base = doc.getBase();
        String target = (String)attrs.getAttribute(HTML.Attribute.TARGET);
        if (target == null) {
            target = "_self";
        }
        if ((method = (String)attrs.getAttribute(HTML.Attribute.METHOD)) == null) {
            method = "GET";
        }
        if (isPostMethod = (method = method.toLowerCase()).equals("post")) {
            this.storePostData(doc, target, data);
        }
        String action = (String)attrs.getAttribute(HTML.Attribute.ACTION);
        try {
            URL uRL = actionURL = action == null ? new URL(base.getProtocol(), base.getHost(), base.getPort(), base.getFile()) : new URL(base, action);
            if (!isPostMethod) {
                String query = data.toString();
                actionURL = new URL(actionURL + "?" + query);
            }
        }
        catch (MalformedURLException e) {
            actionURL = null;
        }
        final JEditorPane c = (JEditorPane)this.getContainer();
        HTMLEditorKit kit = (HTMLEditorKit)c.getEditorKit();
        FormSubmitEvent formEvent = null;
        if (!kit.isAutoFormSubmission() || doc.isFrameDocument()) {
            FormSubmitEvent.MethodType methodType = isPostMethod ? FormSubmitEvent.MethodType.POST : FormSubmitEvent.MethodType.GET;
            formEvent = new FormSubmitEvent(this, HyperlinkEvent.EventType.ACTIVATED, actionURL, form, target, methodType, data);
        }
        final FormSubmitEvent fse = formEvent;
        final URL url = actionURL;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (fse != null) {
                    c.fireHyperlinkUpdate(fse);
                } else {
                    try {
                        c.setPage(url);
                    }
                    catch (IOException e) {
                        UIManager.getLookAndFeel().provideErrorFeedback(c);
                    }
                }
            }
        });
    }

    private void storePostData(HTMLDocument doc, String target, String data) {
        FrameView.FrameEditorPane p;
        FrameView v;
        JEditorPane c;
        Document propDoc = doc;
        String propName = PostDataProperty;
        if (doc.isFrameDocument() && (c = (v = (p = (FrameView.FrameEditorPane)this.getContainer()).getFrameView()).getOutermostJEditorPane()) != null) {
            propDoc = c.getDocument();
            propName = propName + "." + target;
        }
        propDoc.putProperty(propName, data);
    }

    protected void imageSubmit(String imageData) {
        StringBuffer dataBuffer = new StringBuffer();
        Element elem = this.getElement();
        HTMLDocument hdoc = (HTMLDocument)elem.getDocument();
        this.getFormData(dataBuffer);
        if (dataBuffer.length() > 0) {
            dataBuffer.append('&');
        }
        dataBuffer.append(imageData);
        this.submitData(dataBuffer.toString());
    }

    private String getImageData(Point point) {
        String data;
        String mouseCoords = point.x + ":" + point.y;
        int sep = mouseCoords.indexOf(58);
        String x = mouseCoords.substring(0, sep);
        String y = mouseCoords.substring(++sep);
        String name = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        if (name == null || name.equals("")) {
            data = "x=" + x + "&y=" + y;
        } else {
            name = URLEncoder.encode(name);
            data = name + ".x" + "=" + x + "&" + name + ".y" + "=" + y;
        }
        return data;
    }

    private Element getFormElement() {
        for (Element elem = this.getElement(); elem != null; elem = elem.getParentElement()) {
            if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.FORM) continue;
            return elem;
        }
        return null;
    }

    void getFormData(StringBuffer buffer) {
        Element formE = this.getFormElement();
        if (formE != null) {
            Element next;
            ElementIterator it = new ElementIterator(formE);
            while ((next = it.next()) != null) {
                String type;
                if (!this.isControl(next) || (type = (String)next.getAttributes().getAttribute(HTML.Attribute.TYPE)) != null && type.equals("submit") && next != this.getElement() || type != null && type.equals("image")) continue;
                this.loadElementDataIntoBuffer(next, buffer);
            }
        }
    }

    private void loadElementDataIntoBuffer(Element elem, StringBuffer buffer) {
        AttributeSet attr = elem.getAttributes();
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        String value = null;
        HTML.Tag tag = (HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            value = this.getInputElementData(attr);
        } else if (tag == HTML.Tag.TEXTAREA) {
            value = this.getTextAreaData(attr);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attr, buffer);
        }
        if (name != null && value != null) {
            this.appendBuffer(buffer, name, value);
        }
    }

    private String getInputElementData(AttributeSet attr) {
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        String value = null;
        if (type.equals("text") || type.equals("password")) {
            Document doc = (Document)model;
            try {
                value = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                value = null;
            }
        } else if (type.equals("submit") || type.equals("hidden")) {
            value = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if (value == null) {
                value = "";
            }
        } else if (type.equals("radio") || type.equals("checkbox")) {
            ButtonModel m = (ButtonModel)model;
            if (m.isSelected() && (value = (String)attr.getAttribute(HTML.Attribute.VALUE)) == null) {
                value = "on";
            }
        } else if (type.equals("file")) {
            String path;
            Document doc = (Document)model;
            try {
                path = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                path = null;
            }
            if (path != null && path.length() > 0) {
                value = path;
            }
        }
        return value;
    }

    private String getTextAreaData(AttributeSet attr) {
        Document doc = (Document)attr.getAttribute(StyleConstants.ModelAttribute);
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private void loadSelectData(AttributeSet attr, StringBuffer buffer) {
        ComboBoxModel model;
        Option option;
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        Object m = attr.getAttribute(StyleConstants.ModelAttribute);
        if (m instanceof OptionListModel) {
            OptionListModel model2 = (OptionListModel)m;
            for (int i = 0; i < model2.getSize(); ++i) {
                if (!model2.isSelectedIndex(i)) continue;
                Option option2 = (Option)model2.getElementAt(i);
                this.appendBuffer(buffer, name, option2.getValue());
            }
        } else if (m instanceof ComboBoxModel && (option = (Option)(model = (ComboBoxModel)m).getSelectedItem()) != null) {
            this.appendBuffer(buffer, name, option.getValue());
        }
    }

    private void appendBuffer(StringBuffer buffer, String name, String value) {
        if (buffer.length() > 0) {
            buffer.append('&');
        }
        String encodedName = URLEncoder.encode(name);
        buffer.append(encodedName);
        buffer.append('=');
        String encodedValue = URLEncoder.encode(value);
        buffer.append(encodedValue);
    }

    private boolean isControl(Element elem) {
        return elem.isLeaf();
    }

    boolean isLastTextOrPasswordField() {
        Element parent = this.getFormElement();
        Element elem = this.getElement();
        if (parent != null) {
            Element next;
            ElementIterator it = new ElementIterator(parent);
            boolean found = false;
            while ((next = it.next()) != null) {
                String type;
                AttributeSet elemAttr;
                if (next == elem) {
                    found = true;
                    continue;
                }
                if (!found || !this.isControl(next) || !HTMLDocument.matchNameAttribute(elemAttr = next.getAttributes(), HTML.Tag.INPUT) || !"text".equals(type = (String)elemAttr.getAttribute(HTML.Attribute.TYPE)) && !"password".equals(type)) continue;
                return false;
            }
        }
        return true;
    }

    void resetForm() {
        Element parent = this.getFormElement();
        if (parent != null) {
            Element next;
            ElementIterator it = new ElementIterator(parent);
            while ((next = it.next()) != null) {
                if (!this.isControl(next)) continue;
                AttributeSet elemAttr = next.getAttributes();
                Object m = elemAttr.getAttribute(StyleConstants.ModelAttribute);
                if (m instanceof TextAreaDocument) {
                    TextAreaDocument doc = (TextAreaDocument)m;
                    doc.reset();
                    continue;
                }
                if (m instanceof PlainDocument) {
                    try {
                        String value;
                        PlainDocument doc = (PlainDocument)m;
                        doc.remove(0, doc.getLength());
                        if (!HTMLDocument.matchNameAttribute(elemAttr, HTML.Tag.INPUT) || (value = (String)elemAttr.getAttribute(HTML.Attribute.VALUE)) == null) continue;
                        doc.insertString(0, value, null);
                    }
                    catch (BadLocationException e) {}
                    continue;
                }
                if (m instanceof OptionListModel) {
                    OptionListModel model = (OptionListModel)m;
                    int size = model.getSize();
                    for (int i = 0; i < size; ++i) {
                        model.removeIndexInterval(i, i);
                    }
                    BitSet selectionRange = model.getInitialSelection();
                    for (int i = 0; i < selectionRange.size(); ++i) {
                        if (!selectionRange.get(i)) continue;
                        model.addSelectionInterval(i, i);
                    }
                    continue;
                }
                if (m instanceof OptionComboBoxModel) {
                    OptionComboBoxModel model = (OptionComboBoxModel)m;
                    Option option = model.getInitialSelection();
                    if (option == null) continue;
                    model.setSelectedItem(option);
                    continue;
                }
                if (!(m instanceof JToggleButton.ToggleButtonModel)) continue;
                boolean checked = (String)elemAttr.getAttribute(HTML.Attribute.CHECKED) != null;
                JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)m;
                model.setSelected(checked);
            }
        }
    }

    private class BrowseFileAction
    implements ActionListener {
        private AttributeSet attrs;
        private Document model;

        BrowseFileAction(AttributeSet attrs, Document model) {
            this.attrs = attrs;
            this.model = model;
        }

        public void actionPerformed(ActionEvent ae) {
            File selected;
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            if (fc.showOpenDialog(FormView.this.getContainer()) == 0 && (selected = fc.getSelectedFile()) != null) {
                try {
                    if (this.model.getLength() > 0) {
                        this.model.remove(0, this.model.getLength());
                    }
                    this.model.insertString(0, selected.getPath(), null);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
        }
    }

    protected class MouseEventListener
    extends MouseAdapter {
        protected MouseEventListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            String imageData = FormView.this.getImageData(evt.getPoint());
            FormView.this.imageSubmit(imageData);
        }
    }
}

