/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ProgressBarUI";
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    private static final int defaultMinimum = 0;
    private static final int defaultMaximum = 100;
    private static final int defaultOrientation = 0;
    protected transient ChangeEvent changeEvent = null;
    protected ChangeListener changeListener = null;
    private transient Format format;
    private boolean indeterminate;

    public JProgressBar() {
        this(0);
    }

    public JProgressBar(int orient) {
        this(orient, 0, 100);
    }

    public JProgressBar(int min, int max) {
        this(0, min, max);
    }

    public JProgressBar(int orient, int min, int max) {
        this.setModel(new DefaultBoundedRangeModel(min, 0, min, max));
        this.updateUI();
        this.setOrientation(orient);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public JProgressBar(BoundedRangeModel newModel) {
        this.setModel(newModel);
        this.updateUI();
        this.setOrientation(0);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        if (this.orientation != newOrientation) {
            switch (newOrientation) {
                case 0: 
                case 1: {
                    int oldOrientation = this.orientation;
                    this.orientation = newOrientation;
                    this.firePropertyChange("orientation", oldOrientation, newOrientation);
                    if (this.accessibleContext == null) break;
                    this.accessibleContext.firePropertyChange("AccessibleState", oldOrientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, this.orientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(newOrientation + " is not a legal orientation");
                }
            }
            this.revalidate();
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean b) {
        boolean oldValue = this.paintString;
        this.paintString = b;
        this.firePropertyChange("stringPainted", oldValue, this.paintString);
        if (this.paintString != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        if (this.format == null) {
            this.format = NumberFormat.getPercentInstance();
        }
        return this.format.format(new Double(this.getPercentComplete()));
    }

    public void setString(String s) {
        String oldValue = this.progressString;
        this.progressString = s;
        this.firePropertyChange("string", oldValue, this.progressString);
        if (this.progressString == null || oldValue == null || !this.progressString.equals(oldValue)) {
            this.repaint();
        }
    }

    public double getPercentComplete() {
        long span = this.model.getMaximum() - this.model.getMinimum();
        double currentValue = this.model.getValue();
        double pc = (currentValue - (double)this.model.getMinimum()) / (double)span;
        return pc;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean b) {
        boolean oldValue = this.paintBorder;
        this.paintBorder = b;
        this.firePropertyChange("borderPainted", oldValue, this.paintBorder);
        if (this.paintBorder != oldValue) {
            this.repaint();
        }
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel newModel) {
        BoundedRangeModel oldModel = this.getModel();
        if (newModel != oldModel) {
            if (oldModel != null) {
                oldModel.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            this.model = newModel;
            if (newModel != null) {
                this.changeListener = this.createChangeListener();
                newModel.addChangeListener(this.changeListener);
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", oldModel == null ? null : new Integer(oldModel.getValue()), newModel == null ? null : new Integer(newModel.getValue()));
            }
            if (this.model != null) {
                this.model.setExtent(0);
            }
            this.repaint();
        }
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setValue(int n) {
        BoundedRangeModel brm = this.getModel();
        int oldValue = brm.getValue();
        brm.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(oldValue), new Integer(brm.getValue()));
        }
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setIndeterminate(boolean newValue) {
        boolean oldValue = this.indeterminate;
        this.indeterminate = newValue;
        this.firePropertyChange("indeterminate", oldValue, this.indeterminate);
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String orientationString = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        String paintBorderString = this.paintBorder ? "true" : "false";
        String progressStringString = this.progressString != null ? this.progressString : "";
        String paintStringString = this.paintString ? "true" : "false";
        String indeterminateString = this.indeterminate ? "true" : "false";
        return super.paramString() + ",orientation=" + orientationString + ",paintBorder=" + paintBorderString + ",paintString=" + paintStringString + ",progressString=" + progressStringString + ",indeterminateString=" + indeterminateString;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJProgressBar() {
            super(JProgressBar.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (JProgressBar.this.getModel().getValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            if (JProgressBar.this.getOrientation() == 1) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JProgressBar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (n == null) {
                return false;
            }
            JProgressBar.this.setValue(n.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JProgressBar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JProgressBar.this.model.getMaximum() - JProgressBar.this.model.getExtent());
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JProgressBar.this.fireStateChanged();
        }
    }
}

