/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JCheckBox
extends JToggleButton
implements Accessible {
    public static final String BORDER_PAINTED_FLAT_CHANGED_PROPERTY = "borderPaintedFlat";
    private boolean flat = false;
    private static final String uiClassID = "CheckBoxUI";

    public JCheckBox() {
        this(null, null, false);
    }

    public JCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public JCheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JCheckBox(String text) {
        this(text, null, false);
    }

    public JCheckBox(Action a) {
        this();
        this.setAction(a);
    }

    public JCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public JCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public JCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setUIProperty("borderPainted", Boolean.FALSE);
        this.setHorizontalAlignment(10);
    }

    public void setBorderPaintedFlat(boolean b) {
        boolean oldValue = this.flat;
        this.flat = b;
        this.firePropertyChange(BORDER_PAINTED_FLAT_CHANGED_PROPERTY, oldValue, this.flat);
        if (b != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPaintedFlat() {
        return this.flat;
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    void setIconFromAction(Action a) {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJCheckBox
    extends JToggleButton.AccessibleJToggleButton {
        protected AccessibleJCheckBox() {
            super(JCheckBox.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

