/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    public abstract void write(int var1) throws IOException;

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(v >>> 8);
            this.byteBuf[1] = (byte)(v >>> 0);
        } else {
            this.byteBuf[0] = (byte)(v >>> 0);
            this.byteBuf[1] = (byte)(v >>> 8);
        }
        this.write(this.byteBuf, 0, 2);
    }

    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(v >>> 24);
            this.byteBuf[1] = (byte)(v >>> 16);
            this.byteBuf[2] = (byte)(v >>> 8);
            this.byteBuf[3] = (byte)(v >>> 0);
        } else {
            this.byteBuf[0] = (byte)(v >>> 0);
            this.byteBuf[1] = (byte)(v >>> 8);
            this.byteBuf[2] = (byte)(v >>> 16);
            this.byteBuf[3] = (byte)(v >>> 24);
        }
        this.write(this.byteBuf, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(v >>> 56);
            this.byteBuf[1] = (byte)(v >>> 48);
            this.byteBuf[2] = (byte)(v >>> 40);
            this.byteBuf[3] = (byte)(v >>> 32);
            this.byteBuf[4] = (byte)(v >>> 24);
            this.byteBuf[5] = (byte)(v >>> 16);
            this.byteBuf[6] = (byte)(v >>> 8);
            this.byteBuf[7] = (byte)(v >>> 0);
        } else {
            this.byteBuf[0] = (byte)(v >>> 0);
            this.byteBuf[1] = (byte)(v >>> 8);
            this.byteBuf[2] = (byte)(v >>> 16);
            this.byteBuf[3] = (byte)(v >>> 24);
            this.byteBuf[4] = (byte)(v >>> 32);
            this.byteBuf[5] = (byte)(v >>> 40);
            this.byteBuf[6] = (byte)(v >>> 48);
            this.byteBuf[7] = (byte)(v >>> 56);
        }
        this.write(this.byteBuf, 0, 4);
        this.write(this.byteBuf, 4, 4);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
            }
        }
        this.write(b, 0, len * 2);
    }

    public void writeUTF(String s) throws IOException {
        char c;
        int strlen = s.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int boff = 0;
        s.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("utflen > 65536!");
        }
        byte[] b = new byte[utflen + 2];
        b[boff++] = (byte)(utflen >>> 8 & 0xFF);
        b[boff++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                b[boff++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                b[boff++] = (byte)(0xE0 | c >> 12 & 0xF);
                b[boff++] = (byte)(0x80 | c >> 6 & 0x3F);
                b[boff++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            b[boff++] = (byte)(0xC0 | c >> 6 & 0x1F);
            b[boff++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.write(b, 0, utflen + 2);
    }

    public void writeShorts(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                short v = s[off + i];
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                short v = s[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
            }
        }
        this.write(b, 0, len * 2);
    }

    public void writeChars(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                char v = c[off + i];
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char v = c[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
            }
        }
        this.write(b, 0, len * 2);
    }

    public void writeInts(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 4];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                int v = i[off + j];
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int j = 0; j < len; ++j) {
                int v = i[off + j];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
            }
        }
        this.write(b, 0, len * 4);
    }

    public void writeLongs(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        byte[] b = new byte[len * 8];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                long v = l[off + i];
                b[boff++] = (byte)(v >>> 56);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long v = l[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 56);
            }
        }
        this.write(b, 0, len * 8);
    }

    public void writeFloats(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        byte[] b = new byte[len * 4];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                int v = Float.floatToIntBits(f[off + i]);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int v = Float.floatToIntBits(f[off + i]);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
            }
        }
        this.write(b, 0, len * 4);
    }

    public void writeDoubles(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        byte[] b = new byte[len * 8];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                long v = Double.doubleToLongBits(d[off + i]);
                b[boff++] = (byte)(v >>> 56);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long v = Double.doubleToLongBits(d[off + i]);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 56);
            }
        }
        this.write(b, 0, len * 8);
    }

    public void writeBit(int bit) throws IOException {
        this.writeBits(1L & (long)bit, 1);
    }

    public void writeBits(long bits, int numBits) throws IOException {
        int shift;
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException("Bad value for numBits!");
        }
        if (numBits == 0) {
            return;
        }
        if (this.getStreamPosition() > 0L || this.bitOffset > 0) {
            int mask;
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partialByte = 0;
            }
            if (numBits + offset < 8) {
                shift = 8 - (offset + numBits);
                mask = -1 >>> 32 - numBits;
                partialByte &= ~(mask << shift);
                partialByte = (int)((long)partialByte | (bits & (long)mask) << shift);
                this.write(partialByte);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = offset + numBits;
                numBits = 0;
            } else {
                int num = 8 - offset;
                mask = -1 >>> 32 - num;
                partialByte &= ~mask;
                partialByte = (int)((long)partialByte | bits >> numBits - num & (long)mask);
                this.write(partialByte);
                numBits -= num;
            }
        }
        if (numBits > 7) {
            int extra = numBits % 8;
            for (int numBytes = numBits / 8; numBytes > 0; --numBytes) {
                shift = (numBytes - 1) * 8 + extra;
                int value = (int)(shift == 0 ? bits & 0xFFL : bits >> shift & 0xFFL);
                this.write(value);
            }
            numBits = extra;
        }
        if (numBits != 0) {
            int partialByte = 0;
            partialByte = this.read();
            if (partialByte != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partialByte = 0;
            }
            int shift2 = 8 - numBits;
            int mask = -1 >>> 32 - numBits;
            partialByte &= ~(mask << shift2);
            partialByte = (int)((long)partialByte | (bits & (long)mask) << shift2);
            this.write(partialByte);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = numBits;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte < 0) {
                partialByte = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                partialByte &= -1 << 8 - offset;
            }
            this.write(partialByte);
        }
    }
}

