/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyRep
implements Serializable {
    private static final long serialVersionUID = -4757683898830641853L;
    private static final String PKCS8 = "PKCS#8";
    private static final String X509 = "X.509";
    private static final String RAW = "RAW";
    private Type type;
    private String algorithm;
    private String format;
    private byte[] encoded;

    public KeyRep(Type type, String algorithm, String format, byte[] encoded) {
        if (type == null || algorithm == null || format == null || encoded == null) {
            throw new NullPointerException("invalid null input(s)");
        }
        this.type = type;
        this.algorithm = algorithm;
        this.format = format.toUpperCase();
        this.encoded = (byte[])encoded.clone();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            if (this.type == Type.SECRET && RAW.equals(this.format)) {
                return new SecretKeySpec(this.encoded, this.algorithm);
            }
            if (this.type == Type.PUBLIC && X509.equals(this.format)) {
                KeyFactory f = KeyFactory.getInstance(this.algorithm);
                return f.generatePublic(new X509EncodedKeySpec(this.encoded));
            }
            if (this.type == Type.PRIVATE && PKCS8.equals(this.format)) {
                KeyFactory f = KeyFactory.getInstance(this.algorithm);
                return f.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
            }
            throw new NotSerializableException("unrecognized type/format combination: " + (Object)((Object)this.type) + "/" + this.format);
        }
        catch (NotSerializableException nse) {
            throw nse;
        }
        catch (Exception e) {
            NotSerializableException nse = new NotSerializableException("java.security.Key: [" + (Object)((Object)this.type) + "] " + "[" + this.algorithm + "] " + "[" + this.format + "]");
            nse.initCause(e);
            throw nse;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SECRET,
        PUBLIC,
        PRIVATE;

    }
}

