/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivationGroupDesc
implements Serializable {
    private String className;
    private String location;
    private MarshalledObject<?> data;
    private CommandEnvironment env;
    private Properties props;
    private static final long serialVersionUID = -4936225423168276595L;

    public ActivationGroupDesc(Properties overrides, CommandEnvironment cmd) {
        this(null, null, null, overrides, cmd);
    }

    public ActivationGroupDesc(String className, String location, MarshalledObject<?> data, Properties overrides, CommandEnvironment cmd) {
        this.props = overrides;
        this.env = cmd;
        this.data = data;
        this.location = location;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject<?> getData() {
        return this.data;
    }

    public Properties getPropertyOverrides() {
        return this.props != null ? (Properties)this.props.clone() : null;
    }

    public CommandEnvironment getCommandEnvironment() {
        return this.env;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationGroupDesc) {
            ActivationGroupDesc desc = (ActivationGroupDesc)obj;
            return (this.className == null ? desc.className == null : this.className.equals(desc.className)) && (this.location == null ? desc.location == null : this.location.equals(desc.location)) && (this.data == null ? desc.data == null : this.data.equals(desc.data)) && (this.env == null ? desc.env == null : this.env.equals(desc.env)) && (this.props == null ? desc.props == null : this.props.equals(desc.props));
        }
        return false;
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode() << 24) ^ (this.env == null ? 0 : this.env.hashCode() << 16) ^ (this.className == null ? 0 : this.className.hashCode() << 8) ^ (this.data == null ? 0 : this.data.hashCode());
    }

    public static class CommandEnvironment
    implements Serializable {
        private static final long serialVersionUID = 6165754737887770191L;
        private String command;
        private String[] options;

        public CommandEnvironment(String cmdpath, String[] argv) {
            this.command = cmdpath;
            if (argv == null) {
                this.options = new String[0];
            } else {
                this.options = new String[argv.length];
                System.arraycopy(argv, 0, this.options, 0, argv.length);
            }
        }

        public String getCommandPath() {
            return this.command;
        }

        public String[] getCommandOptions() {
            return (String[])this.options.clone();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CommandEnvironment) {
                CommandEnvironment env = (CommandEnvironment)obj;
                return (this.command == null ? env.command == null : this.command.equals(env.command)) && Arrays.equals(this.options, env.options);
            }
            return false;
        }

        public int hashCode() {
            return this.command == null ? 0 : this.command.hashCode();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.options == null) {
                this.options = new String[0];
            }
        }
    }
}

