/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.StandardMBeanIntrospector;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.mbeanserver.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    private Introspector() {
    }

    public static final boolean isDynamic(Class c) {
        return DynamicMBean.class.isAssignableFrom(c);
    }

    public static void testCreation(Class c) throws NotCompliantMBeanException {
        int mods = c.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] consList = c.getConstructors();
        if (consList.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static void checkCompliance(Class mbeanClass) throws NotCompliantMBeanException {
        if (DynamicMBean.class.isAssignableFrom(mbeanClass)) {
            return;
        }
        try {
            Introspector.getStandardMBeanInterface(mbeanClass);
            return;
        }
        catch (NotCompliantMBeanException e) {
            NotCompliantMBeanException mbeanException = e;
            try {
                Introspector.getMXBeanInterface(mbeanClass);
                return;
            }
            catch (NotCompliantMBeanException e2) {
                NotCompliantMBeanException mxbeanException = e2;
                String msg = "MBean class " + mbeanClass.getName() + " does not implement " + "DynamicMBean, neither follows the Standard MBean conventions (" + mbeanException.toString() + ") nor the MXBean conventions (" + mxbeanException.toString() + ")";
                throw new NotCompliantMBeanException(msg);
            }
        }
    }

    public static DynamicMBean makeDynamicMBean(Object mbean) throws NotCompliantMBeanException {
        if (mbean instanceof DynamicMBean) {
            return (DynamicMBean)mbean;
        }
        Class<?> mbeanClass = mbean.getClass();
        Class c = null;
        try {
            c = Introspector.getStandardMBeanInterface(mbeanClass);
        }
        catch (NotCompliantMBeanException e) {
            // empty catch block
        }
        if (c != null) {
            return new StandardMBeanSupport(mbean, (Class)Util.cast(c));
        }
        try {
            c = Introspector.getMXBeanInterface(mbeanClass);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (c != null) {
            return new MXBeanSupport(mbean, (Class)Util.cast(c));
        }
        Introspector.checkCompliance(mbeanClass);
        throw new NotCompliantMBeanException("Not compliant");
    }

    public static MBeanInfo testCompliance(Class baseClass) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        return Introspector.testCompliance(baseClass, null);
    }

    public static void testComplianceMXBeanInterface(Class interfaceClass) throws NotCompliantMBeanException {
        MXBeanIntrospector.getInstance().getAnalyzer(interfaceClass);
    }

    public static synchronized MBeanInfo testCompliance(Class<?> baseClass, Class<?> mbeanInterface) throws NotCompliantMBeanException {
        if (mbeanInterface == null) {
            mbeanInterface = Introspector.getStandardMBeanInterface(baseClass);
        }
        StandardMBeanIntrospector introspector = StandardMBeanIntrospector.getInstance();
        return Introspector.getClassMBeanInfo(introspector, baseClass, mbeanInterface);
    }

    private static <M> MBeanInfo getClassMBeanInfo(MBeanIntrospector<M> introspector, Class<?> baseClass, Class<?> mbeanInterface) throws NotCompliantMBeanException {
        PerInterface<M> perInterface = introspector.getPerInterface(mbeanInterface);
        return introspector.getClassMBeanInfo(baseClass, perInterface);
    }

    public static Class getMBeanInterface(Class baseClass) {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        try {
            return Introspector.getStandardMBeanInterface(baseClass);
        }
        catch (NotCompliantMBeanException e) {
            return null;
        }
    }

    public static Class getStandardMBeanInterface(Class baseClass) throws NotCompliantMBeanException {
        Class mbeanInterface = null;
        for (Class current = baseClass; current != null && (mbeanInterface = Introspector.findMBeanInterface(current, current.getName())) == null; current = current.getSuperclass()) {
        }
        if (mbeanInterface != null) {
            return mbeanInterface;
        }
        String msg = "Class " + baseClass.getName() + " is not a JMX compliant Standard MBean";
        throw new NotCompliantMBeanException(msg);
    }

    public static Class getMXBeanInterface(Class baseClass) throws NotCompliantMBeanException {
        try {
            return MXBeanSupport.findMXBeanInterface(baseClass);
        }
        catch (Exception e) {
            throw Introspector.throwException(baseClass, e);
        }
    }

    private static Class findMBeanInterface(Class aClass, String aName) {
        for (Class current = aClass; current != null; current = current.getSuperclass()) {
            Class<?>[] interfaces = current.getInterfaces();
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Class inter = Introspector.implementsMBean(interfaces[i], aName);
                if (inter == null) continue;
                return inter;
            }
        }
        return null;
    }

    public static Descriptor descriptorForElement(AnnotatedElement elmt) {
        if (elmt == null) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        Annotation[] annots = elmt.getAnnotations();
        return Introspector.descriptorForAnnotations(annots);
    }

    public static Descriptor descriptorForAnnotations(Annotation[] annots) {
        if (annots.length == 0) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> descriptorMap = new HashMap<String, Object>();
        for (Annotation a : annots) {
            Method[] elements;
            Class<? extends Annotation> c = a.annotationType();
            for (Method element : elements = c.getMethods()) {
                Object value;
                DescriptorKey key = element.getAnnotation(DescriptorKey.class);
                if (key == null) continue;
                String name = key.value();
                try {
                    value = element.invoke(a, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
                value = Introspector.annotationToField(value);
                Object oldValue = descriptorMap.put(name, value);
                if (oldValue == null || Introspector.equals(oldValue, value)) continue;
                String msg = "Inconsistent values for descriptor field " + name + " from annotations: " + value + " :: " + oldValue;
                throw new IllegalArgumentException(msg);
            }
        }
        if (descriptorMap.isEmpty()) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor(descriptorMap);
    }

    static NotCompliantMBeanException throwException(Class<?> notCompliant, Throwable cause) throws NotCompliantMBeanException, SecurityException {
        if (cause instanceof SecurityException) {
            throw (SecurityException)cause;
        }
        if (cause instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)cause;
        }
        String classname = notCompliant == null ? "null class" : notCompliant.getName();
        String reason = cause == null ? "Not compliant" : cause.getMessage();
        NotCompliantMBeanException res = new NotCompliantMBeanException(classname + ": " + reason);
        res.initCause(cause);
        throw res;
    }

    private static Object annotationToField(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Number || x instanceof String || x instanceof Character || x instanceof Boolean || x instanceof String[]) {
            return x;
        }
        Class<?> c = x.getClass();
        if (c.isArray()) {
            if (c.getComponentType().isPrimitive()) {
                return x;
            }
            Object[] xx = (Object[])x;
            String[] ss = new String[xx.length];
            for (int i = 0; i < xx.length; ++i) {
                ss[i] = (String)Introspector.annotationToField(xx[i]);
            }
            return ss;
        }
        if (x instanceof Class) {
            return ((Class)x).getName();
        }
        if (x instanceof Enum) {
            return ((Enum)x).name();
        }
        throw new IllegalArgumentException("Illegal type for annotation element: " + x.getClass().getName());
    }

    private static boolean equals(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    private static Class implementsMBean(Class c, String clName) {
        String clMBeanName = clName + "MBean";
        if (c.getName().equals(clMBeanName)) {
            return c;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(clMBeanName)) continue;
            return interfaces[i];
        }
        return null;
    }
}

