/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class MotifScrollBarButton
extends BasicArrowButton {
    private Color darkShadow = UIManager.getColor("controlShadow");
    private Color lightShadow = UIManager.getColor("controlLtHighlight");

    public MotifScrollBarButton(int direction) {
        super(direction);
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                this.direction = direction;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        this.setRequestFocusEnabled(false);
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("ScrollBar.background"));
        this.setForeground(UIManager.getColor("ScrollBar.foreground"));
    }

    public Dimension getPreferredSize() {
        switch (this.direction) {
            case 1: 
            case 5: {
                return new Dimension(11, 12);
            }
        }
        return new Dimension(12, 11);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics g) {
        boolean isPressed;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        Color lead = (isPressed = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
        Color trail = isPressed ? this.lightShadow : this.darkShadow;
        Color fill = this.getBackground();
        int cx = w / 2;
        int cy = h / 2;
        int s = Math.min(w, h);
        switch (this.direction) {
            case 1: {
                g.setColor(lead);
                g.drawLine(cx, 0, cx, 0);
                int x = cx - 1;
                int dx = 1;
                for (int y = 1; y <= s - 2; y += 2) {
                    g.setColor(lead);
                    g.drawLine(x, y, x, y);
                    if (y >= s - 2) {
                        g.drawLine(x, y + 1, x, y + 1);
                    }
                    g.setColor(fill);
                    g.drawLine(x + 1, y, x + dx, y);
                    if (y < s - 2) {
                        g.drawLine(x, y + 1, x + dx + 1, y + 1);
                    }
                    g.setColor(trail);
                    g.drawLine(x + dx + 1, y, x + dx + 1, y);
                    if (y >= s - 2) {
                        g.drawLine(x + 1, y + 1, x + dx + 1, y + 1);
                    }
                    dx += 2;
                    --x;
                }
                break;
            }
            case 5: {
                g.setColor(trail);
                g.drawLine(cx, s, cx, s);
                int x = cx - 1;
                int dx = 1;
                for (int y = s - 1; y >= 1; y -= 2) {
                    g.setColor(lead);
                    g.drawLine(x, y, x, y);
                    if (y <= 2) {
                        g.drawLine(x, y - 1, x + dx + 1, y - 1);
                    }
                    g.setColor(fill);
                    g.drawLine(x + 1, y, x + dx, y);
                    if (y > 2) {
                        g.drawLine(x, y - 1, x + dx + 1, y - 1);
                    }
                    g.setColor(trail);
                    g.drawLine(x + dx + 1, y, x + dx + 1, y);
                    dx += 2;
                    --x;
                }
                break;
            }
            case 3: {
                g.setColor(lead);
                g.drawLine(s, cy, s, cy);
                int y = cy - 1;
                int dy = 1;
                for (int x = s - 1; x >= 1; x -= 2) {
                    g.setColor(lead);
                    g.drawLine(x, y, x, y);
                    if (x <= 2) {
                        g.drawLine(x - 1, y, x - 1, y + dy + 1);
                    }
                    g.setColor(fill);
                    g.drawLine(x, y + 1, x, y + dy);
                    if (x > 2) {
                        g.drawLine(x - 1, y, x - 1, y + dy + 1);
                    }
                    g.setColor(trail);
                    g.drawLine(x, y + dy + 1, x, y + dy + 1);
                    dy += 2;
                    --y;
                }
                break;
            }
            case 7: {
                g.setColor(trail);
                g.drawLine(0, cy, 0, cy);
                int y = cy - 1;
                int dy = 1;
                for (int x = 1; x <= s - 2; x += 2) {
                    g.setColor(lead);
                    g.drawLine(x, y, x, y);
                    if (x >= s - 2) {
                        g.drawLine(x + 1, y, x + 1, y);
                    }
                    g.setColor(fill);
                    g.drawLine(x, y + 1, x, y + dy);
                    if (x < s - 2) {
                        g.drawLine(x + 1, y, x + 1, y + dy + 1);
                    }
                    g.setColor(trail);
                    g.drawLine(x, y + dy + 1, x, y + dy + 1);
                    if (x >= s - 2) {
                        g.drawLine(x + 1, y + 1, x + 1, y + dy + 1);
                    }
                    dy += 2;
                    --y;
                }
                break;
            }
        }
    }
}

