/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XNodeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTree
extends JTree {
    private static final List<String> orderedKeyPropertyList = new ArrayList<String>();
    private MBeansTab mbeansTab;
    private Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
    private boolean treeView;
    private boolean treeViewInit = false;
    private boolean keyValueView = Boolean.getBoolean("keyValueView");

    public XTree(MBeansTab mbeansTab) {
        this((TreeNode)new DefaultMutableTreeNode("MBeanTreeRootNode"), mbeansTab);
    }

    public XTree(TreeNode root, MBeansTab mbeansTab) {
        super(root);
        this.mbeansTab = mbeansTab;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private synchronized void removeChildNode(DefaultMutableTreeNode child) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.removeNodeFromParent(child);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child, int index) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        boolean rootLeaf = root.isLeaf();
        model.insertNodeInto(child, parent, index);
        if (rootLeaf) {
            model.nodeStructureChanged(root);
        }
    }

    private synchronized void addChildNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            this.addChildNode(parent, child, 0);
        } else if (child instanceof ComparableDefaultMutableTreeNode) {
            int i;
            ComparableDefaultMutableTreeNode comparableChild = (ComparableDefaultMutableTreeNode)child;
            for (i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode brother = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (comparableChild.compareTo(brother) < 0) {
                    this.addChildNode(parent, child, i);
                    break;
                }
                if (comparableChild.compareTo(brother) != 0) continue;
                this.addChildNode(parent, child, i);
                break;
            }
            if (i == childCount) {
                this.addChildNode(parent, child, childCount);
            }
        } else {
            this.addChildNode(parent, child, childCount);
        }
    }

    @Override
    public synchronized void removeAll() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        model.nodeStructureChanged(root);
        this.nodes.clear();
    }

    public void delMBeanFromView(final ObjectName mbean) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XTree.this;
                synchronized (xTree) {
                    DefaultMutableTreeNode node = null;
                    Dn dn = XTree.this.buildDn(mbean);
                    if (dn.size() > 0) {
                        DefaultTreeModel model = (DefaultTreeModel)XTree.this.getModel();
                        Token token = dn.getToken(0);
                        String hashKey = dn.getHashKey(token);
                        node = (DefaultMutableTreeNode)XTree.this.nodes.get(hashKey);
                        if (node != null && !node.isRoot()) {
                            if (XTree.this.hasMBeanChildren(node)) {
                                XTree.this.removeNonMBeanChildren(node);
                                String label = token.getValue().toString();
                                XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, token.toString());
                                XTree.this.changeNodeValue(node, userObject);
                            } else {
                                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                                model.removeNodeFromParent(node);
                                XTree.this.nodes.remove(hashKey);
                                XTree.this.delParentFromView(dn, 1, parent);
                            }
                        }
                    }
                }
            }
        });
    }

    private boolean hasMBeanChildren(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!((XNodeInfo)n.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) continue;
            return true;
        }
        return false;
    }

    private void removeNonMBeanChildren(DefaultMutableTreeNode node) {
        HashSet<DefaultMutableTreeNode> metadataNodes = new HashSet<DefaultMutableTreeNode>();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (((XNodeInfo)n.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) continue;
            metadataNodes.add(n);
        }
        for (DefaultMutableTreeNode n : metadataNodes) {
            model.removeNodeFromParent(n);
        }
    }

    private DefaultMutableTreeNode delParentFromView(Dn dn, int index, DefaultMutableTreeNode node) {
        if (!node.isRoot() && node.isLeaf() && !((XNodeInfo)node.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            this.removeChildNode(node);
            String hashKey = dn.getHashKey(dn.getToken(index));
            this.nodes.remove(hashKey);
            this.delParentFromView(dn, index + 1, parent);
        }
        return node;
    }

    public synchronized void addMBeanToView(final ObjectName mbean) {
        XMBean xmbean;
        try {
            xmbean = new XMBean(mbean, this.mbeansTab);
            if (xmbean == null) {
                return;
            }
        }
        catch (Exception e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XTree.this;
                synchronized (xTree) {
                    Dn dn = XTree.this.buildDn(mbean);
                    if (dn.size() == 0) {
                        return;
                    }
                    Token token = dn.getToken(0);
                    DefaultMutableTreeNode node = null;
                    boolean nodeCreated = true;
                    String hashKey = dn.getHashKey(token);
                    if (XTree.this.nodes.containsKey(hashKey)) {
                        node = (DefaultMutableTreeNode)XTree.this.nodes.get(hashKey);
                        Object data = XTree.this.createNodeValue(xmbean, token);
                        String label = data.toString();
                        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.MBEAN, data, label, mbean.toString());
                        XTree.this.changeNodeValue(node, userObject);
                        nodeCreated = false;
                    } else {
                        node = XTree.this.createDnNode(dn, token, xmbean);
                        if (node != null) {
                            XTree.this.nodes.put(hashKey, node);
                            nodeCreated = true;
                        } else {
                            return;
                        }
                    }
                    for (int i = 1; i < dn.size(); ++i) {
                        DefaultMutableTreeNode currentNode = null;
                        token = dn.getToken(i);
                        hashKey = dn.getHashKey(token);
                        if (XTree.this.nodes.containsKey(hashKey)) {
                            if (nodeCreated) {
                                currentNode = (DefaultMutableTreeNode)XTree.this.nodes.get(hashKey);
                                XTree.this.addChildNode(currentNode, node);
                                return;
                            }
                            return;
                        }
                        if (token.getKeyDn().equals("domain")) {
                            currentNode = XTree.this.createDomainNode(dn, token);
                            if (currentNode != null) {
                                DefaultMutableTreeNode root = (DefaultMutableTreeNode)XTree.this.getModel().getRoot();
                                XTree.this.addChildNode(root, currentNode);
                            }
                        } else {
                            currentNode = XTree.this.createSubDnNode(dn, token);
                            if (currentNode == null) continue;
                        }
                        XTree.this.nodes.put(hashKey, currentNode);
                        XTree.this.addChildNode(currentNode, node);
                        nodeCreated = true;
                        node = currentNode;
                    }
                }
            }
        });
    }

    private synchronized void changeNodeValue(DefaultMutableTreeNode node, XNodeInfo nodeValue) {
        DefaultTreeModel model;
        if (node instanceof ComparableDefaultMutableTreeNode) {
            DefaultMutableTreeNode clone = (DefaultMutableTreeNode)node.clone();
            clone.setUserObject(nodeValue);
            if (((ComparableDefaultMutableTreeNode)node).compareTo(clone) == 0) {
                node.setUserObject(nodeValue);
                DefaultTreeModel model2 = (DefaultTreeModel)this.getModel();
                model2.nodeChanged(node);
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this.removeChildNode(node);
                node.setUserObject(nodeValue);
                this.addChildNode(parent, node);
            }
        } else {
            node.setUserObject(nodeValue);
            model = (DefaultTreeModel)this.getModel();
            model.nodeChanged(node);
        }
        if (nodeValue.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            XMBeanInfo.loadInfo(node);
            model = (DefaultTreeModel)this.getModel();
            model.nodeStructureChanged(node);
        }
        if (node == this.getLastSelectedPathComponent()) {
            TreePath selectionPath = this.getSelectionPath();
            this.clearSelection();
            this.setSelectionPath(selectionPath);
        }
    }

    private DefaultMutableTreeNode createDomainNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        String label = dn.getDomain();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, label);
        node.setUserObject(userObject);
        return node;
    }

    private DefaultMutableTreeNode createDnNode(Dn dn, Token token, XMBean xmbean) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        Object data = this.createNodeValue(xmbean, token);
        String label = data.toString();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.MBEAN, data, label, xmbean.getObjectName().toString());
        node.setUserObject(userObject);
        XMBeanInfo.loadInfo(node);
        return node;
    }

    private DefaultMutableTreeNode createSubDnNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        String label = this.isKeyValueView() ? token.toString() : token.getValue().toString();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, token.toString());
        node.setUserObject(userObject);
        return node;
    }

    private Object createNodeValue(XMBean xmbean, Token token) {
        String label = this.isKeyValueView() ? token.toString() : token.getValue().toString();
        xmbean.setText(label);
        return xmbean;
    }

    private Map<String, String> extractKeyValuePairs(String properties, ObjectName mbean) {
        String props = properties;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int eq = props.indexOf("=");
        while (eq != -1) {
            String key = props.substring(0, eq);
            String value = mbean.getKeyProperty(key);
            map.put(key, value);
            props = props.substring(key.length() + 1 + value.length());
            if (props.startsWith(",")) {
                props = props.substring(1);
            }
            eq = props.indexOf("=");
        }
        return map;
    }

    private String getKeyPropertyListString(ObjectName mbean) {
        String props = mbean.getKeyPropertyListString();
        Map<String, String> map = this.extractKeyValuePairs(props, mbean);
        StringBuilder sb = new StringBuilder();
        for (String string : orderedKeyPropertyList) {
            if (!map.containsKey(string)) continue;
            sb.append(string + "=" + map.get(string) + ",");
            map.remove(string);
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append((String)entry.getKey() + "=" + (String)entry.getValue() + ",");
        }
        String orderedKeyPropertyListString = sb.toString();
        orderedKeyPropertyListString = orderedKeyPropertyListString.substring(0, orderedKeyPropertyListString.length() - 1);
        return orderedKeyPropertyListString;
    }

    private Dn buildDn(ObjectName mbean) {
        String domain = mbean.getDomain();
        String globalDn = this.getKeyPropertyListString(mbean);
        Dn dn = this.buildDn(domain, globalDn, mbean);
        dn.updateDn();
        dn.reverseOrder();
        dn.computeHashDn();
        return dn;
    }

    private Dn buildDn(String domain, String globalDn, ObjectName mbean) {
        Dn dn = new Dn(domain, globalDn);
        String keyDn = "no_key";
        if (this.isTreeView()) {
            String props = globalDn;
            Map<String, String> map = this.extractKeyValuePairs(props, mbean);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                dn.addToken(new Token(keyDn, entry.getKey() + "=" + entry.getValue()));
            }
        } else {
            dn.addToken(new Token(keyDn, "properties=" + globalDn));
        }
        return dn;
    }

    public boolean isTreeView() {
        if (!this.treeViewInit) {
            this.treeView = this.getTreeViewValue();
            this.treeViewInit = true;
        }
        return this.treeView;
    }

    private boolean getTreeViewValue() {
        String treeView = System.getProperty("treeView");
        return treeView == null ? true : !treeView.equals("false");
    }

    public boolean isKeyValueView() {
        return this.keyValueView;
    }

    static {
        String keyPropertyList = System.getProperty("com.sun.tools.jconsole.mbeans.keyPropertyList");
        if (keyPropertyList == null) {
            orderedKeyPropertyList.add("type");
            orderedKeyPropertyList.add("j2eeType");
        } else {
            StringTokenizer st = new StringTokenizer(keyPropertyList, ",");
            while (st.hasMoreTokens()) {
                orderedKeyPropertyList.add(st.nextToken());
            }
        }
    }

    public static class Token {
        private String keyDn;
        private String token;
        private String hashToken;
        private String key;
        private String value;

        public Token(String keyDn, String token) {
            this.keyDn = keyDn;
            this.token = token;
            this.buildKeyValue();
        }

        public Token(String keyDn, String token, String hashToken) {
            this.keyDn = keyDn;
            this.token = token;
            this.hashToken = hashToken;
            this.buildKeyValue();
        }

        public String getKeyDn() {
            return this.keyDn;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String value) {
            this.value = value;
            this.token = this.key + "=" + value;
        }

        public void setKey(String key) {
            this.key = key;
            this.token = key + "=" + this.value;
        }

        public void setKeyDn(String keyDn) {
            this.keyDn = keyDn;
        }

        public void setHashToken(String hashToken) {
            this.hashToken = hashToken;
        }

        public String getHashToken() {
            return this.hashToken;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getToken();
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                return this.token.equals((Token)object);
            }
            return false;
        }

        private void buildKeyValue() {
            int index = this.token.indexOf("=");
            if (index < 0) {
                this.key = this.token;
                this.value = this.token;
            } else {
                this.key = this.token.substring(0, index);
                this.value = this.token.substring(index + 1, this.token.length());
            }
        }
    }

    public static class Dn {
        private String domain;
        private String dn;
        private String hashDn;
        private ArrayList<Token> tokens = new ArrayList();

        public Dn(String domain, String dn) {
            this.domain = domain;
            this.dn = dn;
        }

        public void clearTokens() {
            this.tokens.clear();
        }

        public void addToken(Token token) {
            this.tokens.add(token);
        }

        public void addToken(int index, Token token) {
            this.tokens.add(index, token);
        }

        public void setToken(int index, Token token) {
            this.tokens.set(index, token);
        }

        public void removeToken(int index) {
            this.tokens.remove(index);
        }

        public Token getToken(int index) {
            return this.tokens.get(index);
        }

        public void reverseOrder() {
            ArrayList<Token> newOrder = new ArrayList<Token>(this.tokens.size());
            for (int i = this.tokens.size() - 1; i >= 0; --i) {
                newOrder.add(this.tokens.get(i));
            }
            this.tokens = newOrder;
        }

        public int size() {
            return this.tokens.size();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDn() {
            return this.dn;
        }

        public String getHashDn() {
            return this.hashDn;
        }

        public String getHashKey(Token token) {
            int begin = this.getHashDn().indexOf(token.getHashToken());
            return this.getHashDn().substring(begin, this.getHashDn().length());
        }

        public void computeHashDn() {
            StringBuilder hashDn = new StringBuilder();
            int tokensSize = this.tokens.size();
            for (int i = 0; i < tokensSize; ++i) {
                Token token = this.tokens.get(i);
                String hashToken = token.getHashToken();
                if (hashToken == null) {
                    hashToken = token.getToken() + (tokensSize - i);
                    token.setHashToken(hashToken);
                }
                hashDn.append(hashToken);
                hashDn.append(",");
            }
            this.hashDn = tokensSize > 0 ? hashDn.substring(0, hashDn.length() - 1) : "";
        }

        public void updateDn() {
            this.addToken(0, new Token("domain", "domain=" + this.getDomain()));
        }

        public String toString() {
            return this.tokens.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComparableDefaultMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<DefaultMutableTreeNode> {
        @Override
        public int compareTo(DefaultMutableTreeNode node) {
            return this.toString().compareTo(node.toString());
        }
    }
}

