/*
 * Decompiled with CFR 0.152.
 */
package build.tools.javazic;

import build.tools.javazic.Main;
import build.tools.javazic.Month;
import build.tools.javazic.Rule;
import build.tools.javazic.RuleDay;
import build.tools.javazic.Time;
import build.tools.javazic.Zoneinfo;
import java.util.StringTokenizer;

class ZoneRec {
    private int gmtOffset;
    private String ruleName;
    private int directSave;
    private Rule ruleRef;
    private String format;
    private boolean hasUntil;
    private int untilYear;
    private Month untilMonth;
    private RuleDay untilDay;
    private Time untilTime;
    private long untilInMillis;
    private String line;

    ZoneRec() {
    }

    Time getUntilTime() {
        return this.untilTime;
    }

    int getGmtOffset() {
        return this.gmtOffset;
    }

    String getRuleName() {
        return this.ruleName;
    }

    int getDirectSave() {
        return this.directSave;
    }

    boolean hasRuleReference() {
        return this.ruleRef != null;
    }

    String getFormat() {
        return this.format;
    }

    int getUntilYear() {
        return this.untilYear;
    }

    long getUntilTime(int n) {
        if (this.untilTime.isWall()) {
            return this.untilInMillis - (long)n;
        }
        return this.untilInMillis;
    }

    long getLocalUntilTime() {
        return Time.getLocalTime(this.untilYear, this.untilMonth, this.untilDay, this.untilTime.getTime());
    }

    long getLocalUntilTime(int n, int n2) {
        return Time.getLocalTime(this.untilYear, this.untilMonth, this.untilDay, n, n2, this.untilTime);
    }

    String getLine() {
        return this.line;
    }

    void setLine(String string) {
        this.line = string;
    }

    boolean hasUntil() {
        return this.hasUntil;
    }

    void adjustTime() {
        if (!this.hasUntil()) {
            return;
        }
        if (this.untilTime.isSTD() || this.untilTime.isWall()) {
            this.untilInMillis -= (long)this.gmtOffset;
        }
    }

    Rule getRuleRef() {
        return this.ruleRef;
    }

    void resolve(Zoneinfo zoneinfo) {
        if (this.ruleName != null && !"-".equals(this.ruleName)) {
            this.ruleRef = zoneinfo.getRule(this.ruleName);
        }
        this.adjustTime();
    }

    static ZoneRec parse(StringTokenizer stringTokenizer) {
        ZoneRec zoneRec = new ZoneRec();
        try {
            zoneRec.gmtOffset = (int)Time.parse(stringTokenizer.nextToken()).getTime();
            String string = stringTokenizer.nextToken();
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                zoneRec.directSave = (int)Time.parse(string).getTime();
            } else {
                zoneRec.ruleName = string;
            }
            zoneRec.format = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                zoneRec.hasUntil = true;
                zoneRec.untilYear = Integer.parseInt(stringTokenizer.nextToken());
                zoneRec.untilMonth = stringTokenizer.hasMoreTokens() ? Month.parse(stringTokenizer.nextToken()) : Month.JANUARY;
                zoneRec.untilDay = stringTokenizer.hasMoreTokens() ? RuleDay.parse(stringTokenizer.nextToken()) : new RuleDay(1);
                zoneRec.untilTime = stringTokenizer.hasMoreTokens() ? Time.parse(stringTokenizer.nextToken()) : Time.parse("0:00");
                zoneRec.untilInMillis = zoneRec.getLocalUntilTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return zoneRec;
    }

    private static void panic(String string) {
        Main.panic(string);
    }
}

