/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.text.CharacterIterator;
import sun.text.CodePointIterator;

final class CharacterIteratorCodePointIterator
extends CodePointIterator {
    private CharacterIterator iter;

    public CharacterIteratorCodePointIterator(CharacterIterator iter) {
        this.iter = iter;
    }

    public void setToStart() {
        this.iter.setIndex(this.iter.getBeginIndex());
    }

    public void setToLimit() {
        this.iter.setIndex(this.iter.getEndIndex());
    }

    public int next() {
        char cp1 = this.iter.current();
        if (cp1 != '\uffff') {
            char cp2 = this.iter.next();
            if (Character.isHighSurrogate(cp1) && cp2 != '\uffff' && Character.isLowSurrogate(cp2)) {
                this.iter.next();
                return Character.toCodePoint(cp1, cp2);
            }
            return cp1;
        }
        return -1;
    }

    public int prev() {
        char cp2 = this.iter.previous();
        if (cp2 != '\uffff') {
            if (Character.isLowSurrogate(cp2)) {
                char cp1 = this.iter.previous();
                if (Character.isHighSurrogate(cp1)) {
                    return Character.toCodePoint(cp1, cp2);
                }
                this.iter.next();
            }
            return cp2;
        }
        return -1;
    }

    public int charIndex() {
        return this.iter.getIndex();
    }
}

