/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ListIterator;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyTool;

class PolicyEntry {
    private CodeSource codesource;
    private PolicyTool tool;
    private PolicyParser.GrantEntry grantEntry;
    private boolean testing = false;

    PolicyEntry(PolicyTool tool, PolicyParser.GrantEntry ge) throws MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.tool = tool;
        URL location = null;
        if (ge.codeBase != null) {
            location = new URL(ge.codeBase);
        }
        this.codesource = new CodeSource(location, (Certificate[])null);
        if (this.testing) {
            System.out.println("Adding Policy Entry:");
            System.out.println("    CodeBase = " + location);
            System.out.println("    Signers = " + ge.signedBy);
            System.out.println("    with " + ge.principals.size() + " Principals");
        }
        this.grantEntry = ge;
    }

    CodeSource getCodeSource() {
        return this.codesource;
    }

    PolicyParser.GrantEntry getGrantEntry() {
        return this.grantEntry;
    }

    String headerToString() {
        String pString = this.principalsToString();
        if (pString.length() == 0) {
            return this.codebaseToString();
        }
        return this.codebaseToString() + ", " + pString;
    }

    String codebaseToString() {
        String stringEntry = new String();
        if (this.grantEntry.codeBase != null && !this.grantEntry.codeBase.equals("")) {
            stringEntry = stringEntry.concat("CodeBase \"" + this.grantEntry.codeBase + "\"");
        }
        if (this.grantEntry.signedBy != null && !this.grantEntry.signedBy.equals("")) {
            String string = stringEntry = stringEntry.length() > 0 ? stringEntry.concat(", SignedBy \"" + this.grantEntry.signedBy + "\"") : stringEntry.concat("SignedBy \"" + this.grantEntry.signedBy + "\"");
        }
        if (stringEntry.length() == 0) {
            return new String("CodeBase <ALL>");
        }
        return stringEntry;
    }

    String principalsToString() {
        String result = "";
        if (this.grantEntry.principals != null && !this.grantEntry.principals.isEmpty()) {
            StringBuffer buffer = new StringBuffer(200);
            ListIterator list = this.grantEntry.principals.listIterator();
            while (list.hasNext()) {
                PolicyParser.PrincipalEntry pppe = (PolicyParser.PrincipalEntry)list.next();
                buffer.append(" Principal " + pppe.getDisplayClass() + " " + pppe.getDisplayName(true));
                if (!list.hasNext()) continue;
                buffer.append(", ");
            }
            result = buffer.toString();
        }
        return result;
    }

    PolicyParser.PermissionEntry toPermissionEntry(Permission perm) {
        String actions2 = null;
        if (perm.getActions() != null && perm.getActions().trim() != "") {
            actions2 = perm.getActions();
        }
        PolicyParser.PermissionEntry pe = new PolicyParser.PermissionEntry(perm.getClass().getName(), perm.getName(), actions2);
        return pe;
    }
}

