/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class TimestampToken {
    private int version;
    private ObjectIdentifier policy;
    private BigInteger serialNumber;
    private AlgorithmId hashAlgorithm;
    private byte[] hashedMessage;
    private Date genTime;
    private BigInteger nonce;

    public TimestampToken(byte[] timestampTokenInfo) throws IOException {
        if (timestampTokenInfo == null) {
            throw new IOException("No timestamp token info");
        }
        this.parse(timestampTokenInfo);
    }

    public Date getDate() {
        return this.genTime;
    }

    public AlgorithmId getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return this.hashedMessage;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    private void parse(byte[] timestampTokenInfo) throws IOException {
        DerValue tstInfo = new DerValue(timestampTokenInfo);
        if (tstInfo.tag != 48) {
            throw new IOException("Bad encoding for timestamp token info");
        }
        this.version = tstInfo.data.getInteger();
        this.policy = tstInfo.data.getOID();
        DerValue messageImprint = tstInfo.data.getDerValue();
        this.hashAlgorithm = AlgorithmId.parse(messageImprint.data.getDerValue());
        this.hashedMessage = messageImprint.data.getOctetString();
        this.serialNumber = tstInfo.data.getBigInteger();
        this.genTime = tstInfo.data.getGeneralizedTime();
        while (tstInfo.data.available() > 0) {
            DerValue d = tstInfo.data.getDerValue();
            if (d.tag != 2) continue;
            this.nonce = d.getBigInteger();
            break;
        }
    }
}

