/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.Provider;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.SunProvider;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public final class Krb5MechFactory
implements MechanismFactory {
    private static final boolean DEBUG = Krb5Util.DEBUG;
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_KRB5_MECH_OID = Krb5MechFactory.createOid("1.2.840.113554.1.2.2");
    static final Oid NT_GSS_KRB5_PRINCIPAL = Krb5MechFactory.createOid("1.2.840.113554.1.2.2.1");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME, NT_GSS_KRB5_PRINCIPAL};
    private final int caller;

    private static Krb5CredElement getCredFromSubject(GSSNameSpi name, boolean initiate) throws GSSException {
        Krb5CredElement result;
        Vector creds = GSSUtil.searchSubject(name, GSS_KRB5_MECH_OID, initiate, initiate ? Krb5InitCredential.class : Krb5AcceptCredential.class);
        Krb5CredElement krb5CredElement = result = creds == null || creds.isEmpty() ? null : (Krb5CredElement)creds.firstElement();
        if (result != null) {
            if (initiate) {
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)result.getName());
            } else {
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)result.getName(), name);
            }
        }
        return result;
    }

    public Krb5MechFactory(int caller) {
        this.caller = caller;
    }

    public GSSNameSpi getNameElement(String nameStr, Oid nameType) throws GSSException {
        return Krb5NameElement.getInstance(nameStr, nameType);
    }

    public GSSNameSpi getNameElement(byte[] name, Oid nameType) throws GSSException {
        return Krb5NameElement.getInstance(new String(name), nameType);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        Krb5CredElement credElement;
        if (name != null && !(name instanceof Krb5NameElement)) {
            name = Krb5NameElement.getInstance(((Object)name).toString(), name.getStringNameType());
        }
        if ((credElement = Krb5MechFactory.getCredFromSubject(name, usage != 2)) == null) {
            if (usage == 1 || usage == 0) {
                credElement = Krb5InitCredential.getInstance(this.caller, (Krb5NameElement)name, initLifetime);
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)credElement.getName());
            } else if (usage == 2) {
                credElement = Krb5AcceptCredential.getInstance(this.caller, (Krb5NameElement)name);
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)credElement.getName(), name);
            } else {
                throw new GSSException(11, -1, "Unknown usage mode requested");
            }
        }
        return credElement;
    }

    public static void checkInitCredPermission(Krb5NameElement name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String realm = name.getKrb5PrincipalName().getRealmAsString();
            String tgsPrincipal = new String("krbtgt/" + realm + '@' + realm);
            ServicePermission perm = new ServicePermission(tgsPrincipal, "initiate");
            try {
                sm.checkPermission(perm);
            }
            catch (SecurityException e) {
                if (DEBUG) {
                    System.out.println("Permission to initiatekerberos init credential" + e.getMessage());
                }
                throw e;
            }
        }
    }

    public static void checkAcceptCredPermission(Krb5NameElement name, GSSNameSpi originalName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServicePermission perm = new ServicePermission(name.getKrb5PrincipalName().getName(), "accept");
            try {
                sm.checkPermission(perm);
            }
            catch (SecurityException e) {
                if (originalName == null) {
                    e = new SecurityException("No permission to acquire Kerberos accept credential");
                }
                throw e;
            }
        }
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myInitiatorCred, int lifetime) throws GSSException {
        if (peer != null && !(peer instanceof Krb5NameElement)) {
            peer = Krb5NameElement.getInstance(((Object)peer).toString(), peer.getStringNameType());
        }
        if (myInitiatorCred == null) {
            myInitiatorCred = this.getCredentialElement(null, lifetime, 0, 1);
        }
        return new Krb5Context(this.caller, (Krb5NameElement)peer, (Krb5CredElement)myInitiatorCred, lifetime);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi myAcceptorCred) throws GSSException {
        if (myAcceptorCred == null) {
            myAcceptorCred = this.getCredentialElement(null, 0, Integer.MAX_VALUE, 2);
        }
        return new Krb5Context(this.caller, (Krb5CredElement)myAcceptorCred);
    }

    public GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        return new Krb5Context(this.caller, exportedContext);
    }

    public final Oid getMechanismOid() {
        return GSS_KRB5_MECH_OID;
    }

    public Provider getProvider() {
        return PROVIDER;
    }

    public Oid[] getNameTypes() {
        return nameTypes;
    }

    private static Oid createOid(String oidStr) {
        Oid retVal = null;
        try {
            retVal = new Oid(oidStr);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return retVal;
    }
}

