/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;

public class US_ASCII
extends Charset
implements HistoricallyNamedCharset {
    public US_ASCII() {
        super("US-ASCII", StandardCharsets.aliases_US_ASCII);
    }

    public String historicalName() {
        return "ASCII";
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c < '\u0080';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            CoderResult coderResult;
            int dp;
            int sp;
            block12: {
                CoderResult coderResult2;
                block11: {
                    CoderResult coderResult3;
                    block10: {
                        CoderResult coderResult4;
                        block9: {
                            char[] sa = src.array();
                            sp = src.arrayOffset() + src.position();
                            int sl = src.arrayOffset() + src.limit();
                            assert (sp <= sl);
                            byte[] da = dst.array();
                            dp = dst.arrayOffset() + dst.position();
                            int dl = dst.arrayOffset() + dst.limit();
                            assert (dp <= dl);
                            dp = dp <= dl ? dp : dl;
                            try {
                                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp, ++dp) {
                                    char c = sa[sp];
                                    if (c < '\u0080') {
                                        if (dp >= dl) {
                                            coderResult4 = CoderResult.OVERFLOW;
                                            Object var12_14 = null;
                                            break block9;
                                        } else {
                                            da[dp] = (byte)c;
                                            continue;
                                        }
                                    }
                                    if (this.sgp.parse(c, sa, sp, sl) < 0) {
                                        coderResult3 = this.sgp.error();
                                        break block10;
                                    }
                                    coderResult2 = this.sgp.unmappableResult();
                                    break block11;
                                }
                                coderResult = CoderResult.UNDERFLOW;
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var12_18 = null;
                                src.position(sp - src.arrayOffset());
                                dst.position(dp - dst.arrayOffset());
                                throw throwable;
                            }
                        }
                        src.position(sp - src.arrayOffset());
                        dst.position(dp - dst.arrayOffset());
                        return coderResult4;
                    }
                    Object var12_15 = null;
                    src.position(sp - src.arrayOffset());
                    dst.position(dp - dst.arrayOffset());
                    return coderResult3;
                }
                Object var12_16 = null;
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
                return coderResult2;
            }
            Object var12_17 = null;
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            CoderResult coderResult;
            int mark;
            block10: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        CoderResult coderResult4;
                        block7: {
                            mark = src.position();
                            try {
                                while (src.hasRemaining()) {
                                    char c = src.get();
                                    if (c < '\u0080') {
                                        if (!dst.hasRemaining()) {
                                            coderResult4 = CoderResult.OVERFLOW;
                                            Object var7_9 = null;
                                            break block7;
                                        } else {
                                            dst.put((byte)c);
                                            ++mark;
                                            continue;
                                        }
                                    }
                                    if (this.sgp.parse(c, src) < 0) {
                                        coderResult3 = this.sgp.error();
                                        break block8;
                                    }
                                    coderResult2 = this.sgp.unmappableResult();
                                    break block9;
                                }
                                coderResult = CoderResult.UNDERFLOW;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var7_13 = null;
                                src.position(mark);
                                throw throwable;
                            }
                        }
                        src.position(mark);
                        return coderResult4;
                    }
                    Object var7_10 = null;
                    src.position(mark);
                    return coderResult3;
                }
                Object var7_11 = null;
                src.position(mark);
                return coderResult2;
            }
            Object var7_12 = null;
            src.position(mark);
            return coderResult;
        }

        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            CoderResult coderResult;
            int dp;
            int sp;
            block10: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        byte[] sa = src.array();
                        sp = src.arrayOffset() + src.position();
                        int sl = src.arrayOffset() + src.limit();
                        assert (sp <= sl);
                        char[] da = dst.array();
                        dp = dst.arrayOffset() + dst.position();
                        int dl = dst.arrayOffset() + dst.limit();
                        assert (dp <= dl);
                        dp = dp <= dl ? dp : dl;
                        try {
                            for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                                byte b = sa[sp];
                                if (b >= 0) {
                                    if (dp >= dl) {
                                        coderResult3 = CoderResult.OVERFLOW;
                                        Object var12_13 = null;
                                        break block8;
                                    } else {
                                        da[dp++] = (char)b;
                                        continue;
                                    }
                                }
                                coderResult2 = CoderResult.malformedForLength(1);
                                break block9;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var12_16 = null;
                            src.position(sp - src.arrayOffset());
                            dst.position(dp - dst.arrayOffset());
                            throw throwable;
                        }
                    }
                    src.position(sp - src.arrayOffset());
                    dst.position(dp - dst.arrayOffset());
                    return coderResult3;
                }
                Object var12_14 = null;
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
                return coderResult2;
            }
            Object var12_15 = null;
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            CoderResult coderResult;
            int mark;
            block8: {
                CoderResult coderResult2;
                block7: {
                    CoderResult coderResult3;
                    block6: {
                        mark = src.position();
                        try {
                            while (src.hasRemaining()) {
                                byte b = src.get();
                                if (b >= 0) {
                                    if (!dst.hasRemaining()) {
                                        coderResult3 = CoderResult.OVERFLOW;
                                        Object var7_8 = null;
                                        break block6;
                                    } else {
                                        dst.put((char)b);
                                        ++mark;
                                        continue;
                                    }
                                }
                                coderResult2 = CoderResult.malformedForLength(1);
                                break block7;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            src.position(mark);
                            throw throwable;
                        }
                    }
                    src.position(mark);
                    return coderResult3;
                }
                Object var7_9 = null;
                src.position(mark);
                return coderResult2;
            }
            Object var7_10 = null;
            src.position(mark);
            return coderResult;
        }

        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

