/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pisces.Dasher;
import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesCache;
import sun.java2d.pisces.PiscesTileGenerator;
import sun.java2d.pisces.Renderer;
import sun.java2d.pisces.Stroker;
import sun.java2d.pisces.Transform4;

public class PiscesRenderingEngine
extends RenderingEngine {
    public static Transform4 IdentT4 = new Transform4();
    public static double defaultFlat = 0.1;

    static int FloatToS15_16(float flt) {
        if ((flt = flt * 65536.0f + 0.5f) <= -4.2949673E9f) {
            return Integer.MIN_VALUE;
        }
        if (flt >= 4.2949673E9f) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor(flt);
    }

    static float S15_16ToFloat(int fix) {
        return (float)fix / 65536.0f;
    }

    public Shape createStrokedShape(Shape src, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase) {
        final Path2D.Float p2d = new Path2D.Float();
        this.strokeTo(src, null, width, caps, join, miterlimit, dashes, dashphase, new LineSink(){

            public void moveTo(int x0, int y0) {
                p2d.moveTo(PiscesRenderingEngine.S15_16ToFloat(x0), PiscesRenderingEngine.S15_16ToFloat(y0));
            }

            public void lineJoin() {
            }

            public void lineTo(int x1, int y1) {
                p2d.lineTo(PiscesRenderingEngine.S15_16ToFloat(x1), PiscesRenderingEngine.S15_16ToFloat(y1));
            }

            public void close() {
                p2d.closePath();
            }

            public void end() {
            }
        });
        return p2d;
    }

    public void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, final PathConsumer2D consumer) {
        this.strokeTo(src, at, bs, thin, normalize, antialias, new LineSink(){

            public void moveTo(int x0, int y0) {
                consumer.moveTo(PiscesRenderingEngine.S15_16ToFloat(x0), PiscesRenderingEngine.S15_16ToFloat(y0));
            }

            public void lineJoin() {
            }

            public void lineTo(int x1, int y1) {
                consumer.lineTo(PiscesRenderingEngine.S15_16ToFloat(x1), PiscesRenderingEngine.S15_16ToFloat(y1));
            }

            public void close() {
                consumer.closePath();
            }

            public void end() {
                consumer.pathDone();
            }
        });
    }

    void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, LineSink lsink) {
        float lw = thin ? (antialias ? 0.5f : 1.0f) : bs.getLineWidth();
        this.strokeTo(src, at, lw, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase(), lsink);
    }

    void strokeTo(Shape src, AffineTransform at, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase, LineSink lsink) {
        Transform4 t4 = at == null || at.isIdentity() ? IdentT4 : new Transform4(PiscesRenderingEngine.FloatToS15_16((float)at.getScaleX()), PiscesRenderingEngine.FloatToS15_16((float)at.getShearX()), PiscesRenderingEngine.FloatToS15_16((float)at.getShearY()), PiscesRenderingEngine.FloatToS15_16((float)at.getScaleY()));
        lsink = new Stroker(lsink, PiscesRenderingEngine.FloatToS15_16(width), caps, join, PiscesRenderingEngine.FloatToS15_16(miterlimit), t4);
        if (dashes != null) {
            int[] fdashes = new int[dashes.length];
            for (int i = 0; i < dashes.length; ++i) {
                fdashes[i] = PiscesRenderingEngine.FloatToS15_16(dashes[i]);
            }
            lsink = new Dasher(lsink, fdashes, PiscesRenderingEngine.FloatToS15_16(dashphase), t4);
        }
        PathIterator pi = src.getPathIterator(at, defaultFlat);
        this.pathTo(pi, lsink);
    }

    void pathTo(PathIterator pi, LineSink lsink) {
        float[] coords = new float[2];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    lsink.moveTo(PiscesRenderingEngine.FloatToS15_16(coords[0]), PiscesRenderingEngine.FloatToS15_16(coords[1]));
                    break;
                }
                case 1: {
                    lsink.lineJoin();
                    lsink.lineTo(PiscesRenderingEngine.FloatToS15_16(coords[0]), PiscesRenderingEngine.FloatToS15_16(coords[1]));
                    break;
                }
                case 4: {
                    lsink.lineJoin();
                    lsink.close();
                    break;
                }
                default: {
                    throw new InternalError("unknown flattened segment type");
                }
            }
            pi.next();
        }
        lsink.end();
    }

    public AATileGenerator getAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
        PiscesCache pc = PiscesCache.createInstance();
        Renderer r = new Renderer();
        r.setCache(pc);
        r.setAntialiasing(3, 3);
        r.beginRendering(clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight());
        if (bs == null) {
            PathIterator pi = s.getPathIterator(at, defaultFlat);
            r.setWindingRule(pi.getWindingRule());
            this.pathTo(pi, r);
        } else {
            r.setWindingRule(1);
            this.strokeTo(s, at, bs, thin, normalize, true, r);
        }
        r.endRendering();
        PiscesTileGenerator ptg = new PiscesTileGenerator(pc, r.MAX_AA_ALPHA);
        ptg.getBbox(bbox);
        return ptg;
    }

    public float getMinimumAAPenSize() {
        return 0.5f;
    }
}

