/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.peer.ComponentPeer;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.awt.dnd.SunDropTargetEvent;
import sun.misc.Unsafe;

final class XDropTargetContextPeer
extends SunDropTargetContextPeer {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetContextPeer");
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private static final Object DTCP_KEY = "DropTargetContextPeer";

    private XDropTargetContextPeer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XDropTargetContextPeer getPeer(AppContext appContext) {
        Object object = _globalLock;
        synchronized (object) {
            XDropTargetContextPeer peer = (XDropTargetContextPeer)appContext.get(DTCP_KEY);
            if (peer == null) {
                peer = new XDropTargetContextPeer();
                appContext.put(DTCP_KEY, peer);
            }
            return peer;
        }
    }

    static XDropTargetProtocolListener getXDropTargetProtocolListener() {
        return XDropTargetProtocolListenerImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventProcessed(SunDropTargetEvent e, int returnValue, boolean dispatcherDone) {
        block5: {
            long ctxt = this.getNativeDragContext();
            try {
                if (ctxt == 0L || e.isConsumed()) break block5;
                Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
                while (dropTargetProtocols.hasNext()) {
                    XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                    if (!dropTargetProtocol.sendResponse(ctxt, e.getID(), returnValue)) continue;
                    break;
                }
            }
            finally {
                if (dispatcherDone && ctxt != 0L) {
                    unsafe.freeMemory(ctxt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDropDone(boolean success, int dropAction, boolean isLocal) {
        long ctxt = this.getNativeDragContext();
        if (ctxt != 0L) {
            try {
                Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
                while (dropTargetProtocols.hasNext()) {
                    XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                    if (!dropTargetProtocol.sendDropDone(ctxt, success, dropAction)) continue;
                    break;
                }
            }
            finally {
                unsafe.freeMemory(ctxt);
            }
        }
    }

    protected Object getNativeData(long format) throws IOException {
        long ctxt = this.getNativeDragContext();
        if (ctxt != 0L) {
            Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                try {
                    return dropTargetProtocol.getData(ctxt, format);
                }
                catch (IllegalArgumentException iae) {
                }
            }
        }
        return null;
    }

    private void cleanup() {
    }

    protected void processEnterMessage(SunDropTargetEvent event) {
        if (!this.processSunDropTargetEvent(event)) {
            super.processEnterMessage(event);
        }
    }

    protected void processExitMessage(SunDropTargetEvent event) {
        if (!this.processSunDropTargetEvent(event)) {
            super.processExitMessage(event);
        }
    }

    protected void processMotionMessage(SunDropTargetEvent event, boolean operationChanged) {
        if (!this.processSunDropTargetEvent(event)) {
            super.processMotionMessage(event, operationChanged);
        }
    }

    protected void processDropMessage(SunDropTargetEvent event) {
        if (!this.processSunDropTargetEvent(event)) {
            super.processDropMessage(event);
        }
    }

    private boolean processSunDropTargetEvent(SunDropTargetEvent event) {
        ComponentPeer peer;
        Object source = event.getSource();
        if (source instanceof Component && (peer = ((Component)source).getPeer()) instanceof XEmbedCanvasPeer) {
            XEmbedCanvasPeer xEmbedCanvasPeer = (XEmbedCanvasPeer)peer;
            long ctxt = this.getNativeDragContext();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("        processing " + event + " ctxt=" + ctxt + " consumed=" + event.isConsumed());
            }
            if (!event.isConsumed() && xEmbedCanvasPeer.processXEmbedDnDEvent(ctxt, event.getID())) {
                event.consume();
                return true;
            }
        }
        return false;
    }

    public void forwardEventToEmbedded(long embedded, long ctxt, int eventID) {
        XDropTargetProtocol dropTargetProtocol;
        Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        while (dropTargetProtocols.hasNext() && !(dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next()).forwardEventToEmbedded(embedded, ctxt, eventID)) {
        }
    }

    static final class XDropTargetProtocolListenerImpl
    implements XDropTargetProtocolListener {
        private static final XDropTargetProtocolListener theInstance = new XDropTargetProtocolListenerImpl();

        private XDropTargetProtocolListenerImpl() {
        }

        static XDropTargetProtocolListener getInstance() {
            return theInstance;
        }

        public void handleDropTargetNotification(XWindow xwindow, int x, int y, int dropAction, int actions2, long[] formats, long nativeCtxt, int eventID) {
            Object target = xwindow.getTarget();
            assert (target instanceof Component);
            Component component = (Component)target;
            AppContext appContext = SunToolkit.targetToAppContext(target);
            assert (appContext != null);
            XDropTargetContextPeer peer = XDropTargetContextPeer.getPeer(appContext);
            peer.postDropTargetEvent(component, x, y, dropAction, actions2, formats, nativeCtxt, eventID, false);
        }
    }
}

