/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.swing.JFileChooser;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;

class XFileOpenService
implements FileOpenService {
    protected XFileOpenService() {
    }

    @Override
    public FileContents openFileDialog(String pathHint, String[] extensions) throws IOException {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.READ_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            int chosen = chooser.showOpenDialog(null);
            if (chosen == 0) {
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(chooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    @Override
    public FileContents[] openMultiFileDialog(String pathHint, String[] extensions) throws IOException {
        if (ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            int chosen = chooser.showOpenDialog(null);
            if (chosen == 0) {
                File[] files = chooser.getSelectedFiles();
                int length = files.length;
                XFileContents[] xfiles = new XFileContents[length];
                for (int i = 0; i < length; ++i) {
                    xfiles[i] = new XFileContents(files[i]);
                }
                return (FileContents[])ServiceUtil.createPrivilegedProxy(FileContents.class, xfiles);
            }
            return null;
        }
        return null;
    }
}

