/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(long[].class);
    private static final int scale = unsafe.arrayIndexScale(long[].class);
    private final long[] array;

    private long rawIndex(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return (long)base + (long)i * (long)scale;
    }

    public AtomicLongArray(int length) {
        this.array = new long[length];
        if (length > 0) {
            unsafe.putLongVolatile(this.array, this.rawIndex(0), 0L);
        }
    }

    public AtomicLongArray(long[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new long[length];
        if (length > 0) {
            int last = length - 1;
            for (int i = 0; i < last; ++i) {
                this.array[i] = array[i];
            }
            unsafe.putLongVolatile(this.array, this.rawIndex(last), array[last]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final long get(int i) {
        return unsafe.getLongVolatile(this.array, this.rawIndex(i));
    }

    public final void set(int i, long newValue) {
        unsafe.putLongVolatile(this.array, this.rawIndex(i), newValue);
    }

    public final void lazySet(int i, long newValue) {
        unsafe.putOrderedLong(this.array, this.rawIndex(i), newValue);
    }

    public final long getAndSet(int i, long newValue) {
        long current;
        while (!this.compareAndSet(i, current = this.get(i), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(int i, long expect, long update) {
        return unsafe.compareAndSwapLong(this.array, this.rawIndex(i), expect, update);
    }

    public final boolean weakCompareAndSet(int i, long expect, long update) {
        return this.compareAndSet(i, expect, update);
    }

    public final long getAndIncrement(int i) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + 1L)) {
        }
        return current;
    }

    public final long getAndDecrement(int i) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current - 1L)) {
        }
        return current;
    }

    public final long getAndAdd(int i, long delta) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + delta)) {
        }
        return current;
    }

    public final long incrementAndGet(int i) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + 1L)) {
        }
        return next;
    }

    public final long decrementAndGet(int i) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current - 1L)) {
        }
        return next;
    }

    public long addAndGet(int i, long delta) {
        long next;
        long current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + delta)) {
        }
        return next;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

