/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class UNIXProcess
extends Process {
    private FileDescriptor stdin_fd = new FileDescriptor();
    private FileDescriptor stdout_fd = new FileDescriptor();
    private FileDescriptor stderr_fd = new FileDescriptor();
    private int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(byte[] var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, boolean var7, FileDescriptor var8, FileDescriptor var9, FileDescriptor var10) throws IOException;

    UNIXProcess(final byte[] prog, final byte[] argBlock, final int argc, final byte[] envBlock, final int envc, final byte[] dir, final boolean redirectErrorStream) throws IOException {
        final Gate gate = new Gate();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread t = new Thread("process reaper"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            UNIXProcess.this.pid = UNIXProcess.this.forkAndExec(prog, argBlock, argc, envBlock, envc, dir, redirectErrorStream, UNIXProcess.this.stdin_fd, UNIXProcess.this.stdout_fd, UNIXProcess.this.stderr_fd);
                        }
                        catch (IOException e) {
                            gate.setException(e);
                            gate.exit();
                            return;
                        }
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(UNIXProcess.this.stdin_fd));
                                UNIXProcess.this.stdout_stream = new BufferedInputStream(new FileInputStream(UNIXProcess.this.stdout_fd));
                                UNIXProcess.this.stderr_stream = new FileInputStream(UNIXProcess.this.stderr_fd);
                                return null;
                            }
                        });
                        gate.exit();
                        int res = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                        UNIXProcess uNIXProcess = UNIXProcess.this;
                        synchronized (uNIXProcess) {
                            UNIXProcess.this.hasExited = true;
                            UNIXProcess.this.exitcode = res;
                            UNIXProcess.this.notifyAll();
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
                return null;
            }
        });
        gate.waitForExit();
        IOException e = gate.getException();
        if (e != null) {
            throw new IOException(e.toString());
        }
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin_stream.close();
            this.stdout_stream.close();
            this.stderr_stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void initIDs();

    static {
        UNIXProcess.initIDs();
    }

    private static class Gate {
        private boolean exited = false;
        private IOException savedException;

        private Gate() {
        }

        synchronized void exit() {
            this.exited = true;
            this.notify();
        }

        synchronized void waitForExit() {
            boolean interrupted = false;
            while (!this.exited) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        void setException(IOException e) {
            this.savedException = e;
        }

        IOException getException() {
            return this.savedException;
        }
    }
}

