/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.util.Arrays;
import sun.misc.VM;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    private final ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nUnstartedThreads = 0;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
        this.parent = null;
    }

    public ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        this(ThreadGroup.checkParentAccess(parent), parent, name);
    }

    private ThreadGroup(Void unused, ThreadGroup parent, String name) {
        this.name = name;
        this.maxPriority = parent.maxPriority;
        this.daemon = parent.daemon;
        this.vmAllowSuspension = parent.vmAllowSuspension;
        this.parent = parent;
        parent.add(this);
    }

    private static Void checkParentAccess(ThreadGroup parent) {
        parent.checkAccess();
        return null;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean daemon) {
        this.checkAccess();
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int pri) {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (pri < 1 || pri > 10) {
                return;
            }
            this.maxPriority = this.parent != null ? Math.min(pri, this.parent.maxPriority) : pri;
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            groupsSnapshot[i].setMaxPriority(pri);
        }
    }

    public final boolean parentOf(ThreadGroup g) {
        while (g != null) {
            if (g == this) {
                return true;
            }
            g = g.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        int result;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            result = this.nthreads;
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            result += groupsSnapshot[i].activeCount();
        }
        return result;
    }

    public int enumerate(Thread[] list) {
        this.checkAccess();
        return this.enumerate(list, 0, true);
    }

    public int enumerate(Thread[] list, boolean recurse) {
        this.checkAccess();
        return this.enumerate(list, 0, recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] list, int n, boolean recurse) {
        int ngroupsSnapshot = 0;
        ThreadGroup[] groupsSnapshot = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int nt = this.nthreads;
            if (nt > list.length - n) {
                nt = list.length - n;
            }
            for (int i = 0; i < nt; ++i) {
                if (!this.threads[i].isAlive()) continue;
                list[n++] = this.threads[i];
            }
            if (recurse) {
                ngroupsSnapshot = this.ngroups;
                groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
            }
        }
        if (recurse) {
            for (int i = 0; i < ngroupsSnapshot; ++i) {
                n = groupsSnapshot[i].enumerate(list, n, true);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        int n = ngroupsSnapshot;
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            n += groupsSnapshot[i].activeGroupCount();
        }
        return n;
    }

    public int enumerate(ThreadGroup[] list) {
        this.checkAccess();
        return this.enumerate(list, 0, true);
    }

    public int enumerate(ThreadGroup[] list, boolean recurse) {
        this.checkAccess();
        return this.enumerate(list, 0, recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] list, int n, boolean recurse) {
        int ngroupsSnapshot = 0;
        ThreadGroup[] groupsSnapshot = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            int ng = this.ngroups;
            if (ng > list.length - n) {
                ng = list.length - n;
            }
            if (ng > 0) {
                System.arraycopy(this.groups, 0, list, n, ng);
                n += ng;
            }
            if (recurse) {
                ngroupsSnapshot = this.ngroups;
                groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
            }
        }
        if (recurse) {
            for (int i = 0; i < ngroupsSnapshot; ++i) {
                n = groupsSnapshot[i].enumerate(list, n, true);
            }
        }
        return n;
    }

    @Deprecated
    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                this.threads[i].interrupt();
            }
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            groupsSnapshot[i].interrupt();
        }
    }

    @Deprecated
    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean suspend) {
        int ngroupsSnapshot;
        boolean suicide = false;
        Thread us = Thread.currentThread();
        ThreadGroup[] groupsSnapshot = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                if (this.threads[i] == us) {
                    suicide = true;
                    continue;
                }
                if (suspend) {
                    this.threads[i].suspend();
                    continue;
                }
                this.threads[i].stop();
            }
            ngroupsSnapshot = this.ngroups;
            if (this.groups != null) {
                groupsSnapshot = Arrays.copyOf(this.groups, ngroupsSnapshot);
            }
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            suicide = groupsSnapshot[i].stopOrSuspend(suspend) || suicide;
        }
        return suicide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            for (int i = 0; i < this.nthreads; ++i) {
                this.threads[i].resume();
            }
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            groupsSnapshot[i].resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            groupsSnapshot[i].destroy();
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup g) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                this.groups = Arrays.copyOf(this.groups, this.ngroups * 2);
            }
            this.groups[this.ngroups] = g;
            ++this.ngroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup g) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            for (int i = 0; i < this.ngroups; ++i) {
                if (this.groups[i] != g) continue;
                --this.ngroups;
                System.arraycopy(this.groups, i + 1, this.groups, i, this.ngroups - i);
                this.groups[this.ngroups] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnstarted() {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            ++this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread t) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                this.threads = Arrays.copyOf(this.threads, this.nthreads * 2);
            }
            this.threads[this.nthreads] = t;
            ++this.nthreads;
            --this.nUnstartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Thread t) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            for (int i = 0; i < this.nthreads; ++i) {
                if (this.threads[i] != t) continue;
                System.arraycopy(this.threads, i + 1, this.threads, i, --this.nthreads - i);
                this.threads[this.nthreads] = null;
                break;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.nUnstartedThreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream out, int indent) {
        ThreadGroup[] groupsSnapshot;
        int ngroupsSnapshot;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            for (int j = 0; j < indent; ++j) {
                out.print(" ");
            }
            out.println(this);
            indent += 4;
            for (int i = 0; i < this.nthreads; ++i) {
                for (int j = 0; j < indent; ++j) {
                    out.print(" ");
                }
                out.println(this.threads[i]);
            }
            ngroupsSnapshot = this.ngroups;
            groupsSnapshot = this.groups != null ? Arrays.copyOf(this.groups, ngroupsSnapshot) : null;
        }
        for (int i = 0; i < ngroupsSnapshot; ++i) {
            groupsSnapshot[i].list(out, indent);
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (this.parent != null) {
            this.parent.uncaughtException(t, e);
        } else {
            Thread.UncaughtExceptionHandler ueh = Thread.getDefaultUncaughtExceptionHandler();
            if (ueh != null) {
                ueh.uncaughtException(t, e);
            } else if (!(e instanceof ThreadDeath)) {
                System.err.print("Exception in thread \"" + t.getName() + "\" ");
                e.printStackTrace(System.err);
            }
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean b) {
        this.vmAllowSuspension = b;
        if (!b) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }
}

