/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.XMLStreamReaderToContentHandler;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.xml.DummyLocation;
import com.sun.xml.internal.ws.util.xml.StAXSource;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamMessage
extends AbstractMessageImpl {
    @NotNull
    private XMLStreamReader reader;
    @Nullable
    private HeaderList headers;
    private final String payloadLocalName;
    private final String payloadNamespaceURI;
    @NotNull
    private TagInfoset envelopeTag;
    @NotNull
    private TagInfoset headerTag;
    @NotNull
    private TagInfoset bodyTag;
    private Throwable consumedAt;
    private static final TagInfoset[] DEFAULT_TAGS = new TagInfoset[6];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage(@Nullable HeaderList headers, @NotNull AttachmentSet attachmentSet, @NotNull XMLStreamReader reader, @NotNull SOAPVersion soapVersion) {
        super(soapVersion);
        this.headers = headers;
        this.attachmentSet = attachmentSet;
        this.reader = reader;
        if (reader.getEventType() == 7) {
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        if (reader.getEventType() == 2) {
            String body = reader.getLocalName();
            String nsUri = reader.getNamespaceURI();
            assert (body != null);
            assert (nsUri != null);
            if (!body.equals("Body") || !nsUri.equals(soapVersion.nsUri)) throw new WebServiceException("Malformed stream: {" + nsUri + "}" + body);
            this.payloadLocalName = null;
            this.payloadNamespaceURI = null;
        } else {
            this.payloadLocalName = reader.getLocalName();
            this.payloadNamespaceURI = reader.getNamespaceURI();
        }
        int base = soapVersion.ordinal() * 3;
        this.envelopeTag = DEFAULT_TAGS[base];
        this.headerTag = DEFAULT_TAGS[base + 1];
        this.bodyTag = DEFAULT_TAGS[base + 2];
    }

    public StreamMessage(@NotNull TagInfoset envelopeTag, @Nullable TagInfoset headerTag, @NotNull AttachmentSet attachmentSet, @Nullable HeaderList headers, @NotNull TagInfoset bodyTag, @NotNull XMLStreamReader reader, @NotNull SOAPVersion soapVersion) {
        this(headers, attachmentSet, reader, soapVersion);
        assert (envelopeTag != null && bodyTag != null);
        this.envelopeTag = envelopeTag;
        this.headerTag = headerTag != null ? headerTag : new TagInfoset(envelopeTag.nsUri, "Header", envelopeTag.prefix, EMPTY_ATTS, new String[0]);
        this.bodyTag = bodyTag;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public HeaderList getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        return this.attachmentSet;
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payloadNamespaceURI;
    }

    @Override
    public boolean hasPayload() {
        return this.payloadLocalName != null;
    }

    @Override
    public Source readPayloadAsSource() {
        if (this.hasPayload()) {
            assert (this.unconsumed());
            return new StAXSource(this.reader, true, this.getInscopeNamespaces());
        }
        return null;
    }

    private String[] getInscopeNamespaces() {
        int i;
        NamespaceSupport nss = new NamespaceSupport();
        nss.pushContext();
        for (i = 0; i < this.envelopeTag.ns.length; i += 2) {
            nss.declarePrefix(this.envelopeTag.ns[i], this.envelopeTag.ns[i + 1]);
        }
        nss.pushContext();
        for (i = 0; i < this.bodyTag.ns.length; i += 2) {
            nss.declarePrefix(this.bodyTag.ns[i], this.bodyTag.ns[i + 1]);
        }
        ArrayList<String> inscope = new ArrayList<String>();
        Enumeration en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            String prefix = (String)en.nextElement();
            inscope.add(prefix);
            inscope.add(nss.getURI(prefix));
        }
        return inscope.toArray(new String[inscope.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.reader);
            return object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
            XMLStreamReaderUtil.readRest(this.reader);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        T r = bridge.unmarshal(this.reader, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
        return r;
    }

    @Override
    public void consume() {
        assert (this.unconsumed());
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public XMLStreamReader readPayload() {
        assert (this.unconsumed());
        return this.reader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this.payloadLocalName == null) {
            return;
        }
        assert (this.unconsumed());
        XMLStreamReaderToXMLStreamWriter conv = new XMLStreamReaderToXMLStreamWriter();
        while (this.reader.getEventType() != 8) {
            String name = this.reader.getLocalName();
            String nsUri = this.reader.getNamespaceURI();
            if (!(this.reader.getEventType() != 2 || name.equals("Body") && nsUri.equals(this.soapVersion.nsUri))) {
                XMLStreamReaderUtil.nextElementContent(this.reader);
                if (this.reader.getEventType() == 8) break;
                name = this.reader.getLocalName();
                nsUri = this.reader.getNamespaceURI();
            }
            if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
            conv.bridge(this.reader, writer);
        }
        XMLStreamReaderUtil.readRest(this.reader);
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        this.writeEnvelope(sw);
    }

    private void writeEnvelope(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        this.envelopeTag.writeStart(writer);
        HeaderList hl = this.getHeaders();
        if (hl.size() > 0) {
            this.headerTag.writeStart(writer);
            for (Header h : hl) {
                h.writeTo(writer);
            }
            writer.writeEndElement();
        }
        this.bodyTag.writeStart(writer);
        if (this.hasPayload()) {
            this.writePayloadTo(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    @Override
    public void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
        assert (this.unconsumed());
        try {
            if (this.payloadLocalName == null) {
                return;
            }
            XMLStreamReaderToContentHandler conv = new XMLStreamReaderToContentHandler(this.reader, contentHandler, true, fragment);
            while (this.reader.getEventType() != 8) {
                String name = this.reader.getLocalName();
                String nsUri = this.reader.getNamespaceURI();
                if (!(this.reader.getEventType() != 2 || name.equals("Body") && nsUri.equals(this.soapVersion.nsUri))) {
                    XMLStreamReaderUtil.nextElementContent(this.reader);
                    if (this.reader.getEventType() == 8) break;
                    name = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                }
                if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                conv.bridge();
            }
            XMLStreamReaderUtil.readRest(this.reader);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
        }
        catch (XMLStreamException e) {
            Location loc = e.getLocation();
            if (loc == null) {
                loc = DummyLocation.INSTANCE;
            }
            SAXParseException x = new SAXParseException(e.getMessage(), loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber(), e);
            errorHandler.error(x);
        }
    }

    @Override
    public Message copy() {
        try {
            XMLStreamReader clone;
            if (this.hasPayload()) {
                assert (this.unconsumed());
                this.consumedAt = null;
                MutableXMLStreamBuffer xsb = new MutableXMLStreamBuffer();
                StreamReaderBufferCreator c = new StreamReaderBufferCreator(xsb);
                c.storeElement(this.envelopeTag.nsUri, this.envelopeTag.localName, this.envelopeTag.prefix, this.envelopeTag.ns);
                c.storeElement(this.bodyTag.nsUri, this.bodyTag.localName, this.bodyTag.prefix, this.bodyTag.ns);
                while (this.reader.getEventType() != 8) {
                    String name = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (name.equals("Body") && nsUri.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                    c.create(this.reader);
                    if (!this.reader.isWhiteSpace()) continue;
                    XMLStreamReaderUtil.nextElementContent(this.reader);
                }
                XMLStreamReaderUtil.readRest(this.reader);
                XMLStreamReaderUtil.close(this.reader);
                XMLStreamReaderFactory.recycle(this.reader);
                this.reader = xsb.readAsXMLStreamReader();
                clone = xsb.readAsXMLStreamReader();
                this.proceedToRootElement(this.reader);
                this.proceedToRootElement(clone);
            } else {
                clone = this.reader;
            }
            return new StreamMessage(this.envelopeTag, this.headerTag, this.attachmentSet, HeaderList.copy(this.headers), this.bodyTag, clone, this.soapVersion);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException("Failed to copy a message", e);
        }
    }

    private void proceedToRootElement(XMLStreamReader xsr) throws XMLStreamException {
        assert (xsr.getEventType() == 7);
        xsr.nextTag();
        xsr.nextTag();
        xsr.nextTag();
        assert (xsr.getEventType() == 1);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        this.envelopeTag.writeStart(contentHandler);
        this.headerTag.writeStart(contentHandler);
        if (this.hasHeaders()) {
            HeaderList headers = this.getHeaders();
            int len = headers.size();
            for (int i = 0; i < len; ++i) {
                headers.get(i).writeTo(contentHandler, errorHandler);
            }
        }
        this.headerTag.writeEnd(contentHandler);
        this.bodyTag.writeStart(contentHandler);
        this.writePayloadTo(contentHandler, errorHandler, true);
        this.bodyTag.writeEnd(contentHandler);
        this.envelopeTag.writeEnd(contentHandler);
    }

    private boolean unconsumed() {
        if (this.payloadLocalName == null) {
            return true;
        }
        if (this.reader.getEventType() != 1) {
            AssertionError error = new AssertionError((Object)"StreamMessage has been already consumed. See the nested exception for where it's consumed");
            ((Throwable)((Object)error)).initCause(this.consumedAt);
            throw error;
        }
        this.consumedAt = new Exception().fillInStackTrace();
        return true;
    }

    private static void create(SOAPVersion v) {
        int base = v.ordinal() * 3;
        StreamMessage.DEFAULT_TAGS[base] = new TagInfoset(v.nsUri, "Envelope", "S", EMPTY_ATTS, "S", v.nsUri);
        StreamMessage.DEFAULT_TAGS[base + 1] = new TagInfoset(v.nsUri, "Header", "S", EMPTY_ATTS, new String[0]);
        StreamMessage.DEFAULT_TAGS[base + 2] = new TagInfoset(v.nsUri, "Body", "S", EMPTY_ATTS, new String[0]);
    }

    static {
        StreamMessage.create(SOAPVersion.SOAP_11);
        StreamMessage.create(SOAPVersion.SOAP_12);
    }
}

