/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.BaseRow;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;

public class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;
    private JdbcRowSetResourceBundle resBundle;

    public InsertRow(int numCols) {
        this.origVals = new Object[numCols];
        this.colsInserted = new BitSet(numCols);
        this.cols = numCols;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void markColInserted(int col) {
        this.colsInserted.set(col);
    }

    public boolean isCompleteRow(RowSetMetaData RowSetMD) throws SQLException {
        for (int i = 0; i < this.cols; ++i) {
            if (this.colsInserted.get(i) || RowSetMD.isNullable(i + 1) != 0) continue;
            return false;
        }
        return true;
    }

    public void initInsertRow() {
        for (int i = 0; i < this.cols; ++i) {
            this.colsInserted.clear(i);
        }
    }

    public Object getColumnObject(int idx) throws SQLException {
        if (!this.colsInserted.get(idx - 1)) {
            throw new SQLException(this.resBundle.handleGetObject("insertrow.novalue").toString());
        }
        return this.origVals[idx - 1];
    }

    public void setColumnObject(int idx, Object val) {
        this.origVals[idx - 1] = val;
        this.markColInserted(idx - 1);
    }
}

