/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.datatype;

import com.sun.org.apache.xerces.internal.jaxp.datatype.DurationImpl;
import com.sun.org.apache.xerces.internal.util.DatatypeMessageFormatter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class XMLGregorianCalendarImpl
extends XMLGregorianCalendar
implements Serializable,
Cloneable {
    private BigInteger eon = null;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int timezone = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private BigDecimal fractionalSecond = null;
    private static final BigInteger BILLION = new BigInteger("1000000000");
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int MILLISECOND = 6;
    private static final int TIMEZONE = 7;
    private static final String[] FIELD_NAME = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second", "Millisecond", "Timezone"};
    private static final long serialVersionUID = 1L;
    public static final XMLGregorianCalendar LEAP_YEAR_DEFAULT = XMLGregorianCalendarImpl.createDateTime(400, 1, 1, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final BigInteger HUNDRED = BigInteger.valueOf(100L);
    private static final BigInteger FOUR_HUNDRED = BigInteger.valueOf(400L);
    private static final BigInteger SIXTY = BigInteger.valueOf(60L);
    private static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    private static final BigInteger TWELVE = BigInteger.valueOf(12L);
    private static final BigDecimal DECIMAL_ZERO = new BigDecimal("0");
    private static final BigDecimal DECIMAL_ONE = new BigDecimal("1");
    private static final BigDecimal DECIMAL_SIXTY = new BigDecimal("60");
    private static int[] daysInMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected XMLGregorianCalendarImpl(String lexicalRepresentation) throws IllegalArgumentException {
        String format = null;
        String lexRep = lexicalRepresentation;
        int NOT_FOUND = -1;
        int lexRepLength = lexRep.length();
        if (lexRep.indexOf(84) != -1) {
            format = "%Y-%M-%DT%h:%m:%s%z";
        } else if (lexRepLength >= 3 && lexRep.charAt(2) == ':') {
            format = "%h:%m:%s%z";
        } else if (lexRep.startsWith("--")) {
            format = lexRepLength >= 3 && lexRep.charAt(2) == '-' ? "---%D%z" : (lexRepLength == 4 || lexRepLength == 5 || lexRepLength == 10 ? "--%M%z" : "--%M-%D%z");
        } else {
            int countSeparator = 0;
            int timezoneOffset = lexRep.indexOf(58);
            if (timezoneOffset != -1) {
                lexRepLength -= 6;
            }
            for (int i = 1; i < lexRepLength; ++i) {
                if (lexRep.charAt(i) != '-') continue;
                ++countSeparator;
            }
            format = countSeparator == 0 ? "%Y%z" : (countSeparator == 1 ? "%Y-%M%z" : "%Y-%M-%D%z");
        }
        Parser p = new Parser(format, lexRep);
        p.parse();
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCRepresentation", new Object[]{lexicalRepresentation}));
        }
    }

    public XMLGregorianCalendarImpl() {
    }

    protected XMLGregorianCalendarImpl(BigInteger year, int month, int day, int hour, int minute, int second, BigDecimal fractionalSecond, int timezone) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setTime(hour, minute, second, fractionalSecond);
        this.setTimezone(timezone);
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCValue-fractional", new Object[]{year, new Integer(month), new Integer(day), new Integer(hour), new Integer(minute), new Integer(second), fractionalSecond, new Integer(timezone)}));
        }
    }

    private XMLGregorianCalendarImpl(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setTime(hour, minute, second);
        this.setTimezone(timezone);
        this.setMillisecond(millisecond);
        if (!this.isValid()) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidXGCValue-milli", new Object[]{new Integer(year), new Integer(month), new Integer(day), new Integer(hour), new Integer(minute), new Integer(second), new Integer(millisecond), new Integer(timezone)}));
        }
    }

    public XMLGregorianCalendarImpl(GregorianCalendar cal) {
        int year = cal.get(1);
        if (cal.get(0) == 0) {
            year = -year;
        }
        this.setYear(year);
        this.setMonth(cal.get(2) + 1);
        this.setDay(cal.get(5));
        this.setTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        int offsetInMinutes = (cal.get(15) + cal.get(16)) / 60000;
        this.setTimezone(offsetInMinutes);
    }

    public static XMLGregorianCalendar createDateTime(BigInteger year, int month, int day, int hours, int minutes, int seconds, BigDecimal fractionalSecond, int timezone) {
        return new XMLGregorianCalendarImpl(year, month, day, hours, minutes, seconds, fractionalSecond, timezone);
    }

    public static XMLGregorianCalendar createDateTime(int year, int month, int day, int hour, int minute, int second) {
        return new XMLGregorianCalendarImpl(year, month, day, hour, minute, second, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar createDateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, int timezone) {
        return new XMLGregorianCalendarImpl(year, month, day, hours, minutes, seconds, milliseconds, timezone);
    }

    public static XMLGregorianCalendar createDate(int year, int month, int day, int timezone) {
        return new XMLGregorianCalendarImpl(year, month, day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
    }

    public static XMLGregorianCalendar createTime(int hours, int minutes, int seconds, int timezone) {
        return new XMLGregorianCalendarImpl(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, Integer.MIN_VALUE, timezone);
    }

    public static XMLGregorianCalendar createTime(int hours, int minutes, int seconds, BigDecimal fractionalSecond, int timezone) {
        return new XMLGregorianCalendarImpl(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, fractionalSecond, timezone);
    }

    public static XMLGregorianCalendar createTime(int hours, int minutes, int seconds, int milliseconds, int timezone) {
        return new XMLGregorianCalendarImpl(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, milliseconds, timezone);
    }

    public BigInteger getEon() {
        return this.eon;
    }

    public int getYear() {
        return this.year;
    }

    public BigInteger getEonAndYear() {
        if (this.year != Integer.MIN_VALUE && this.eon != null) {
            return this.eon.add(BigInteger.valueOf(this.year));
        }
        if (this.year != Integer.MIN_VALUE && this.eon == null) {
            return BigInteger.valueOf(this.year);
        }
        return null;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    private BigDecimal getSeconds() {
        if (this.second == Integer.MIN_VALUE) {
            return DECIMAL_ZERO;
        }
        BigDecimal result = BigDecimal.valueOf(this.second);
        if (this.fractionalSecond != null) {
            return result.add(this.fractionalSecond);
        }
        return result;
    }

    public int getMillisecond() {
        if (this.fractionalSecond == null) {
            return Integer.MIN_VALUE;
        }
        return this.fractionalSecond.movePointRight(3).intValue();
    }

    public BigDecimal getFractionalSecond() {
        return this.fractionalSecond;
    }

    public void setYear(BigInteger year) {
        if (year == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        } else {
            BigInteger temp = year.remainder(BILLION);
            this.year = temp.intValue();
            this.setEon(year.subtract(temp));
        }
    }

    public void setYear(int year) {
        if (year == Integer.MIN_VALUE) {
            this.year = Integer.MIN_VALUE;
            this.eon = null;
        } else if (Math.abs(year) < BILLION.intValue()) {
            this.year = year;
            this.eon = null;
        } else {
            BigInteger theYear = BigInteger.valueOf(year);
            BigInteger remainder = theYear.remainder(BILLION);
            this.year = remainder.intValue();
            this.setEon(theYear.subtract(remainder));
        }
    }

    private void setEon(BigInteger eon) {
        this.eon = eon != null && eon.compareTo(BigInteger.ZERO) == 0 ? null : eon;
    }

    public void setMonth(int month) {
        if ((month < 1 || 12 < month) && month != Integer.MIN_VALUE) {
            this.invalidFieldValue(1, month);
        }
        this.month = month;
    }

    public void setDay(int day) {
        if ((day < 1 || 31 < day) && day != Integer.MIN_VALUE) {
            this.invalidFieldValue(2, day);
        }
        this.day = day;
    }

    public void setTimezone(int offset) {
        if ((offset < -840 || 840 < offset) && offset != Integer.MIN_VALUE) {
            this.invalidFieldValue(7, offset);
        }
        this.timezone = offset;
    }

    public void setTime(int hour, int minute, int second) {
        this.setTime(hour, minute, second, null);
    }

    private void invalidFieldValue(int field, int value) {
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidFieldValue", new Object[]{new Integer(value), FIELD_NAME[field]}));
    }

    private void testHour() {
        if (this.getHour() == 24 && (this.getMinute() != 0 || this.getSecond() != 0)) {
            this.invalidFieldValue(3, this.getHour());
        }
    }

    public void setHour(int hour) {
        this.setHour(hour, true);
    }

    private void setHour(int hour, boolean validate) {
        if ((hour < 0 || hour > 24) && hour != Integer.MIN_VALUE) {
            this.invalidFieldValue(3, hour);
        }
        this.hour = hour;
        if (validate) {
            this.testHour();
        }
    }

    public void setMinute(int minute) {
        if ((minute < 0 || 59 < minute) && minute != Integer.MIN_VALUE) {
            this.invalidFieldValue(4, minute);
        }
        this.minute = minute;
    }

    public void setSecond(int second) {
        if ((second < 0 || 60 < second) && second != Integer.MIN_VALUE) {
            this.invalidFieldValue(5, second);
        }
        this.second = second;
    }

    public void setTime(int hour, int minute, int second, BigDecimal fractional) {
        this.setHour(hour, false);
        this.setMinute(minute);
        if (second != 60) {
            this.setSecond(second);
        } else if (hour == 23 && minute == 59 || hour == 0 && minute == 0) {
            this.setSecond(second);
        } else {
            this.invalidFieldValue(5, second);
        }
        this.setFractionalSecond(fractional);
        this.testHour();
    }

    public void setTime(int hour, int minute, int second, int millisecond) {
        this.setHour(hour, false);
        this.setMinute(minute);
        if (second != 60) {
            this.setSecond(second);
        } else if (hour == 23 && minute == 59 || hour == 0 && minute == 0) {
            this.setSecond(second);
        } else {
            this.invalidFieldValue(5, second);
        }
        this.setMillisecond(millisecond);
        this.testHour();
    }

    public int compare(XMLGregorianCalendar rhs) {
        XMLGregorianCalendar MaxP;
        XMLGregorianCalendarImpl lhs = this;
        int result = 2;
        XMLGregorianCalendarImpl P = lhs;
        XMLGregorianCalendarImpl Q = (XMLGregorianCalendarImpl)rhs;
        if (P.getTimezone() == Q.getTimezone()) {
            return XMLGregorianCalendarImpl.internalCompare(P, Q);
        }
        if (P.getTimezone() != Integer.MIN_VALUE && Q.getTimezone() != Integer.MIN_VALUE) {
            P = (XMLGregorianCalendarImpl)P.normalize();
            Q = (XMLGregorianCalendarImpl)Q.normalize();
            return XMLGregorianCalendarImpl.internalCompare(P, Q);
        }
        if (P.getTimezone() != Integer.MIN_VALUE) {
            XMLGregorianCalendar MinQ;
            if (P.getTimezone() != 0) {
                P = (XMLGregorianCalendarImpl)P.normalize();
            }
            if ((result = XMLGregorianCalendarImpl.internalCompare(P, MinQ = Q.normalizeToTimezone(840))) == -1) {
                return result;
            }
            XMLGregorianCalendar MaxQ = Q.normalizeToTimezone(-840);
            result = XMLGregorianCalendarImpl.internalCompare(P, MaxQ);
            if (result == 1) {
                return result;
            }
            return 2;
        }
        if (Q.getTimezone() != 0) {
            Q = (XMLGregorianCalendarImpl)Q.normalizeToTimezone(Q.getTimezone());
        }
        if ((result = XMLGregorianCalendarImpl.internalCompare(MaxP = P.normalizeToTimezone(-840), Q)) == -1) {
            return result;
        }
        XMLGregorianCalendar MinP = P.normalizeToTimezone(840);
        result = XMLGregorianCalendarImpl.internalCompare(MinP, Q);
        if (result == 1) {
            return result;
        }
        return 2;
    }

    public XMLGregorianCalendar normalize() {
        XMLGregorianCalendar normalized = this.normalizeToTimezone(this.timezone);
        if (this.getTimezone() == Integer.MIN_VALUE) {
            normalized.setTimezone(Integer.MIN_VALUE);
        }
        if (this.getMillisecond() == Integer.MIN_VALUE) {
            normalized.setMillisecond(Integer.MIN_VALUE);
        }
        return normalized;
    }

    private XMLGregorianCalendar normalizeToTimezone(int timezone) {
        int minutes = timezone;
        XMLGregorianCalendar result = (XMLGregorianCalendar)this.clone();
        DurationImpl d = new DurationImpl((minutes = -minutes) >= 0, 0, 0, 0, 0, minutes < 0 ? -minutes : minutes, 0);
        result.add(d);
        result.setTimezone(0);
        return result;
    }

    private static int internalCompare(XMLGregorianCalendar P, XMLGregorianCalendar Q) {
        int result;
        if (P.getEon() == Q.getEon() ? (result = XMLGregorianCalendarImpl.compareField(P.getYear(), Q.getYear())) != 0 : (result = XMLGregorianCalendarImpl.compareField(P.getEonAndYear(), Q.getEonAndYear())) != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getMonth(), Q.getMonth());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getDay(), Q.getDay());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getHour(), Q.getHour());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getMinute(), Q.getMinute());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getSecond(), Q.getSecond());
        if (result != 0) {
            return result;
        }
        result = XMLGregorianCalendarImpl.compareField(P.getFractionalSecond(), Q.getFractionalSecond());
        return result;
    }

    private static int compareField(int Pfield, int Qfield) {
        if (Pfield == Qfield) {
            return 0;
        }
        if (Pfield == Integer.MIN_VALUE || Qfield == Integer.MIN_VALUE) {
            return 2;
        }
        return Pfield < Qfield ? -1 : 1;
    }

    private static int compareField(BigInteger Pfield, BigInteger Qfield) {
        if (Pfield == null) {
            return Qfield == null ? 0 : 2;
        }
        if (Qfield == null) {
            return 2;
        }
        return Pfield.compareTo(Qfield);
    }

    private static int compareField(BigDecimal Pfield, BigDecimal Qfield) {
        if (Pfield == Qfield) {
            return 0;
        }
        if (Pfield == null) {
            Pfield = DECIMAL_ZERO;
        }
        if (Qfield == null) {
            Qfield = DECIMAL_ZERO;
        }
        return Pfield.compareTo(Qfield);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XMLGregorianCalendar)) {
            return false;
        }
        return this.compare((XMLGregorianCalendar)obj) == 0;
    }

    public int hashCode() {
        int timezone = this.getTimezone();
        if (timezone == Integer.MIN_VALUE) {
            timezone = 0;
        }
        XMLGregorianCalendar gc = this;
        if (timezone != 0) {
            gc = this.normalizeToTimezone(this.getTimezone());
        }
        return gc.getYear() + gc.getMonth() + gc.getDay() + gc.getHour() + gc.getMinute() + gc.getSecond();
    }

    public static XMLGregorianCalendar parse(String lexicalRepresentation) {
        return new XMLGregorianCalendarImpl(lexicalRepresentation);
    }

    public String toXMLFormat() {
        QName typekind = this.getXMLSchemaType();
        String formatString = null;
        if (typekind == DatatypeConstants.DATETIME) {
            formatString = "%Y-%M-%DT%h:%m:%s%z";
        } else if (typekind == DatatypeConstants.DATE) {
            formatString = "%Y-%M-%D%z";
        } else if (typekind == DatatypeConstants.TIME) {
            formatString = "%h:%m:%s%z";
        } else if (typekind == DatatypeConstants.GMONTH) {
            formatString = "--%M%z";
        } else if (typekind == DatatypeConstants.GDAY) {
            formatString = "---%D%z";
        } else if (typekind == DatatypeConstants.GYEAR) {
            formatString = "%Y%z";
        } else if (typekind == DatatypeConstants.GYEARMONTH) {
            formatString = "%Y-%M%z";
        } else if (typekind == DatatypeConstants.GMONTHDAY) {
            formatString = "--%M-%D%z";
        }
        return this.format(formatString);
    }

    public QName getXMLSchemaType() {
        int mask = (this.year != Integer.MIN_VALUE ? 32 : 0) | (this.month != Integer.MIN_VALUE ? 16 : 0) | (this.day != Integer.MIN_VALUE ? 8 : 0) | (this.hour != Integer.MIN_VALUE ? 4 : 0) | (this.minute != Integer.MIN_VALUE ? 2 : 0) | (this.second != Integer.MIN_VALUE ? 1 : 0);
        switch (mask) {
            case 63: {
                return DatatypeConstants.DATETIME;
            }
            case 56: {
                return DatatypeConstants.DATE;
            }
            case 7: {
                return DatatypeConstants.TIME;
            }
            case 48: {
                return DatatypeConstants.GYEARMONTH;
            }
            case 24: {
                return DatatypeConstants.GMONTHDAY;
            }
            case 32: {
                return DatatypeConstants.GYEAR;
            }
            case 16: {
                return DatatypeConstants.GMONTH;
            }
            case 8: {
                return DatatypeConstants.GDAY;
            }
        }
        throw new IllegalStateException(this.getClass().getName() + "#getXMLSchemaType() :" + DatatypeMessageFormatter.formatMessage(null, "InvalidXGCFields", null));
    }

    public boolean isValid() {
        int result;
        BigInteger yearField;
        if (this.getMonth() == 2) {
            int maxDays = 29;
            if (this.eon == null) {
                if (this.year != Integer.MIN_VALUE) {
                    maxDays = XMLGregorianCalendarImpl.maximumDayInMonthFor(this.year, this.getMonth());
                }
            } else {
                BigInteger years = this.getEonAndYear();
                if (years != null) {
                    maxDays = XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), 2);
                }
            }
            if (this.getDay() > maxDays) {
                return false;
            }
        }
        if (this.getHour() == 24) {
            if (this.getMinute() != 0) {
                return false;
            }
            if (this.getSecond() != 0) {
                return false;
            }
        }
        return !(this.eon == null ? this.year == 0 : (yearField = this.getEonAndYear()) != null && (result = XMLGregorianCalendarImpl.compareField(yearField, BigInteger.ZERO)) == 0);
    }

    public void add(Duration duration) {
        BigDecimal startSeconds;
        boolean[] fieldUndefined = new boolean[]{false, false, false, false, false, false};
        int signum = duration.getSign();
        int startMonth = this.getMonth();
        if (startMonth == Integer.MIN_VALUE) {
            startMonth = 1;
            fieldUndefined[1] = true;
        }
        BigInteger dMonths = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MONTHS), signum);
        BigInteger temp = BigInteger.valueOf(startMonth).add(dMonths);
        this.setMonth(temp.subtract(BigInteger.ONE).mod(TWELVE).intValue() + 1);
        BigInteger carry = new BigDecimal(temp.subtract(BigInteger.ONE)).divide(new BigDecimal(TWELVE), 3).toBigInteger();
        BigInteger startYear = this.getEonAndYear();
        if (startYear == null) {
            fieldUndefined[0] = true;
            startYear = BigInteger.ZERO;
        }
        BigInteger dYears = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.YEARS), signum);
        BigInteger endYear = startYear.add(dYears).add(carry);
        this.setYear(endYear);
        if (this.getSecond() == Integer.MIN_VALUE) {
            fieldUndefined[5] = true;
            startSeconds = DECIMAL_ZERO;
        } else {
            startSeconds = this.getSeconds();
        }
        BigDecimal dSeconds = DurationImpl.sanitize((BigDecimal)duration.getField(DatatypeConstants.SECONDS), signum);
        BigDecimal tempBD = startSeconds.add(dSeconds);
        BigDecimal fQuotient = new BigDecimal(new BigDecimal(tempBD.toBigInteger()).divide(DECIMAL_SIXTY, 3).toBigInteger());
        BigDecimal endSeconds = tempBD.subtract(fQuotient.multiply(DECIMAL_SIXTY));
        carry = fQuotient.toBigInteger();
        this.setSecond(endSeconds.intValue());
        BigDecimal tempFracSeconds = endSeconds.subtract(new BigDecimal(BigInteger.valueOf(this.getSecond())));
        if (tempFracSeconds.compareTo(DECIMAL_ZERO) < 0) {
            this.setFractionalSecond(DECIMAL_ONE.add(tempFracSeconds));
            if (this.getSecond() == 0) {
                this.setSecond(59);
                carry = carry.subtract(BigInteger.ONE);
            } else {
                this.setSecond(this.getSecond() - 1);
            }
        } else {
            this.setFractionalSecond(tempFracSeconds);
        }
        int startMinutes = this.getMinute();
        if (startMinutes == Integer.MIN_VALUE) {
            fieldUndefined[4] = true;
            startMinutes = 0;
        }
        BigInteger dMinutes = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MINUTES), signum);
        temp = BigInteger.valueOf(startMinutes).add(dMinutes).add(carry);
        this.setMinute(temp.mod(SIXTY).intValue());
        carry = new BigDecimal(temp).divide(DECIMAL_SIXTY, 3).toBigInteger();
        int startHours = this.getHour();
        if (startHours == Integer.MIN_VALUE) {
            fieldUndefined[3] = true;
            startHours = 0;
        }
        BigInteger dHours = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.HOURS), signum);
        temp = BigInteger.valueOf(startHours).add(dHours).add(carry);
        this.setHour(temp.mod(TWENTY_FOUR).intValue(), false);
        carry = new BigDecimal(temp).divide(new BigDecimal(TWENTY_FOUR), 3).toBigInteger();
        int startDay = this.getDay();
        if (startDay == Integer.MIN_VALUE) {
            fieldUndefined[2] = true;
            startDay = 1;
        }
        BigInteger dDays = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.DAYS), signum);
        int maxDayInMonth = XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth());
        BigInteger tempDays = startDay > maxDayInMonth ? BigInteger.valueOf(maxDayInMonth) : (startDay < 1 ? BigInteger.ONE : BigInteger.valueOf(startDay));
        BigInteger endDays = tempDays.add(dDays).add(carry);
        while (true) {
            int quotient;
            int monthCarry;
            if (endDays.compareTo(BigInteger.ONE) < 0) {
                BigInteger mdimf = null;
                mdimf = this.month >= 2 ? BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth() - 1)) : BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear().subtract(BigInteger.valueOf(1L)), 12));
                endDays = endDays.add(mdimf);
                monthCarry = -1;
            } else {
                if (endDays.compareTo(BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth()))) <= 0) break;
                endDays = endDays.add(BigInteger.valueOf(-XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth())));
                monthCarry = 1;
            }
            int intTemp = this.getMonth() + monthCarry;
            int endMonth = (intTemp - 1) % 12;
            if (endMonth < 0) {
                endMonth = 12 + endMonth + 1;
                quotient = new BigDecimal(intTemp - 1).divide(new BigDecimal(TWELVE), 0).intValue();
            } else {
                quotient = (intTemp - 1) / 12;
                ++endMonth;
            }
            this.setMonth(endMonth);
            if (quotient == 0) continue;
            this.setYear(this.getEonAndYear().add(BigInteger.valueOf(quotient)));
        }
        this.setDay(endDays.intValue());
        block9: for (int i = 0; i <= 5; ++i) {
            if (!fieldUndefined[i]) continue;
            switch (i) {
                case 0: {
                    this.setYear(Integer.MIN_VALUE);
                    continue block9;
                }
                case 1: {
                    this.setMonth(Integer.MIN_VALUE);
                    continue block9;
                }
                case 2: {
                    this.setDay(Integer.MIN_VALUE);
                    continue block9;
                }
                case 3: {
                    this.setHour(Integer.MIN_VALUE, false);
                    continue block9;
                }
                case 4: {
                    this.setMinute(Integer.MIN_VALUE);
                    continue block9;
                }
                case 5: {
                    this.setSecond(Integer.MIN_VALUE);
                    this.setFractionalSecond(null);
                }
            }
        }
    }

    private static int maximumDayInMonthFor(BigInteger year, int month) {
        if (month != 2) {
            return daysInMonth[month];
        }
        if (year.mod(FOUR_HUNDRED).equals(BigInteger.ZERO) || !year.mod(HUNDRED).equals(BigInteger.ZERO) && year.mod(FOUR).equals(BigInteger.ZERO)) {
            return 29;
        }
        return daysInMonth[month];
    }

    private static int maximumDayInMonthFor(int year, int month) {
        if (month != 2) {
            return daysInMonth[month];
        }
        if (year % 400 == 0 || year % 100 != 0 && year % 4 == 0) {
            return 29;
        }
        return daysInMonth[2];
    }

    public GregorianCalendar toGregorianCalendar() {
        GregorianCalendar result = null;
        int DEFAULT_TIMEZONE_OFFSET = Integer.MIN_VALUE;
        TimeZone tz = this.getTimeZone(Integer.MIN_VALUE);
        Locale locale = Locale.getDefault();
        result = new GregorianCalendar(tz, locale);
        result.clear();
        result.setGregorianChange(PURE_GREGORIAN_CHANGE);
        BigInteger year = this.getEonAndYear();
        if (year != null) {
            result.set(0, year.signum() == -1 ? 0 : 1);
            result.set(1, year.abs().intValue());
        }
        if (this.month != Integer.MIN_VALUE) {
            result.set(2, this.month - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            result.set(5, this.day);
        }
        if (this.hour != Integer.MIN_VALUE) {
            result.set(11, this.hour);
        }
        if (this.minute != Integer.MIN_VALUE) {
            result.set(12, this.minute);
        }
        if (this.second != Integer.MIN_VALUE) {
            result.set(13, this.second);
        }
        if (this.fractionalSecond != null) {
            result.set(14, this.getMillisecond());
        }
        return result;
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timezone, Locale aLocale, XMLGregorianCalendar defaults) {
        GregorianCalendar result = null;
        TimeZone tz = timezone;
        if (tz == null) {
            int defaultZoneoffset = Integer.MIN_VALUE;
            if (defaults != null) {
                defaultZoneoffset = defaults.getTimezone();
            }
            tz = this.getTimeZone(defaultZoneoffset);
        }
        if (aLocale == null) {
            aLocale = Locale.getDefault();
        }
        result = new GregorianCalendar(tz, aLocale);
        result.clear();
        result.setGregorianChange(PURE_GREGORIAN_CHANGE);
        BigInteger year = this.getEonAndYear();
        if (year != null) {
            result.set(0, year.signum() == -1 ? 0 : 1);
            result.set(1, year.abs().intValue());
        } else {
            BigInteger defaultYear;
            BigInteger bigInteger = defaultYear = defaults != null ? defaults.getEonAndYear() : null;
            if (defaultYear != null) {
                result.set(0, defaultYear.signum() == -1 ? 0 : 1);
                result.set(1, defaultYear.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            result.set(2, this.month - 1);
        } else {
            int defaultMonth;
            int n = defaultMonth = defaults != null ? defaults.getMonth() : Integer.MIN_VALUE;
            if (defaultMonth != Integer.MIN_VALUE) {
                result.set(2, defaultMonth - 1);
            }
        }
        if (this.day != Integer.MIN_VALUE) {
            result.set(5, this.day);
        } else {
            int defaultDay;
            int n = defaultDay = defaults != null ? defaults.getDay() : Integer.MIN_VALUE;
            if (defaultDay != Integer.MIN_VALUE) {
                result.set(5, defaultDay);
            }
        }
        if (this.hour != Integer.MIN_VALUE) {
            result.set(11, this.hour);
        } else {
            int defaultHour;
            int n = defaultHour = defaults != null ? defaults.getHour() : Integer.MIN_VALUE;
            if (defaultHour != Integer.MIN_VALUE) {
                result.set(11, defaultHour);
            }
        }
        if (this.minute != Integer.MIN_VALUE) {
            result.set(12, this.minute);
        } else {
            int defaultMinute;
            int n = defaultMinute = defaults != null ? defaults.getMinute() : Integer.MIN_VALUE;
            if (defaultMinute != Integer.MIN_VALUE) {
                result.set(12, defaultMinute);
            }
        }
        if (this.second != Integer.MIN_VALUE) {
            result.set(13, this.second);
        } else {
            int defaultSecond;
            int n = defaultSecond = defaults != null ? defaults.getSecond() : Integer.MIN_VALUE;
            if (defaultSecond != Integer.MIN_VALUE) {
                result.set(13, defaultSecond);
            }
        }
        if (this.fractionalSecond != null) {
            result.set(14, this.getMillisecond());
        } else {
            BigDecimal defaultFractionalSecond;
            BigDecimal bigDecimal = defaultFractionalSecond = defaults != null ? defaults.getFractionalSecond() : null;
            if (defaultFractionalSecond != null) {
                result.set(14, defaults.getMillisecond());
            }
        }
        return result;
    }

    public TimeZone getTimeZone(int defaultZoneoffset) {
        TimeZone result = null;
        int zoneoffset = this.getTimezone();
        if (zoneoffset == Integer.MIN_VALUE) {
            zoneoffset = defaultZoneoffset;
        }
        if (zoneoffset == Integer.MIN_VALUE) {
            result = TimeZone.getDefault();
        } else {
            char sign;
            char c = sign = zoneoffset < 0 ? (char)'-' : '+';
            if (sign == '-') {
                zoneoffset = -zoneoffset;
            }
            int hour = zoneoffset / 60;
            int minutes = zoneoffset - hour * 60;
            StringBuffer customTimezoneId = new StringBuffer(8);
            customTimezoneId.append("GMT");
            customTimezoneId.append(sign);
            customTimezoneId.append(hour);
            if (minutes != 0) {
                customTimezoneId.append(minutes);
            }
            result = TimeZone.getTimeZone(customTimezoneId.toString());
        }
        return result;
    }

    public Object clone() {
        return new XMLGregorianCalendarImpl(this.getEonAndYear(), this.month, this.day, this.hour, this.minute, this.second, this.fractionalSecond, this.timezone);
    }

    public void clear() {
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.timezone = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.fractionalSecond = null;
    }

    public void setMillisecond(int millisecond) {
        if (millisecond == Integer.MIN_VALUE) {
            this.fractionalSecond = null;
        } else {
            if ((millisecond < 0 || 999 < millisecond) && millisecond != Integer.MIN_VALUE) {
                this.invalidFieldValue(6, millisecond);
            }
            this.fractionalSecond = new BigDecimal((long)millisecond).movePointLeft(3);
        }
    }

    public void setFractionalSecond(BigDecimal fractional) {
        if (fractional != null && (fractional.compareTo(DECIMAL_ZERO) < 0 || fractional.compareTo(DECIMAL_ONE) > 0)) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidFractional", new Object[]{fractional}));
        }
        this.fractionalSecond = fractional;
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private String format(String format) {
        char[] buf = new char[32];
        int bufPtr = 0;
        int fidx = 0;
        int flen = format.length();
        block9: while (fidx < flen) {
            char fch;
            if ((fch = format.charAt(fidx++)) != '%') {
                buf[bufPtr++] = fch;
                continue;
            }
            switch (format.charAt(fidx++)) {
                case 'Y': {
                    if (this.eon == null) {
                        int y = this.getYear();
                        if (y < 0) {
                            buf[bufPtr++] = 45;
                            y = -y;
                        }
                        bufPtr = this.print4Number(buf, bufPtr, y);
                        continue block9;
                    }
                    String s = this.getEonAndYear().toString();
                    char[] n = new char[buf.length + s.length()];
                    System.arraycopy(buf, 0, n, 0, bufPtr);
                    buf = n;
                    for (int i = s.length(); i < 4; ++i) {
                        buf[bufPtr++] = 48;
                    }
                    s.getChars(0, s.length(), buf, bufPtr);
                    bufPtr += s.length();
                    continue block9;
                }
                case 'M': {
                    bufPtr = this.print2Number(buf, bufPtr, this.getMonth());
                    continue block9;
                }
                case 'D': {
                    bufPtr = this.print2Number(buf, bufPtr, this.getDay());
                    continue block9;
                }
                case 'h': {
                    bufPtr = this.print2Number(buf, bufPtr, this.getHour());
                    continue block9;
                }
                case 'm': {
                    bufPtr = this.print2Number(buf, bufPtr, this.getMinute());
                    continue block9;
                }
                case 's': {
                    bufPtr = this.print2Number(buf, bufPtr, this.getSecond());
                    if (this.getFractionalSecond() == null) continue block9;
                    String frac = this.getFractionalSecond().toString();
                    int pos = frac.indexOf("E-");
                    if (pos >= 0) {
                        int count;
                        String zeros = frac.substring(pos + 2);
                        if ((pos = (frac = frac.substring(0, pos)).indexOf(".")) >= 0) {
                            frac = frac.substring(0, pos) + frac.substring(pos + 1);
                        }
                        if ((count = Integer.parseInt(zeros)) < 40) {
                            frac = "00000000000000000000000000000000000000000".substring(0, count - 1) + frac;
                        } else {
                            while (count > 1) {
                                frac = "0" + frac;
                                --count;
                            }
                        }
                        frac = "0." + frac;
                    }
                    char[] n = new char[buf.length + frac.length()];
                    System.arraycopy(buf, 0, n, 0, bufPtr);
                    buf = n;
                    frac.getChars(1, frac.length(), buf, bufPtr);
                    bufPtr += frac.length() - 1;
                    continue block9;
                }
                case 'z': {
                    int offset = this.getTimezone();
                    if (offset == 0) {
                        buf[bufPtr++] = 90;
                        continue block9;
                    }
                    if (offset == Integer.MIN_VALUE) continue block9;
                    if (offset < 0) {
                        buf[bufPtr++] = 45;
                        offset *= -1;
                    } else {
                        buf[bufPtr++] = 43;
                    }
                    bufPtr = this.print2Number(buf, bufPtr, offset / 60);
                    buf[bufPtr++] = 58;
                    bufPtr = this.print2Number(buf, bufPtr, offset % 60);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return new String(buf, 0, bufPtr);
    }

    private int print2Number(char[] out, int bufptr, int number) {
        out[bufptr++] = (char)(48 + number / 10);
        out[bufptr++] = (char)(48 + number % 10);
        return bufptr;
    }

    private int print4Number(char[] out, int bufptr, int number) {
        out[bufptr + 3] = (char)(48 + number % 10);
        out[bufptr + 2] = (char)(48 + (number /= 10) % 10);
        out[bufptr + 1] = (char)(48 + (number /= 10) % 10);
        out[bufptr] = (char)(48 + (number /= 10) % 10);
        return bufptr + 4;
    }

    static BigInteger sanitize(Number value, int signum) {
        if (signum == 0 || value == null) {
            return BigInteger.ZERO;
        }
        return signum < 0 ? ((BigInteger)value).negate() : (BigInteger)value;
    }

    public void reset() {
    }

    private final class Parser {
        private final String format;
        private final String value;
        private final int flen;
        private final int vlen;
        private int fidx;
        private int vidx;

        private Parser(String format, String value) {
            this.format = format;
            this.value = value;
            this.flen = format.length();
            this.vlen = value.length();
        }

        public void parse() throws IllegalArgumentException {
            block9: while (this.fidx < this.flen) {
                char fch;
                if ((fch = this.format.charAt(this.fidx++)) != '%') {
                    this.skip(fch);
                    continue;
                }
                switch (this.format.charAt(this.fidx++)) {
                    case 'Y': {
                        this.parseAndSetYear(4);
                        continue block9;
                    }
                    case 'M': {
                        XMLGregorianCalendarImpl.this.setMonth(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'D': {
                        XMLGregorianCalendarImpl.this.setDay(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'h': {
                        XMLGregorianCalendarImpl.this.setHour(this.parseInt(2, 2), false);
                        continue block9;
                    }
                    case 'm': {
                        XMLGregorianCalendarImpl.this.setMinute(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 's': {
                        XMLGregorianCalendarImpl.this.setSecond(this.parseInt(2, 2));
                        if (this.peek() != '.') continue block9;
                        XMLGregorianCalendarImpl.this.setFractionalSecond(this.parseBigDecimal());
                        continue block9;
                    }
                    case 'z': {
                        char vch = this.peek();
                        if (vch == 'Z') {
                            ++this.vidx;
                            XMLGregorianCalendarImpl.this.setTimezone(0);
                            continue block9;
                        }
                        if (vch != '+' && vch != '-') continue block9;
                        ++this.vidx;
                        int h = this.parseInt(2, 2);
                        this.skip(':');
                        int m = this.parseInt(2, 2);
                        XMLGregorianCalendarImpl.this.setTimezone((h * 60 + m) * (vch == '+' ? 1 : -1));
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            if (this.vidx != this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private char peek() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                return '\uffff';
            }
            return this.value.charAt(this.vidx);
        }

        private char read() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
            return this.value.charAt(this.vidx++);
        }

        private void skip(char ch) throws IllegalArgumentException {
            if (this.read() != ch) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private int parseInt(int minDigits, int maxDigits) throws IllegalArgumentException {
            char ch;
            int n = 0;
            int vstart = this.vidx;
            while (XMLGregorianCalendarImpl.isDigit(ch = this.peek()) && this.vidx - vstart <= maxDigits) {
                ++this.vidx;
                n = n * 10 + ch - 48;
            }
            if (this.vidx - vstart < minDigits) {
                throw new IllegalArgumentException(this.value);
            }
            return n;
        }

        private void parseAndSetYear(int minDigits) throws IllegalArgumentException {
            char ch;
            int vstart = this.vidx++;
            int n = 0;
            boolean neg = false;
            if (this.peek() == '-') {
                neg = true;
            }
            while (XMLGregorianCalendarImpl.isDigit(ch = this.peek())) {
                ++this.vidx;
                n = n * 10 + ch - 48;
            }
            if (this.vidx - vstart < minDigits) {
                throw new IllegalArgumentException(this.value);
            }
            if (this.vidx - vstart < 7) {
                if (neg) {
                    n = -n;
                }
                XMLGregorianCalendarImpl.this.year = n;
                XMLGregorianCalendarImpl.this.eon = null;
            } else {
                XMLGregorianCalendarImpl.this.setYear(new BigInteger(this.value.substring(vstart, this.vidx)));
            }
        }

        private BigDecimal parseBigDecimal() throws IllegalArgumentException {
            int vstart = this.vidx++;
            if (this.peek() != '.') {
                throw new IllegalArgumentException(this.value);
            }
            while (XMLGregorianCalendarImpl.isDigit(this.peek())) {
                ++this.vidx;
            }
            return new BigDecimal(this.value.substring(vstart, this.vidx));
        }
    }
}

