/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Owner;
import java.util.Enumeration;
import sun.security.acl.GroupImpl;

public class OwnerImpl
implements Owner {
    private Group ownerGroup = new GroupImpl("AclOwners");

    public OwnerImpl(Principal owner) {
        this.ownerGroup.addMember(owner);
    }

    public synchronized boolean addOwner(Principal caller, Principal owner) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.ownerGroup.addMember(owner);
        return false;
    }

    public synchronized boolean deleteOwner(Principal caller, Principal owner) throws NotOwnerException, LastOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        Enumeration<? extends Principal> e = this.ownerGroup.members();
        Principal o = e.nextElement();
        if (e.hasMoreElements()) {
            return this.ownerGroup.removeMember(owner);
        }
        throw new LastOwnerException();
    }

    public synchronized boolean isOwner(Principal owner) {
        return this.ownerGroup.isMember(owner);
    }
}

