/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

abstract class SelectorImpl
extends AbstractSelector {
    protected Set selectedKeys;
    protected HashSet keys = new HashSet();
    private Set publicKeys;
    private Set publicSelectedKeys;

    protected SelectorImpl(SelectorProvider sp) {
        super(sp);
        this.selectedKeys = new HashSet();
        if (Util.atBugLevel("1.4")) {
            this.publicKeys = this.keys;
            this.publicSelectedKeys = this.selectedKeys;
        } else {
            this.publicKeys = Collections.unmodifiableSet(this.keys);
            this.publicSelectedKeys = Util.ungrowableSet(this.selectedKeys);
        }
    }

    public Set keys() {
        if (!this.isOpen() && !Util.atBugLevel("1.4")) {
            throw new ClosedSelectorException();
        }
        return this.publicKeys;
    }

    public Set selectedKeys() {
        if (!this.isOpen() && !Util.atBugLevel("1.4")) {
            throw new ClosedSelectorException();
        }
        return this.publicSelectedKeys;
    }

    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockAndDoSelect(long timeout) throws IOException {
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
            Set set = this.publicKeys;
            synchronized (set) {
                Set set2 = this.publicSelectedKeys;
                synchronized (set2) {
                    return this.doSelect(timeout);
                }
            }
        }
    }

    public int select(long timeout) throws IOException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        return this.lockAndDoSelect(timeout == 0L ? -1L : timeout);
    }

    public int select() throws IOException {
        return this.select(0L);
    }

    public int selectNow() throws IOException {
        return this.lockAndDoSelect(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implCloseSelector() throws IOException {
        this.wakeup();
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            Set set = this.publicKeys;
            synchronized (set) {
                Set set2 = this.publicSelectedKeys;
                synchronized (set2) {
                    this.implClose();
                }
            }
        }
    }

    protected abstract void implClose() throws IOException;

    void putEventOps(SelectionKeyImpl sk, int ops) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SelectionKey register(AbstractSelectableChannel ch, int ops, Object attachment) {
        if (!(ch instanceof SelChImpl)) {
            throw new IllegalSelectorException();
        }
        SelectionKeyImpl k = new SelectionKeyImpl((SelChImpl)((Object)ch), this);
        k.attach(attachment);
        Set set = this.publicKeys;
        synchronized (set) {
            this.implRegister(k);
        }
        k.interestOps(ops);
        return k;
    }

    protected abstract void implRegister(SelectionKeyImpl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeregisterQueue() throws IOException {
        Set<SelectionKey> cks;
        Set<SelectionKey> set = cks = this.cancelledKeys();
        synchronized (set) {
            Iterator<SelectionKey> i = cks.iterator();
            while (i.hasNext()) {
                Object var8_5;
                SelectionKeyImpl ski = (SelectionKeyImpl)i.next();
                try {
                    try {
                        this.implDereg(ski);
                    }
                    catch (SocketException se) {
                        IOException ioe = new IOException("Error deregistering key");
                        ioe.initCause(se);
                        throw ioe;
                    }
                    var8_5 = null;
                    i.remove();
                }
                catch (Throwable throwable) {
                    var8_5 = null;
                    i.remove();
                    throw throwable;
                }
            }
        }
    }

    protected abstract void implDereg(SelectionKeyImpl var1) throws IOException;

    public abstract Selector wakeup();
}

