/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd = new DatagramDispatcher();
    FileDescriptor fd = null;
    int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress = null;
    private int cachedSenderPort = 0;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static int ST_UNCONNECTED = 0;
    private static int ST_CONNECTED = 1;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private SocketAddress localAddress = null;
    SocketAddress remoteAddress = null;
    private SocketOpts.IP options = null;
    private DatagramSocket socket = null;
    private SocketAddress sender;

    public DatagramChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.fd = Net.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ST_UNCONNECTED;
    }

    public DatagramChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = ST_UNCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketAddress receive(ByteBuffer dst) throws IOException {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (dst == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            SocketAddress socketAddress;
            ByteBuffer bb;
            int n;
            block30: {
                SocketAddress socketAddress2;
                block29: {
                    SocketAddress socketAddress3;
                    block27: {
                        block28: {
                            this.ensureOpen();
                            if (!this.isBound()) {
                                return null;
                            }
                            n = 0;
                            bb = null;
                            try {
                                this.begin();
                                if (!this.isOpen()) {
                                    socketAddress3 = null;
                                    Object var9_7 = null;
                                    if (bb == null) break block27;
                                    break block28;
                                }
                                SecurityManager security = System.getSecurityManager();
                                this.readerThread = NativeThread.current();
                                if (this.isConnected() || security == null) {
                                    while ((n = this.receive(this.fd, dst)) == -3 && this.isOpen()) {
                                    }
                                    if (n == -2) {
                                        socketAddress2 = null;
                                        break block29;
                                    }
                                } else {
                                    bb = Util.getTemporaryDirectBuffer(dst.remaining());
                                    while (true) {
                                        if ((n = this.receive(this.fd, bb)) == -3 && this.isOpen()) {
                                            continue;
                                        }
                                        if (n == -2) {
                                            socketAddress = null;
                                            Object var9_9 = null;
                                            if (bb != null) {
                                                Util.releaseTemporaryDirectBuffer(bb);
                                            }
                                            this.readerThread = 0L;
                                            this.end(n > 0 || n == -2);
                                            assert (IOStatus.check(n));
                                            return socketAddress;
                                        }
                                        InetSocketAddress isa = (InetSocketAddress)this.sender;
                                        try {
                                            security.checkAccept(isa.getAddress().getHostAddress(), isa.getPort());
                                        }
                                        catch (SecurityException se) {
                                            bb.clear();
                                            n = 0;
                                            continue;
                                        }
                                        break;
                                    }
                                    bb.flip();
                                    dst.put(bb);
                                }
                                socketAddress = this.sender;
                                break block30;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                if (bb != null) {
                                    Util.releaseTemporaryDirectBuffer(bb);
                                }
                                this.readerThread = 0L;
                                this.end(n > 0 || n == -2);
                                assert (IOStatus.check(n));
                                throw throwable;
                            }
                        }
                        Util.releaseTemporaryDirectBuffer(bb);
                    }
                    this.readerThread = 0L;
                    this.end(n > 0 || n == -2);
                    assert (IOStatus.check(n));
                    return socketAddress3;
                }
                Object var9_8 = null;
                if (bb != null) {
                    Util.releaseTemporaryDirectBuffer(bb);
                }
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return socketAddress2;
            }
            Object var9_10 = null;
            if (bb != null) {
                Util.releaseTemporaryDirectBuffer(bb);
            }
            this.readerThread = 0L;
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
            return socketAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fd, ByteBuffer dst) throws IOException {
        int n;
        int rem;
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n2 = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer && rem > 0) {
            return this.receiveIntoNativeBuffer(fd, dst, rem, pos);
        }
        int newSize = Math.max(rem, 1);
        ByteBuffer bb = null;
        try {
            bb = Util.getTemporaryDirectBuffer(newSize);
            int n3 = this.receiveIntoNativeBuffer(fd, bb, newSize, 0);
            bb.flip();
            if (n3 > 0 && rem > 0) {
                dst.put(bb);
            }
            n = n3;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Util.releaseTemporaryDirectBuffer(bb);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return n;
    }

    private int receiveIntoNativeBuffer(FileDescriptor fd, ByteBuffer bb, int rem, int pos) throws IOException {
        int n = this.receive0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, this.isConnected());
        if (n > 0) {
            bb.position(pos + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        if (src == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block23: {
                boolean bl;
                int n3;
                block22: {
                    this.ensureOpen();
                    InetSocketAddress isa = (InetSocketAddress)target;
                    InetAddress ia = isa.getAddress();
                    if (ia == null) {
                        throw new IOException("Target address not resolved");
                    }
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        if (!this.isConnected()) {
                            if (target == null) {
                                throw new NullPointerException();
                            }
                            SecurityManager sm = System.getSecurityManager();
                            if (sm != null) {
                                if (ia.isMulticastAddress()) {
                                    sm.checkMulticast(isa.getAddress());
                                } else {
                                    sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
                                }
                            }
                        } else {
                            if (!target.equals(this.remoteAddress)) {
                                throw new IllegalArgumentException("Connected address not equal to target address");
                            }
                            return this.write(src);
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var10_11 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block22;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = this.send(this.fd, src, target)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var10_12 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(FileDescriptor fd, ByteBuffer src, SocketAddress target) throws IOException {
        int n;
        if (src instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fd, src, target);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = null;
        try {
            bb = Util.getTemporaryDirectBuffer(rem);
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n2 = this.sendFromNativeBuffer(fd, bb, target);
            if (n2 > 0) {
                src.position(pos + n2);
            }
            n = n2;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Util.releaseTemporaryDirectBuffer(bb);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return n;
    }

    private int sendFromNativeBuffer(FileDescriptor fd, ByteBuffer bb, SocketAddress target) throws IOException {
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int written = this.send0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, target);
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.readerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((n2 = IOUtil.read(this.fd, buf, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.readerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var6_8 = null;
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] bufs) throws IOException {
        if (bufs == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            long l;
            long n;
            block15: {
                boolean bl;
                long l2;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = 0L;
                            Object var8_7 = null;
                            this.readerThread = 0L;
                            bl = n > 0L || n == -2L;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((n = IOUtil.read(this.fd, bufs, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(n);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.readerThread = 0L;
                        this.end(n > 0L || n == -2L);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n));
                return l2;
            }
            Object var8_8 = null;
            this.readerThread = 0L;
            this.end(n > 0L || n == -2L);
            assert (IOStatus.check(n));
            return l;
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(dsts, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = IOUtil.write(this.fd, buf, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var6_8 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] bufs) throws IOException {
        if (bufs == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            long l;
            long n;
            block15: {
                boolean bl;
                long l2;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = 0L;
                            Object var8_7 = null;
                            this.writerThread = 0L;
                            bl = n > 0L || n == -2L;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n = IOUtil.write(this.fd, bufs, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(n);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.writerThread = 0L;
                        this.end(n > 0L || n == -2L);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n));
                return l2;
            }
            Object var8_8 = null;
            this.writerThread = 0L;
            this.end(n > 0L || n == -2L);
            assert (IOStatus.check(n));
            return l;
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(srcs, offset, length));
    }

    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher d = new SocketOptsImpl.Dispatcher(){

                    int getInt(int opt) throws IOException {
                        return Net.getIntOption(DatagramChannelImpl.this.fd, opt);
                    }

                    void setInt(int opt, int arg) throws IOException {
                        Net.setIntOption(DatagramChannelImpl.this.fd, opt, arg);
                    }
                };
                this.options = new SocketOptsImpl.IP(d);
            }
            return this.options;
        }
    }

    public boolean isBound() {
        return Net.localPortNumber(this.fd) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            SecurityManager sm;
            if (this.isConnected() && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            if ((sm = System.getSecurityManager()) != null) {
                InetSocketAddress isa = (InetSocketAddress)this.localAddress;
                sm.checkConnect(isa.getAddress().getHostAddress(), -1);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress local) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress isa = Net.checkAddress(local);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkListen(isa.getPort());
                    }
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ST_CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != ST_UNCONNECTED) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress sa) throws IOException {
        int trafficClass = 0;
        boolean localPort = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress isa = Net.checkAddress(sa);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
                    }
                    if ((n = Net.connect(this.fd, isa.getAddress(), isa.getPort(), trafficClass)) <= 0) {
                        throw new Error();
                    }
                    this.state = ST_CONNECTED;
                    this.remoteAddress = sa;
                    this.sender = isa;
                    this.cachedSenderInetAddress = isa.getAddress();
                    this.cachedSenderPort = isa.getPort();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress isa = (InetSocketAddress)this.remoteAddress;
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
                    }
                    DatagramChannelImpl.disconnect0(this.fd);
                    this.remoteAddress = null;
                    this.state = ST_UNCONNECTED;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long th = this.readerThread;
            if (th != 0L) {
                NativeThread.signal(th);
            }
            if ((th = this.writerThread) != 0L) {
                NativeThread.signal(th);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & 0x20) != 0) {
            return false;
        }
        if ((ops & 0x18) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & 1) != 0 && (intOps & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & 4) != 0 && (intOps & 4) != 0) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & 4) != 0) {
            newOps |= 4;
        }
        if ((ops & 8) != 0) {
            newOps |= 1;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(FileDescriptor var1, long var2, int var4, SocketAddress var5) throws IOException;

    static {
        Util.load();
        DatagramChannelImpl.initIDs();
    }
}

