/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.management.ManagementFactory;
import sun.management.VMManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeImpl
implements RuntimeMXBean {
    private final VMManagement jvm;
    private final long vmStartupTime;

    RuntimeImpl(VMManagement vm) {
        this.jvm = vm;
        this.vmStartupTime = this.jvm.getStartupTime();
    }

    @Override
    public String getName() {
        return this.jvm.getVmId();
    }

    @Override
    public String getManagementSpecVersion() {
        return this.jvm.getManagementVersion();
    }

    @Override
    public String getVmName() {
        return this.jvm.getVmName();
    }

    @Override
    public String getVmVendor() {
        return this.jvm.getVmVendor();
    }

    @Override
    public String getVmVersion() {
        return this.jvm.getVmVersion();
    }

    @Override
    public String getSpecName() {
        return this.jvm.getVmSpecName();
    }

    @Override
    public String getSpecVendor() {
        return this.jvm.getVmSpecVendor();
    }

    @Override
    public String getSpecVersion() {
        return this.jvm.getVmSpecVersion();
    }

    @Override
    public String getClassPath() {
        return this.jvm.getClassPath();
    }

    @Override
    public String getLibraryPath() {
        return this.jvm.getLibraryPath();
    }

    @Override
    public String getBootClassPath() {
        if (!this.isBootClassPathSupported()) {
            throw new UnsupportedOperationException("Boot class path mechanism is not supported");
        }
        ManagementFactory.checkMonitorAccess();
        return this.jvm.getBootClassPath();
    }

    @Override
    public List<String> getInputArguments() {
        ManagementFactory.checkMonitorAccess();
        return this.jvm.getVmArguments();
    }

    @Override
    public long getUptime() {
        long current = System.currentTimeMillis();
        return current - this.vmStartupTime;
    }

    @Override
    public long getStartTime() {
        return this.vmStartupTime;
    }

    @Override
    public boolean isBootClassPathSupported() {
        return this.jvm.isBootClassPathSupported();
    }

    @Override
    public Map<String, String> getSystemProperties() {
        Properties sysProps = System.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String k : keys) {
            String value = sysProps.getProperty(k);
            map.put(k, value);
        }
        return map;
    }
}

