/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.NullFontScaler;
import sun.font.StrikeMetrics;
import sun.font.Type1Font;

class FreetypeFontScaler
extends FontScaler {
    private static final int TRUETYPE_FONT = 1;
    private static final int TYPE1_FONT = 2;

    private static native void initIDs(Class var0);

    private void invalidateScaler() throws FontScalerException {
        this.nativeScaler = 0L;
        this.font = null;
        throw new FontScalerException();
    }

    public FreetypeFontScaler(Font2D font, int indexInCollection, boolean supportsCJK, int filesize) {
        int fonttype = 1;
        if (font instanceof Type1Font) {
            fonttype = 2;
        }
        this.nativeScaler = this.initNativeScaler(font, fonttype, indexInCollection, supportsCJK, filesize);
        this.font = new WeakReference<Font2D>(font);
    }

    synchronized StrikeMetrics getFontMetrics(long pScalerContext) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getFontMetricsNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler);
        }
        return FontManager.getNullScaler().getFontMetrics(0L);
    }

    synchronized float getGlyphAdvance(long pScalerContext, int glyphCode) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphAdvanceNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode);
        }
        return FontManager.getNullScaler().getGlyphAdvance(0L, glyphCode);
    }

    synchronized void getGlyphMetrics(long pScalerContext, int glyphCode, Point2D.Float metrics) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            this.getGlyphMetricsNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode, metrics);
            return;
        }
        FontManager.getNullScaler().getGlyphMetrics(0L, glyphCode, metrics);
    }

    synchronized long getGlyphImage(long pScalerContext, int glyphCode) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphImageNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode);
        }
        return FontManager.getNullScaler().getGlyphImage(0L, glyphCode);
    }

    synchronized Rectangle2D.Float getGlyphOutlineBounds(long pScalerContext, int glyphCode) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphOutlineBoundsNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode);
        }
        return FontManager.getNullScaler().getGlyphOutlineBounds(0L, glyphCode);
    }

    synchronized GeneralPath getGlyphOutline(long pScalerContext, int glyphCode, float x, float y) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphOutlineNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode, x, y);
        }
        return FontManager.getNullScaler().getGlyphOutline(0L, glyphCode, x, y);
    }

    synchronized GeneralPath getGlyphVectorOutline(long pScalerContext, int[] glyphs, int numGlyphs, float x, float y) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphVectorOutlineNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphs, numGlyphs, x, y);
        }
        return FontManager.getNullScaler().getGlyphVectorOutline(0L, glyphs, numGlyphs, x, y);
    }

    synchronized long getLayoutTableCache() throws FontScalerException {
        return this.getLayoutTableCacheNative(this.nativeScaler);
    }

    public synchronized void dispose() {
        if (this.nativeScaler != 0L) {
            this.disposeNativeScaler(this.nativeScaler);
            this.nativeScaler = 0L;
        }
    }

    synchronized int getNumGlyphs() throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getNumGlyphsNative(this.nativeScaler);
        }
        return FontManager.getNullScaler().getNumGlyphs();
    }

    synchronized int getMissingGlyphCode() throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getMissingGlyphCodeNative(this.nativeScaler);
        }
        return FontManager.getNullScaler().getMissingGlyphCode();
    }

    synchronized int getGlyphCode(char charCode) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphCodeNative(this.nativeScaler, charCode);
        }
        return FontManager.getNullScaler().getGlyphCode(charCode);
    }

    synchronized Point2D.Float getGlyphPoint(long pScalerContext, int glyphCode, int ptNumber) throws FontScalerException {
        if (this.nativeScaler != 0L) {
            return this.getGlyphPointNative((Font2D)this.font.get(), pScalerContext, this.nativeScaler, glyphCode, ptNumber);
        }
        return FontManager.getNullScaler().getGlyphPoint(pScalerContext, glyphCode, ptNumber);
    }

    synchronized long getUnitsPerEm() {
        return this.getUnitsPerEMNative(this.nativeScaler);
    }

    long createScalerContext(double[] matrix, boolean fontType, int aa, int fm, float boldness, float italic) {
        if (this.nativeScaler != 0L) {
            return this.createScalerContextNative(this.nativeScaler, matrix, fontType, aa, fm, boldness, italic);
        }
        return NullFontScaler.getNullScalerContext();
    }

    private native long initNativeScaler(Font2D var1, int var2, int var3, boolean var4, int var5);

    private native StrikeMetrics getFontMetricsNative(Font2D var1, long var2, long var4);

    private native float getGlyphAdvanceNative(Font2D var1, long var2, long var4, int var6);

    private native void getGlyphMetricsNative(Font2D var1, long var2, long var4, int var6, Point2D.Float var7);

    private native long getGlyphImageNative(Font2D var1, long var2, long var4, int var6);

    private native Rectangle2D.Float getGlyphOutlineBoundsNative(Font2D var1, long var2, long var4, int var6);

    private native GeneralPath getGlyphOutlineNative(Font2D var1, long var2, long var4, int var6, float var7, float var8);

    private native GeneralPath getGlyphVectorOutlineNative(Font2D var1, long var2, long var4, int[] var6, int var7, float var8, float var9);

    native Point2D.Float getGlyphPointNative(Font2D var1, long var2, long var4, int var6, int var7);

    private native long getLayoutTableCacheNative(long var1);

    private native void disposeNativeScaler(long var1);

    private native int getGlyphCodeNative(long var1, char var3);

    private native int getNumGlyphsNative(long var1);

    private native int getMissingGlyphCodeNative(long var1);

    private native long getUnitsPerEMNative(long var1);

    native long createScalerContextNative(long var1, double[] var3, boolean var4, int var5, int var6, float var7, float var8);

    void invalidateScalerContext(long pScalerContext) {
    }

    static {
        FontManagerNativeLibrary.load();
        FreetypeFontScaler.initIDs(FreetypeFontScaler.class);
    }
}

