/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XNETProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol {
    static final Logger log = Logger.getLogger("sun.awt.X11.XNETProtocol");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XNETProtocol");
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    XAtom XA_NET_SUPPORTING_WM_CHECK = XAtom.get("_NET_SUPPORTING_WM_CHECK");
    XAtom XA_NET_SUPPORTED = XAtom.get("_NET_SUPPORTED");
    XAtom XA_NET_WM_NAME = XAtom.get("_NET_WM_NAME");
    XAtom XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
    XAtom XA_NET_WM_STATE_MAXIMIZED_HORZ = XAtom.get("_NET_WM_STATE_MAXIMIZED_HORZ");
    XAtom XA_NET_WM_STATE_MAXIMIZED_VERT = XAtom.get("_NET_WM_STATE_MAXIMIZED_VERT");
    XAtom XA_NET_WM_STATE_SHADED = XAtom.get("_NET_WM_STATE_SHADED");
    XAtom XA_NET_WM_STATE_ABOVE = XAtom.get("_NET_WM_STATE_ABOVE");
    XAtom XA_NET_WM_STATE_MODAL = XAtom.get("_NET_WM_STATE_MODAL");
    XAtom XA_NET_WM_STATE_FULLSCREEN = XAtom.get("_NET_WM_STATE_FULLSCREEN");
    XAtom XA_NET_WM_STATE_BELOW = XAtom.get("_NET_WM_STATE_BELOW");
    XAtom XA_NET_WM_STATE_HIDDEN = XAtom.get("_NET_WM_STATE_HIDDEN");
    XAtom XA_NET_WM_STATE_SKIP_TASKBAR = XAtom.get("_NET_WM_STATE_SKIP_TASKBAR");
    XAtom XA_NET_WM_STATE_SKIP_PAGER = XAtom.get("_NET_WM_STATE_SKIP_PAGER");
    XAtom XA_NET_WM_WINDOW_TYPE = XAtom.get("_NET_WM_WINDOW_TYPE");
    XAtom XA_NET_WM_WINDOW_TYPE_DIALOG = XAtom.get("_NET_WM_WINDOW_TYPE_DIALOG");
    static final int _NET_WM_STATE_REMOVE = 0;
    static final int _NET_WM_STATE_ADD = 1;
    static final int _NET_WM_STATE_TOGGLE = 2;
    boolean supportChecked = false;
    long NetWindow = 0L;
    String net_wm_name_cache;

    XNETProtocol() {
    }

    @Override
    public boolean supportsState(int state) {
        return this.doStateProtocol();
    }

    @Override
    public void setState(XWindowPeer window, int state) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting state of " + window + " to " + state);
        }
        if (window.isShowing()) {
            this.requestState(window, state);
        } else {
            this.setInitialState(window, state);
        }
    }

    private void setInitialState(XWindowPeer window, int state) {
        XAtomList old_state = window.getNETWMState();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Current state of the window {0} is {1}", new Object[]{String.valueOf(window), String.valueOf(old_state)});
        }
        if ((state & 4) != 0) {
            old_state.add(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        } else {
            old_state.remove(this.XA_NET_WM_STATE_MAXIMIZED_VERT);
        }
        if ((state & 2) != 0) {
            old_state.add(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        } else {
            old_state.remove(this.XA_NET_WM_STATE_MAXIMIZED_HORZ);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Setting initial state of the window {0} to {1}", new Object[]{String.valueOf(window), String.valueOf(old_state)});
        }
        window.setNETWMState(old_state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestState(XWindowPeer window, int state) {
        XClientMessageEvent req;
        block12: {
            block11: {
                int old_net_state = this.getState(window);
                int max_changed = (state ^ old_net_state) & 6;
                req = new XClientMessageEvent();
                try {
                    switch (max_changed) {
                        case 0: {
                            Object var9_6 = null;
                            req.dispose();
                            return;
                        }
                        case 2: {
                            req.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                            req.set_data(2, 0L);
                            break;
                        }
                        case 4: {
                            req.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                            req.set_data(2, 0L);
                            break;
                        }
                        case 6: {
                            req.set_data(1, this.XA_NET_WM_STATE_MAXIMIZED_HORZ.getAtom());
                            req.set_data(2, this.XA_NET_WM_STATE_MAXIMIZED_VERT.getAtom());
                            break;
                        }
                        default: {
                            break block11;
                        }
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Requesting state on " + window + " for " + state);
                    }
                    req.set_type(33);
                    req.set_window(window.getWindow());
                    req.set_message_type(this.XA_NET_WM_STATE.getAtom());
                    req.set_format(32);
                    req.set_data(0, 2L);
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), window.getScreenNumber()), false, 0x180000L, req.pData);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    req.dispose();
                    throw throwable;
                }
            }
            Object var9_7 = null;
            req.dispose();
            return;
        }
        Object var9_8 = null;
        req.dispose();
    }

    @Override
    public int getState(XWindowPeer window) {
        return this.getStateImpl(window);
    }

    int getStateImpl(XWindowPeer window) {
        XAtomList net_wm_state = window.getNETWMState();
        if (net_wm_state.size() == 0) {
            return 0;
        }
        int java_state = 0;
        if (net_wm_state.contains(this.XA_NET_WM_STATE_MAXIMIZED_VERT)) {
            java_state |= 4;
        }
        if (net_wm_state.contains(this.XA_NET_WM_STATE_MAXIMIZED_HORZ)) {
            java_state |= 2;
        }
        return java_state;
    }

    @Override
    public boolean isStateChange(XPropertyEvent e) {
        boolean res;
        boolean bl = res = this.doStateProtocol() && e.get_atom() == this.XA_NET_WM_STATE.getAtom();
        if (res) {
            XWindowPeer wpeer = (XWindowPeer)XToolkit.windowToXWindow(e.get_window());
            wpeer.setNETWMState(null);
        }
        return res;
    }

    @Override
    public void unshadeKludge(XWindowPeer window) {
        XAtomList net_wm_state = window.getNETWMState();
        net_wm_state.remove(this.XA_NET_WM_STATE_SHADED);
        window.setNETWMState(net_wm_state);
    }

    @Override
    public boolean supportsLayer(int layer) {
        return (layer == 1 || layer == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateHelper(XWindowPeer window, XAtom state, boolean set) {
        log.log(Level.FINER, "Window visibility is: withdrawn={0}, visible={1}, mapped={2} showing={3}", new Object[]{window.isWithdrawn(), window.isVisible(), window.isMapped(), window.isShowing()});
        if (window.isShowing()) {
            XClientMessageEvent req = new XClientMessageEvent();
            try {
                req.set_type(33);
                req.set_window(window.getWindow());
                req.set_message_type(this.XA_NET_WM_STATE.getAtom());
                req.set_format(32);
                req.set_data(0, !set ? 0L : 1L);
                req.set_data(1, state.getAtom());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Setting _NET_STATE atom {0} on {1} for {2}", new Object[]{String.valueOf(state), String.valueOf(window), set});
                }
                XToolkit.awtLock();
                try {
                    XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), window.getScreenNumber()), false, 0x180000L, req.pData);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
                XToolkit.awtUnlock();
                Object var8_9 = null;
                req.dispose();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                req.dispose();
                throw throwable;
            }
        }
        XAtomList net_wm_state = window.getNETWMState();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Current state on {0} is {1}", new Object[]{String.valueOf(window), String.valueOf(net_wm_state)});
        }
        if (!set) {
            net_wm_state.remove(state);
        } else {
            net_wm_state.add(state);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Setting states on {0} to {1}", new Object[]{String.valueOf(window), String.valueOf(net_wm_state)});
        }
        window.setNETWMState(net_wm_state);
        XToolkit.XSync();
    }

    @Override
    public void setLayer(XWindowPeer window, int layer) {
        this.setStateHelper(window, this.XA_NET_WM_STATE_ABOVE, layer == 1);
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.NetWindow = this.checkAnchor(this.XA_NET_SUPPORTING_WM_CHECK, 33L);
        this.supportChecked = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " is active: " + (this.NetWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.NetWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean res = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE);
        return res;
    }

    boolean doLayerProtocol() {
        boolean res = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_ABOVE);
        return res;
    }

    boolean doModalityProtocol() {
        boolean res = this.active() && this.checkProtocol(this.XA_NET_SUPPORTED, this.XA_NET_WM_STATE_MODAL);
        return res;
    }

    boolean isWMName(String name) {
        if (!this.active()) {
            return false;
        }
        String net_wm_name_string = this.getWMName();
        if (net_wm_name_string == null) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("### WM_NAME = " + net_wm_name_string);
        }
        return net_wm_name_string.startsWith(name);
    }

    public String getWMName() {
        if (!this.active()) {
            return null;
        }
        if (this.net_wm_name_cache != null) {
            return this.net_wm_name_cache;
        }
        String charSet = "UTF8";
        byte[] net_wm_name = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, this.XA_UTF8_STRING.getAtom());
        if (net_wm_name == null) {
            net_wm_name = this.XA_NET_WM_NAME.getByteArrayProperty(this.NetWindow, 31L);
            charSet = "ASCII";
        }
        if (net_wm_name == null) {
            return null;
        }
        try {
            this.net_wm_name_cache = new String(net_wm_name, charSet);
            return this.net_wm_name_cache;
        }
        catch (UnsupportedEncodingException uex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWMIcons(XWindowPeer window, List<XIconInfo> icons) {
        if (window == null) {
            return;
        }
        XAtom iconsAtom = XAtom.get("_NET_WM_ICON");
        if (icons == null) {
            iconsAtom.DeleteProperty(window);
            return;
        }
        int length = 0;
        for (XIconInfo ii : icons) {
            length += ii.getRawLength();
        }
        int cardinalSize = XlibWrapper.dataModel == 32 ? 4 : 8;
        int bufferSize = length * cardinalSize;
        if (bufferSize != 0) {
            long buffer = XlibWrapper.unsafe.allocateMemory(bufferSize);
            try {
                long ptr = buffer;
                for (XIconInfo ii : icons) {
                    int size = ii.getRawLength() * cardinalSize;
                    if (XlibWrapper.dataModel == 32) {
                        XlibWrapper.copyIntArray(ptr, ii.getIntData(), size);
                    } else {
                        XlibWrapper.copyLongArray(ptr, ii.getLongData(), size);
                    }
                    ptr += (long)size;
                }
                iconsAtom.setAtomData(window.getWindow(), 6L, buffer, bufferSize / Native.getCard32Size());
                Object var15_14 = null;
                XlibWrapper.unsafe.freeMemory(buffer);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                XlibWrapper.unsafe.freeMemory(buffer);
                throw throwable;
            }
        } else {
            iconsAtom.DeleteProperty(window);
        }
    }

    public boolean isWMStateNetHidden(XWindowPeer window) {
        if (!this.doStateProtocol()) {
            return false;
        }
        XAtomList state = window.getNETWMState();
        return state != null && state.size() != 0 && state.contains(this.XA_NET_WM_STATE_HIDDEN);
    }
}

