/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;
import sun.awt.AppContext;

public class LayoutQueue {
    private static final Object DEFAULT_QUEUE = new Object();
    private Vector tasks = new Vector();
    private Thread worker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutQueue getDefaultQueue() {
        AppContext ac = AppContext.getAppContext();
        Object object = DEFAULT_QUEUE;
        synchronized (object) {
            LayoutQueue defaultQueue = (LayoutQueue)ac.get(DEFAULT_QUEUE);
            if (defaultQueue == null) {
                defaultQueue = new LayoutQueue();
                ac.put(DEFAULT_QUEUE, defaultQueue);
            }
            return defaultQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultQueue(LayoutQueue q) {
        Object object = DEFAULT_QUEUE;
        synchronized (object) {
            AppContext.getAppContext().put(DEFAULT_QUEUE, q);
        }
    }

    public synchronized void addTask(Runnable task) {
        if (this.worker == null) {
            this.worker = new LayoutThread();
            this.worker.start();
        }
        this.tasks.addElement(task);
        this.notifyAll();
    }

    protected synchronized Runnable waitForWork() {
        while (this.tasks.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        Runnable work = (Runnable)this.tasks.firstElement();
        this.tasks.removeElementAt(0);
        return work;
    }

    class LayoutThread
    extends Thread {
        LayoutThread() {
            super("text-layout");
            this.setPriority(1);
        }

        public void run() {
            Runnable work;
            do {
                if ((work = LayoutQueue.this.waitForWork()) == null) continue;
                work.run();
            } while (work != null);
        }
    }
}

