/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalUtils;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetalBumps bumps;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI(JComponent c) {
        return new MetalScrollBarUI();
    }

    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
        this.bumps = new MetalBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    protected void installListeners() {
        super.installListeners();
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener();
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        boolean leftToRight = MetalUtils.isLeftToRight(c);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                trackBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            if (c.isEnabled()) {
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, 0, trackBounds.height - 1);
                g.drawLine(trackBounds.width - 2, 0, trackBounds.width - 2, trackBounds.height - 1);
                g.drawLine(2, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                g.drawLine(2, 0, trackBounds.width - 2, 0);
                g.setColor(shadowColor);
                g.drawLine(1, 1, 1, trackBounds.height - 2);
                g.drawLine(1, 1, trackBounds.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int y = this.thumbRect.y + this.thumbRect.height - trackBounds.y;
                    g.drawLine(1, y, trackBounds.width - 1, y);
                }
                g.setColor(highlightColor);
                g.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height - 1);
            } else {
                MetalUtils.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.isFreeStanding) {
                trackBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                trackBounds.height += 2;
            }
            if (c.isEnabled()) {
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, trackBounds.width - 1, 0);
                g.drawLine(0, 2, 0, trackBounds.height - 2);
                g.drawLine(0, trackBounds.height - 2, trackBounds.width - 1, trackBounds.height - 2);
                g.drawLine(trackBounds.width - 1, 2, trackBounds.width - 1, trackBounds.height - 1);
                g.setColor(shadowColor);
                g.drawLine(1, 1, trackBounds.width - 2, 1);
                g.drawLine(1, 1, 1, trackBounds.height - 3);
                g.drawLine(0, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int x = this.thumbRect.x + this.thumbRect.width - trackBounds.x;
                    g.drawLine(x, 1, x, trackBounds.height - 1);
                }
            } else {
                MetalUtils.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.isFreeStanding) {
                trackBounds.height -= 2;
            }
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintThumb(g, c, thumbBounds);
            return;
        }
        boolean leftToRight = MetalUtils.isLeftToRight(c);
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            g.setColor(thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            this.bumps.setBumpArea(thumbBounds.width - 6, thumbBounds.height - 7);
            this.bumps.paintIcon(c, g, 3, 4);
            if (!this.isFreeStanding) {
                thumbBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g.setColor(thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 3);
            this.bumps.setBumpArea(thumbBounds.width - 7, thumbBounds.height - 6);
            this.bumps.paintIcon(c, g, 4, 3);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private void oceanPaintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        boolean leftToRight = MetalUtils.isLeftToRight(c);
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            if (thumbColor != null) {
                g.setColor(thumbColor);
                g.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            }
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            MetalUtils.drawGradient(c, g, "ScrollBar.gradient", 2, 2, thumbBounds.width - 4, thumbBounds.height - 3, false);
            int gripSize = thumbBounds.width - 8;
            if (gripSize > 2 && thumbBounds.height >= 10) {
                int counter;
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                int gripY = thumbBounds.height / 2 - 2;
                for (counter = 0; counter < 6; counter += 2) {
                    g.fillRect(4, counter + gripY, gripSize, 1);
                }
                g.setColor(MetalLookAndFeel.getWhite());
                ++gripY;
                for (counter = 0; counter < 6; counter += 2) {
                    g.fillRect(5, counter + gripY, gripSize, 1);
                }
            }
            if (!this.isFreeStanding) {
                thumbBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            if (thumbColor != null) {
                g.setColor(thumbColor);
                g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            }
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 2, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 3);
            MetalUtils.drawGradient(c, g, "ScrollBar.gradient", 2, 2, thumbBounds.width - 3, thumbBounds.height - 4, true);
            int gripSize = thumbBounds.height - 8;
            if (gripSize > 2 && thumbBounds.width >= 10) {
                int counter;
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                int gripX = thumbBounds.width / 2 - 2;
                for (counter = 0; counter < 6; counter += 2) {
                    g.fillRect(gripX + counter, 4, 1, gripSize);
                }
                g.setColor(MetalLookAndFeel.getWhite());
                ++gripX;
                for (counter = 0; counter < 6; counter += 2) {
                    g.fillRect(gripX + counter, 5, 1, gripSize);
                }
            }
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        if (this.thumbRect.x == x && this.thumbRect.y == y && this.thumbRect.width == width && this.thumbRect.height == height) {
            return;
        }
        int minX = Math.min(x, this.thumbRect.x);
        int minY = Math.min(y, this.thumbRect.y);
        int maxX = Math.max(x + width, this.thumbRect.x + this.thumbRect.width);
        int maxY = Math.max(y + height, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(x, y, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        ScrollBarListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }

        public void handlePropertyChange(Object newValue) {
            if (newValue != null) {
                boolean temp = (Boolean)newValue;
                boolean becameFlush = !temp && MetalScrollBarUI.this.isFreeStanding;
                boolean becameNormal = temp && !MetalScrollBarUI.this.isFreeStanding;
                MetalScrollBarUI.this.isFreeStanding = temp;
                if (becameFlush) {
                    this.toFlush();
                } else if (becameNormal) {
                    this.toFreeStanding();
                }
            } else if (!MetalScrollBarUI.this.isFreeStanding) {
                MetalScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (MetalScrollBarUI.this.increaseButton != null) {
                MetalScrollBarUI.this.increaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
            if (MetalScrollBarUI.this.decreaseButton != null) {
                MetalScrollBarUI.this.decreaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
        }

        protected void toFlush() {
            MetalScrollBarUI.this.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            MetalScrollBarUI.this.scrollBarWidth += 2;
        }
    }
}

