/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.GenericFileSystemView;
import javax.swing.filechooser.UnixFileSystemView;
import javax.swing.filechooser.WindowsFileSystemView;
import sun.awt.shell.ShellFolder;

public abstract class FileSystemView {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;
    static boolean useSystemExtensionsHiding = false;

    public static FileSystemView getFileSystemView() {
        useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lookAndFeel")) {
                    useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
                }
            }
        });
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public boolean isRoot(File f) {
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        File[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }

    public String getSystemDisplayName(File f) {
        String name = null;
        if (!(f == null || (name = f.getName()).equals("..") || name.equals(".") || !useSystemExtensionsHiding && this.isFileSystem(f) && !this.isFileSystemRoot(f) || !(f instanceof ShellFolder) && !f.exists() || (name = this.getShellFolder(f).getDisplayName()) != null && name.length() != 0)) {
            name = f.getPath();
        }
        return name;
    }

    public String getSystemTypeDescription(File f) {
        return null;
    }

    public Icon getSystemIcon(File f) {
        if (f != null) {
            ShellFolder sf = this.getShellFolder(f);
            Image img = sf.getIcon(false);
            if (img != null) {
                return new ImageIcon(img, sf.getFolderType());
            }
            return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        if (folder instanceof ShellFolder) {
            File parent = file.getParentFile();
            if (parent != null && parent.equals(folder)) {
                return true;
            }
            File[] children = this.getFiles(folder, false);
            for (int i = 0; i < children.length; ++i) {
                if (!file.equals(children[i])) continue;
                return true;
            }
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    public File getChild(File parent, String fileName) {
        if (parent instanceof ShellFolder) {
            File[] children = this.getFiles(parent, false);
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getName().equals(fileName)) continue;
                return children[i];
            }
        }
        return this.createFileObject(parent, fileName);
    }

    public boolean isFileSystem(File f) {
        if (f instanceof ShellFolder) {
            ShellFolder sf = (ShellFolder)f;
            return sf.isFileSystem() && (!sf.isLink() || !sf.isDirectory());
        }
        return true;
    }

    public abstract File createNewFolder(File var1) throws IOException;

    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    public boolean isFileSystemRoot(File dir) {
        return ShellFolder.isFileSystemRoot(dir);
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isComputerNode(File dir) {
        return ShellFolder.isComputerNode(dir);
    }

    public File[] getRoots() {
        File[] roots = (File[])ShellFolder.get("roots");
        for (int i = 0; i < roots.length; ++i) {
            if (!this.isFileSystemRoot(roots[i])) continue;
            roots[i] = this.createFileSystemRoot(roots[i]);
        }
        return roots;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        File f = (File)ShellFolder.get("fileChooserDefaultFolder");
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    public File createFileObject(String path) {
        File f = new File(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<File> files = new Vector<File>();
        if (!(dir instanceof ShellFolder)) {
            dir = this.getShellFolder(dir);
        }
        File[] names = ((ShellFolder)dir).listFiles(!useFileHiding);
        int nameCount = names == null ? 0 : names.length;
        for (int i = 0; i < nameCount && !Thread.currentThread().isInterrupted(); ++i) {
            File f = names[i];
            if (!(f instanceof ShellFolder)) {
                if (this.isFileSystemRoot(f)) {
                    f = this.createFileSystemRoot(f);
                }
                try {
                    f = ShellFolder.getShellFolder(f);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (InternalError e) {
                    continue;
                }
            }
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.addElement(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public File getParentDirectory(File dir) {
        ShellFolder sf;
        File psf;
        if (dir != null && dir.exists() && (psf = (sf = this.getShellFolder(dir)).getParentFile()) != null) {
            if (this.isFileSystem(psf)) {
                File ppsf;
                File f = psf;
                if (!(f == null || f.exists() || (ppsf = psf.getParentFile()) != null && this.isFileSystem(ppsf))) {
                    f = this.createFileSystemRoot(f);
                }
                return f;
            }
            return psf;
        }
        return null;
    }

    ShellFolder getShellFolder(File f) {
        if (!(f instanceof ShellFolder) && !(f instanceof FileSystemRoot) && this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        try {
            return ShellFolder.getShellFolder(f);
        }
        catch (FileNotFoundException e) {
            System.err.println("FileSystemView.getShellFolder: f=" + f);
            e.printStackTrace();
            return null;
        }
        catch (InternalError e) {
            System.err.println("FileSystemView.getShellFolder: f=" + f);
            e.printStackTrace();
            return null;
        }
    }

    protected File createFileSystemRoot(File f) {
        return new FileSystemRoot(f);
    }

    static class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        public boolean isDirectory() {
            return true;
        }

        public String getName() {
            return this.getPath();
        }
    }
}

