/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class SmartGridLayout
implements LayoutManager,
Serializable {
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    public SmartGridLayout(int numColumns, int numRows) {
        this.rows = numRows;
        this.columns = numColumns;
        this.layoutGrid = new Component[numColumns][numRows];
    }

    public void layoutContainer(Container c) {
        this.buildLayoutGrid(c);
        int[] rowHeights = new int[this.rows];
        int[] columnWidths = new int[this.columns];
        for (int row = 0; row < this.rows; ++row) {
            rowHeights[row] = this.computeRowHeight(row);
        }
        for (int column = 0; column < this.columns; ++column) {
            columnWidths[column] = this.computeColumnWidth(column);
        }
        Insets insets = c.getInsets();
        if (c.getComponentOrientation().isLeftToRight()) {
            int horizLoc = insets.left;
            for (int column = 0; column < this.columns; ++column) {
                int vertLoc = insets.top;
                for (int row = 0; row < this.rows; ++row) {
                    Component current = this.layoutGrid[column][row];
                    current.setBounds(horizLoc, vertLoc, columnWidths[column], rowHeights[row]);
                    vertLoc += rowHeights[row] + this.yGap;
                }
                horizLoc += columnWidths[column] + this.xGap;
            }
        } else {
            int horizLoc = c.getWidth() - insets.right;
            for (int column = 0; column < this.columns; ++column) {
                int vertLoc = insets.top;
                horizLoc -= columnWidths[column];
                for (int row = 0; row < this.rows; ++row) {
                    Component current = this.layoutGrid[column][row];
                    current.setBounds(horizLoc, vertLoc, columnWidths[column], rowHeights[row]);
                    vertLoc += rowHeights[row] + this.yGap;
                }
                horizLoc -= this.xGap;
            }
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        this.buildLayoutGrid(c);
        Insets insets = c.getInsets();
        int height = 0;
        int width = 0;
        for (int row = 0; row < this.rows; ++row) {
            height += this.computeRowHeight(row);
        }
        for (int column = 0; column < this.columns; ++column) {
            width += this.computeColumnWidth(column);
        }
        return new Dimension(width += this.xGap * (this.columns - 1) + insets.right + insets.left, height += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    public void addLayoutComponent(String s, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    private void buildLayoutGrid(Container c) {
        Component[] children = c.getComponents();
        for (int componentCount = 0; componentCount < children.length; ++componentCount) {
            int row = 0;
            int column = 0;
            if (componentCount != 0) {
                column = componentCount % this.columns;
                row = (componentCount - column) / this.columns;
            }
            this.layoutGrid[column][row] = children[componentCount];
        }
    }

    private int computeColumnWidth(int columnNum) {
        int maxWidth = 1;
        for (int row = 0; row < this.rows; ++row) {
            int width = this.layoutGrid[columnNum][row].getPreferredSize().width;
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private int computeRowHeight(int rowNum) {
        int maxHeight = 1;
        for (int column = 0; column < this.columns; ++column) {
            int height = this.layoutGrid[column][rowNum].getPreferredSize().height;
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        return maxHeight;
    }
}

