/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class LogRecord
implements Serializable {
    private static long globalSequenceNumber;
    private static int nextThreadId;
    private static ThreadLocal<Integer> threadIds;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;
    private static final long serialVersionUID = 5372048053134512534L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level level, String msg) {
        level.getClass();
        this.level = level;
        this.message = msg;
        Class<LogRecord> clazz = LogRecord.class;
        synchronized (LogRecord.class) {
            this.sequenceNumber = globalSequenceNumber++;
            Integer id = threadIds.get();
            if (id == null) {
                id = new Integer(nextThreadId++);
                threadIds.set(id);
            }
            this.threadID = id;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.millis = System.currentTimeMillis();
            this.needToInferCaller = true;
            return;
        }
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundle = bundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String name) {
        this.resourceBundleName = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.level = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long seq) {
        this.sequenceNumber = seq;
    }

    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
        this.needToInferCaller = false;
    }

    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
        this.needToInferCaller = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int threadID) {
        this.threadID = threadID;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeByte(1);
        out.writeByte(0);
        if (this.parameters == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] == null) {
                out.writeObject(null);
                continue;
            }
            out.writeObject(this.parameters[i].toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte major = in.readByte();
        byte minor = in.readByte();
        if (major != 1) {
            throw new IOException("LogRecord: bad version: " + major + "." + minor);
        }
        int len = in.readInt();
        if (len == -1) {
            this.parameters = null;
        } else {
            this.parameters = new Object[len];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = in.readObject();
            }
        }
        if (this.resourceBundleName != null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException ex) {
                this.resourceBundle = null;
            }
        }
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        this.needToInferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals("java.util.logging.Logger"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals("java.util.logging.Logger")) {
                this.setSourceClassName(cname);
                this.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }

    static {
        nextThreadId = 10;
        threadIds = new ThreadLocal();
    }
}

