/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

class GenericBeanInfo
extends SimpleBeanInfo {
    private BeanDescriptor beanDescriptor;
    private EventSetDescriptor[] events;
    private int defaultEvent;
    private PropertyDescriptor[] properties;
    private int defaultProperty;
    private MethodDescriptor[] methods;
    private BeanInfo targetBeanInfo;

    public GenericBeanInfo(BeanDescriptor beanDescriptor, EventSetDescriptor[] events, int defaultEvent, PropertyDescriptor[] properties, int defaultProperty, MethodDescriptor[] methods, BeanInfo targetBeanInfo) {
        this.beanDescriptor = beanDescriptor;
        this.events = events;
        this.defaultEvent = defaultEvent;
        this.properties = properties;
        this.defaultProperty = defaultProperty;
        this.methods = methods;
        this.targetBeanInfo = targetBeanInfo;
    }

    GenericBeanInfo(GenericBeanInfo old) {
        int i;
        int len;
        this.beanDescriptor = new BeanDescriptor(old.beanDescriptor);
        if (old.events != null) {
            len = old.events.length;
            this.events = new EventSetDescriptor[len];
            for (i = 0; i < len; ++i) {
                this.events[i] = new EventSetDescriptor(old.events[i]);
            }
        }
        this.defaultEvent = old.defaultEvent;
        if (old.properties != null) {
            len = old.properties.length;
            this.properties = new PropertyDescriptor[len];
            for (i = 0; i < len; ++i) {
                PropertyDescriptor oldp = old.properties[i];
                this.properties[i] = oldp instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)oldp) : new PropertyDescriptor(oldp);
            }
        }
        this.defaultProperty = old.defaultProperty;
        if (old.methods != null) {
            len = old.methods.length;
            this.methods = new MethodDescriptor[len];
            for (i = 0; i < len; ++i) {
                this.methods[i] = new MethodDescriptor(old.methods[i]);
            }
        }
        this.targetBeanInfo = old.targetBeanInfo;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    public int getDefaultPropertyIndex() {
        return this.defaultProperty;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    public int getDefaultEventIndex() {
        return this.defaultEvent;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public Image getIcon(int iconKind) {
        if (this.targetBeanInfo != null) {
            return this.targetBeanInfo.getIcon(iconKind);
        }
        return super.getIcon(iconKind);
    }
}

