/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.im.InputContext;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.util.IdentityArrayList;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends Container
implements Accessible {
    String warningString;
    transient List<Image> icons;
    private transient Component temporaryLostComponent;
    static boolean systemSyncLWRequests;
    boolean syncLWRequests = false;
    transient boolean beforeFirstShow = true;
    static final int OPENED = 1;
    int state;
    private boolean alwaysOnTop;
    private static final IdentityArrayList<Window> allWindows;
    transient Vector<WeakReference<Window>> ownedWindowList = new Vector();
    private transient WeakReference<Window> weakThis;
    transient boolean showWithParent;
    transient Dialog modalBlocker;
    Dialog.ModalExclusionType modalExclusionType;
    transient WindowListener windowListener;
    transient WindowStateListener windowStateListener;
    transient WindowFocusListener windowFocusListener;
    transient InputContext inputContext;
    private transient Object inputContextLock = new Object();
    private FocusManager focusMgr;
    private boolean focusableWindowState = true;
    private volatile transient boolean autoRequestFocus = true;
    transient boolean isInShow = false;
    private static final String base = "win";
    private static int nameCounter;
    private static final long serialVersionUID = 4497834738069338734L;
    private static final Logger log;
    private static final boolean locationByPlatformProp;
    transient boolean isTrayIconWindow = false;
    transient Object anchor = new Object();
    private static final AtomicBoolean beforeFirstWindowShown;
    private int windowSerializedDataVersion = 2;
    private boolean locationByPlatform = locationByPlatformProp;

    private static native void initIDs();

    Window(GraphicsConfiguration gc) {
        this.init(gc);
    }

    private void init(GraphicsConfiguration gc) {
        GraphicsEnvironment.checkHeadless();
        this.syncLWRequests = systemSyncLWRequests;
        this.weakThis = new WeakReference<Window>(this);
        this.addToWindowList();
        this.setWarningString();
        this.cursor = Cursor.getPredefinedCursor(0);
        this.visible = false;
        this.graphicsConfig = gc == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : gc;
        if (this.graphicsConfig.getDevice().getType() != 0) {
            throw new IllegalArgumentException("not a screen device");
        }
        this.setLayout(new BorderLayout());
        Rectangle screenBounds = this.graphicsConfig.getBounds();
        Insets screenInsets = this.getToolkit().getScreenInsets(this.graphicsConfig);
        int x = this.getX() + screenBounds.x + screenInsets.left;
        int y = this.getY() + screenBounds.y + screenInsets.top;
        if (x != this.x || y != this.y) {
            this.setLocation(x, y);
            this.setLocationByPlatform(locationByPlatformProp);
        }
        this.modalExclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        Disposer.addRecord(this.anchor, new WindowDisposerRecord(this.appContext, this));
    }

    Window() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.init(null);
    }

    public Window(Frame owner) {
        this(owner == null ? (GraphicsConfiguration)null : owner.getGraphicsConfiguration());
        this.ownedInit(owner);
    }

    public Window(Window owner) {
        this(owner == null ? (GraphicsConfiguration)null : owner.getGraphicsConfiguration());
        this.ownedInit(owner);
    }

    public Window(Window owner, GraphicsConfiguration gc) {
        this(gc);
        this.ownedInit(owner);
    }

    private void ownedInit(Window owner) {
        this.parent = owner;
        if (owner != null) {
            owner.addOwnedWindow(this.weakThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    public List<Image> getIconImages() {
        List<Image> icons = this.icons;
        if (icons == null || icons.size() == 0) {
            return new ArrayList<Image>();
        }
        return new ArrayList<Image>(icons);
    }

    public synchronized void setIconImages(List<? extends Image> icons) {
        this.icons = icons == null ? new ArrayList<Image>() : new ArrayList<Image>(icons);
        WindowPeer peer = (WindowPeer)this.peer;
        if (peer != null) {
            peer.updateIconImages();
        }
        this.firePropertyChange("iconImage", null, null);
    }

    public void setIconImage(Image image) {
        ArrayList<Image> imageList = new ArrayList<Image>();
        if (image != null) {
            imageList.add(image);
        }
        this.setIconImages(imageList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container parent = this.parent;
            if (parent != null && parent.getPeer() == null) {
                parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createWindow(this);
            }
            IdentityArrayList<Window> identityArrayList = allWindows;
            synchronized (identityArrayList) {
                allWindows.add(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            IdentityArrayList<Window> identityArrayList = allWindows;
            synchronized (identityArrayList) {
                allWindows.remove(this);
            }
            super.removeNotify();
        }
    }

    public void pack() {
        Container parent = this.parent;
        if (parent != null && parent.getPeer() == null) {
            parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Dimension newSize = this.getPreferredSize();
        if (this.peer != null) {
            this.setClientSize(newSize.width, newSize.height);
        }
        if (this.beforeFirstShow) {
            this.isPacked = true;
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinimumSize(Dimension minimumSize) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setMinimumSize(minimumSize);
            Dimension size = this.getSize();
            if (this.isMinimumSizeSet() && (size.width < minimumSize.width || size.height < minimumSize.height)) {
                int nw = Math.max(this.width, minimumSize.width);
                int nh = Math.max(this.height, minimumSize.height);
                this.setSize(nw, nh);
            }
            if (this.peer != null) {
                ((WindowPeer)this.peer).updateMinimumSize();
            }
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    @Override
    @Deprecated
    public void reshape(int x, int y, int width, int height) {
        if (this.isMinimumSizeSet()) {
            Dimension minSize = this.getMinimumSize();
            if (width < minSize.width) {
                width = minSize.width;
            }
            if (height < minSize.height) {
                height = minSize.height;
            }
        }
        super.reshape(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientSize(int w, int h) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setBoundsOp(4);
            this.setBounds(this.x, this.y, w, h);
        }
    }

    static final void closeSplashScreen() {
        if (beforeFirstWindowShown.getAndSet(false)) {
            SunToolkit.closeSplashScreen();
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    @Override
    @Deprecated
    public void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        this.isInShow = true;
        if (this.visible) {
            this.toFront();
        } else {
            this.beforeFirstShow = false;
            Window.closeSplashScreen();
            Dialog.checkShouldBeBlocked(this);
            super.show();
            this.locationByPlatform = false;
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window child = (Window)this.ownedWindowList.elementAt(i).get();
                if (child == null || !child.showWithParent) continue;
                child.show();
                child.showWithParent = false;
            }
            if (!this.isModalBlocked()) {
                this.updateChildrenBlocking();
            } else {
                this.modalBlocker.toFront_NoClientCode();
            }
            if (this instanceof Frame || this instanceof Dialog) {
                Window.updateChildFocusableWindowState(this);
            }
        }
        this.isInShow = false;
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    static void updateChildFocusableWindowState(Window w) {
        if (w.getPeer() != null && w.isShowing()) {
            ((WindowPeer)w.getPeer()).updateFocusableWindowState();
        }
        for (int i = 0; i < w.ownedWindowList.size(); ++i) {
            Window child = (Window)w.ownedWindowList.elementAt(i).get();
            if (child == null) continue;
            Window.updateChildFocusableWindowState(child);
        }
    }

    synchronized void postWindowEvent(int id) {
        if (this.windowListener != null || (this.eventMask & 0x40L) != 0L || Toolkit.enabledOnToolkit(64L)) {
            WindowEvent e = new WindowEvent(this, id);
            Toolkit.getEventQueue().postEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void hide() {
        Vector<WeakReference<Window>> vector = this.ownedWindowList;
        synchronized (vector) {
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window child = (Window)this.ownedWindowList.elementAt(i).get();
                if (child == null || !child.visible) continue;
                child.hide();
                child.showWithParent = true;
            }
        }
        if (this.isModalBlocked()) {
            this.modalBlocker.unblockWindow(this);
        }
        super.hide();
    }

    @Override
    final void clearMostRecentFocusOwnerOnHide() {
    }

    public void dispose() {
        this.doDispose();
    }

    void disposeImpl() {
        this.dispose();
        if (this.getPeer() != null) {
            this.doDispose();
        }
    }

    void doDispose() {
        class DisposeAction
        implements Runnable {
            DisposeAction() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object[] ownedWindowArray;
                GraphicsDevice gd = Window.this.getGraphicsConfiguration().getDevice();
                if (gd.getFullScreenWindow() == Window.this) {
                    gd.setFullScreenWindow(null);
                }
                Vector<WeakReference<Window>> vector = Window.this.ownedWindowList;
                synchronized (vector) {
                    ownedWindowArray = new Object[Window.this.ownedWindowList.size()];
                    Window.this.ownedWindowList.copyInto(ownedWindowArray);
                }
                for (int i = 0; i < ownedWindowArray.length; ++i) {
                    Window child = (Window)((WeakReference)ownedWindowArray[i]).get();
                    if (child == null) continue;
                    child.disposeImpl();
                }
                Window.this.hide();
                Window.this.beforeFirstShow = true;
                Window.this.removeNotify();
                Object object = Window.this.inputContextLock;
                synchronized (object) {
                    if (Window.this.inputContext != null) {
                        Window.this.inputContext.dispose();
                        Window.this.inputContext = null;
                    }
                }
                Window.this.clearCurrentFocusCycleRootOnHide();
            }
        }
        DisposeAction action = new DisposeAction();
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            try {
                EventQueue.invokeAndWait(action);
            }
            catch (InterruptedException e) {
                System.err.println("Disposal was interrupted:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                System.err.println("Exception during disposal:");
                e.printStackTrace();
            }
        }
        this.postWindowEvent(202);
    }

    @Override
    void adjustListeningChildrenOnParent(long mask, int num) {
    }

    @Override
    void adjustDecendantsOnParent(int num) {
    }

    public void toFront() {
        this.toFront_NoClientCode();
    }

    final void toFront_NoClientCode() {
        if (this.visible) {
            WindowPeer peer = (WindowPeer)this.peer;
            if (peer != null) {
                peer.toFront();
            }
            if (this.isModalBlocked()) {
                this.modalBlocker.toFront_NoClientCode();
            }
        }
    }

    public void toBack() {
        this.toBack_NoClientCode();
    }

    final void toBack_NoClientCode() {
        WindowPeer peer;
        if (this.isAlwaysOnTop()) {
            try {
                this.setAlwaysOnTop(false);
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (this.visible && (peer = (WindowPeer)this.peer) != null) {
            peer.toBack();
        }
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    private void setWarningString() {
        this.warningString = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !sm.checkTopLevelWindow(this)) {
            this.warningString = AccessController.doPrivileged(new GetPropertyAction("awt.appletWarning", "Java Applet Window"));
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputContext getInputContext() {
        Object object = this.inputContextLock;
        synchronized (object) {
            if (this.inputContext == null) {
                this.inputContext = InputContext.getInstance();
            }
        }
        return this.inputContext;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(0);
        }
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return this.getOwner_NoClientCode();
    }

    final Window getOwner_NoClientCode() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        return this.getOwnedWindows_NoClientCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Window[] getOwnedWindows_NoClientCode() {
        Window[] realCopy;
        Vector<WeakReference<Window>> vector = this.ownedWindowList;
        synchronized (vector) {
            int fullSize = this.ownedWindowList.size();
            int realSize = 0;
            Window[] fullCopy = new Window[fullSize];
            for (int i = 0; i < fullSize; ++i) {
                fullCopy[realSize] = (Window)this.ownedWindowList.elementAt(i).get();
                if (fullCopy[realSize] == null) continue;
                ++realSize;
            }
            realCopy = fullSize != realSize ? Arrays.copyOf(fullCopy, realSize) : fullCopy;
        }
        return realCopy;
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    void setModalBlocked(Dialog blocker, boolean blocked, boolean peerCall) {
        WindowPeer peer;
        Dialog dialog = this.modalBlocker = blocked ? blocker : null;
        if (peerCall && (peer = (WindowPeer)this.peer) != null) {
            peer.setModalBlocked(blocker, blocked);
        }
    }

    Dialog getModalBlocker() {
        return this.modalBlocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityArrayList<Window> getAllWindows() {
        IdentityArrayList<Window> identityArrayList = allWindows;
        synchronized (identityArrayList) {
            IdentityArrayList<Window> v = new IdentityArrayList<Window>();
            v.addAll(allWindows);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityArrayList<Window> getAllUnblockedWindows() {
        IdentityArrayList<Window> identityArrayList = allWindows;
        synchronized (identityArrayList) {
            IdentityArrayList<Window> unblocked = new IdentityArrayList<Window>();
            for (int i = 0; i < allWindows.size(); ++i) {
                Window w = allWindows.get(i);
                if (w.isModalBlocked()) continue;
                unblocked.add(w);
            }
            return unblocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Window[] getWindows(AppContext appContext) {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Window[] realCopy;
            Vector windowList = (Vector)appContext.get(Window.class);
            if (windowList != null) {
                int fullSize = windowList.size();
                int realSize = 0;
                Window[] fullCopy = new Window[fullSize];
                for (int i = 0; i < fullSize; ++i) {
                    Window w = (Window)((WeakReference)windowList.get(i)).get();
                    if (w == null) continue;
                    fullCopy[realSize++] = w;
                }
                realCopy = fullSize != realSize ? Arrays.copyOf(fullCopy, realSize) : fullCopy;
            } else {
                realCopy = new Window[]{};
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return realCopy;
        }
    }

    public static Window[] getWindows() {
        return Window.getWindows(AppContext.getAppContext());
    }

    public static Window[] getOwnerlessWindows() {
        Window[] allWindows = Window.getWindows();
        int ownerlessCount = 0;
        for (Window w : allWindows) {
            if (w.getOwner() != null) continue;
            ++ownerlessCount;
        }
        Window[] ownerless = new Window[ownerlessCount];
        int c = 0;
        for (Window w : allWindows) {
            if (w.getOwner() != null) continue;
            ownerless[c++] = w;
        }
        return ownerless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Window getDocumentRoot() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Window w = this;
            while (w.getOwner() != null) {
                w = w.getOwner();
            }
            return w;
        }
    }

    public void setModalExclusionType(Dialog.ModalExclusionType exclusionType) {
        SecurityManager sm;
        if (exclusionType == null) {
            exclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        }
        if (!Toolkit.getDefaultToolkit().isModalExclusionTypeSupported(exclusionType)) {
            exclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        }
        if (this.modalExclusionType == exclusionType) {
            return;
        }
        if (exclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SecurityConstants.TOOLKIT_MODALITY_PERMISSION);
        }
        this.modalExclusionType = exclusionType;
    }

    public Dialog.ModalExclusionType getModalExclusionType() {
        return this.modalExclusionType;
    }

    boolean isModalExcluded(Dialog.ModalExclusionType exclusionType) {
        if (this.modalExclusionType != null && this.modalExclusionType.compareTo(exclusionType) >= 0) {
            return true;
        }
        Window owner = this.getOwner_NoClientCode();
        return owner != null && owner.isModalExcluded(exclusionType);
    }

    void updateChildrenBlocking() {
        Vector<Window> childHierarchy = new Vector<Window>();
        Window[] ownedWindows = this.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            childHierarchy.add(ownedWindows[i]);
        }
        for (int k = 0; k < childHierarchy.size(); ++k) {
            Window w = (Window)childHierarchy.get(k);
            if (!w.isVisible()) continue;
            if (w.isModalBlocked()) {
                Dialog blocker = w.getModalBlocker();
                blocker.unblockWindow(w);
            }
            Dialog.checkShouldBeBlocked(w);
            Window[] wOwned = w.getOwnedWindows();
            for (int j = 0; j < wOwned.length; ++j) {
                childHierarchy.add(wOwned[j]);
            }
        }
    }

    public synchronized void addWindowListener(WindowListener l) {
        if (l == null) {
            return;
        }
        this.newEventsOnly = true;
        this.windowListener = AWTEventMulticaster.add(this.windowListener, l);
    }

    public synchronized void addWindowStateListener(WindowStateListener l) {
        if (l == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void addWindowFocusListener(WindowFocusListener l) {
        if (l == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowListener(WindowListener l) {
        if (l == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, l);
    }

    public synchronized void removeWindowStateListener(WindowStateListener l) {
        if (l == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, l);
    }

    public synchronized void removeWindowFocusListener(WindowFocusListener l) {
        if (l == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, l);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])this.getListeners(WindowListener.class);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])this.getListeners(WindowFocusListener.class);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])this.getListeners(WindowStateListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener l = null;
        if (listenerType == WindowFocusListener.class) {
            l = this.windowFocusListener;
        } else if (listenerType == WindowStateListener.class) {
            l = this.windowStateListener;
        } else if (listenerType == WindowListener.class) {
            l = this.windowListener;
        } else {
            return super.getListeners(listenerType);
        }
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        switch (e.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
            case 207: 
            case 208: {
                return (this.eventMask & 0x80000L) != 0L || this.windowFocusListener != null;
            }
            case 209: {
                return (this.eventMask & 0x40000L) != 0L || this.windowStateListener != null;
            }
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof WindowEvent) {
            switch (e.getID()) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    this.processWindowEvent((WindowEvent)e);
                    break;
                }
                case 207: 
                case 208: {
                    this.processWindowFocusEvent((WindowEvent)e);
                    break;
                }
                case 209: {
                    this.processWindowStateEvent((WindowEvent)e);
                }
            }
            return;
        }
        super.processEvent(e);
    }

    protected void processWindowEvent(WindowEvent e) {
        WindowListener listener = this.windowListener;
        if (listener != null) {
            switch (e.getID()) {
                case 200: {
                    listener.windowOpened(e);
                    break;
                }
                case 201: {
                    listener.windowClosing(e);
                    break;
                }
                case 202: {
                    listener.windowClosed(e);
                    break;
                }
                case 203: {
                    listener.windowIconified(e);
                    break;
                }
                case 204: {
                    listener.windowDeiconified(e);
                    break;
                }
                case 205: {
                    listener.windowActivated(e);
                    break;
                }
                case 206: {
                    listener.windowDeactivated(e);
                    break;
                }
            }
        }
    }

    protected void processWindowFocusEvent(WindowEvent e) {
        WindowFocusListener listener = this.windowFocusListener;
        if (listener != null) {
            switch (e.getID()) {
                case 207: {
                    listener.windowGainedFocus(e);
                    break;
                }
                case 208: {
                    listener.windowLostFocus(e);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent e) {
        WindowStateListener listener = this.windowStateListener;
        if (listener != null) {
            switch (e.getID()) {
                case 209: {
                    listener.windowStateChanged(e);
                    break;
                }
            }
        }
    }

    @Override
    void preProcessKeyEvent(KeyEvent e) {
        if (e.isActionKey() && e.getKeyCode() == 112 && e.isControlDown() && e.isShiftDown() && e.getID() == 401) {
            this.list(System.out, 0);
        }
    }

    @Override
    void postProcessKeyEvent(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlwaysOnTop(boolean alwaysOnTop) throws SecurityException {
        boolean oldAlwaysOnTop;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.SET_WINDOW_ALWAYS_ON_TOP_PERMISSION);
        }
        Window window = this;
        synchronized (window) {
            oldAlwaysOnTop = this.alwaysOnTop;
            this.alwaysOnTop = alwaysOnTop;
        }
        if (oldAlwaysOnTop != alwaysOnTop) {
            if (this.isAlwaysOnTopSupported()) {
                WindowPeer peer = (WindowPeer)this.peer;
                Object object = this.getTreeLock();
                synchronized (object) {
                    if (peer != null) {
                        peer.setAlwaysOnTop(alwaysOnTop);
                    }
                }
            }
            this.firePropertyChange("alwaysOnTop", oldAlwaysOnTop, alwaysOnTop);
        }
    }

    public boolean isAlwaysOnTopSupported() {
        return Toolkit.getDefaultToolkit().isAlwaysOnTopSupported();
    }

    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public Component getFocusOwner() {
        return this.isFocused() ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() : null;
    }

    public Component getMostRecentFocusOwner() {
        if (this.isFocused()) {
            return this.getFocusOwner();
        }
        Component mostRecent = KeyboardFocusManager.getMostRecentFocusOwner(this);
        if (mostRecent != null) {
            return mostRecent;
        }
        return this.isFocusableWindow() ? this.getFocusTraversalPolicy().getInitialComponent(this) : null;
    }

    public boolean isActive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == this;
    }

    public boolean isFocused() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusedWindow() == this;
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        Set keystrokes;
        if (id < 0 || id >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        Set set = keystrokes = this.focusTraversalKeys != null ? this.focusTraversalKeys[id] : null;
        if (keystrokes != null) {
            return keystrokes;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
    }

    @Override
    public final void setFocusCycleRoot(boolean focusCycleRoot) {
    }

    @Override
    public final boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        if (this instanceof Frame || this instanceof Dialog) {
            return true;
        }
        if (this.getFocusTraversalPolicy().getDefaultComponent(this) == null) {
            return false;
        }
        for (Window owner = this.getOwner(); owner != null; owner = owner.getOwner()) {
            if (!(owner instanceof Frame) && !(owner instanceof Dialog)) continue;
            return owner.isShowing();
        }
        return false;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusableWindowState(boolean focusableWindowState) {
        boolean oldFocusableWindowState;
        Window window = this;
        synchronized (window) {
            oldFocusableWindowState = this.focusableWindowState;
            this.focusableWindowState = focusableWindowState;
        }
        WindowPeer peer = (WindowPeer)this.peer;
        if (peer != null) {
            peer.updateFocusableWindowState();
        }
        this.firePropertyChange("focusableWindowState", oldFocusableWindowState, focusableWindowState);
        if (oldFocusableWindowState && !focusableWindowState && this.isFocused()) {
            for (Window owner = this.getOwner(); owner != null; owner = owner.getOwner()) {
                Component toFocus = KeyboardFocusManager.getMostRecentFocusOwner(owner);
                if (toFocus == null || !toFocus.requestFocus(false, CausedFocusEvent.Cause.ACTIVATION)) continue;
                return;
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.getID() == 101) {
            this.invalidate();
            this.validate();
        }
        super.dispatchEventImpl(e);
    }

    @Override
    @Deprecated
    public boolean postEvent(Event e) {
        if (this.handleEvent(e)) {
            e.consume();
            return true;
        }
        return false;
    }

    @Override
    public boolean isShowing() {
        return this.visible;
    }

    @Deprecated
    public void applyResourceBundle(ResourceBundle rb) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(rb));
    }

    @Deprecated
    public void applyResourceBundle(String rbName) {
        this.applyResourceBundle(ResourceBundle.getBundle(rbName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOwnedWindow(WeakReference weakWindow) {
        if (weakWindow != null) {
            Vector<WeakReference<Window>> vector = this.ownedWindowList;
            synchronized (vector) {
                if (!this.ownedWindowList.contains(weakWindow)) {
                    this.ownedWindowList.addElement(weakWindow);
                }
            }
        }
    }

    void removeOwnedWindow(WeakReference weakWindow) {
        if (weakWindow != null) {
            this.ownedWindowList.removeElement(weakWindow);
        }
    }

    void connectOwnedWindow(Window child) {
        child.parent = this;
        this.addOwnedWindow(child.weakThis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWindowList() {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Vector<WeakReference<Window>> windowList = (Vector<WeakReference<Window>>)this.appContext.get(Window.class);
            if (windowList == null) {
                windowList = new Vector<WeakReference<Window>>();
                this.appContext.put(Window.class, windowList);
            }
            windowList.add(this.weakThis);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromWindowList(AppContext context, WeakReference weakThis) {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Vector windowList = (Vector)context.get(Window.class);
            if (windowList != null) {
                windowList.remove(weakThis);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void removeFromWindowList() {
        Window.removeFromWindowList(this.appContext, this.weakThis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Serializable serializable = this;
        synchronized (serializable) {
            this.focusMgr = new FocusManager();
            this.focusMgr.focusRoot = this;
            this.focusMgr.focusOwner = this.getMostRecentFocusOwner();
            s.defaultWriteObject();
            this.focusMgr = null;
            AWTEventMulticaster.save(s, "windowL", this.windowListener);
            AWTEventMulticaster.save(s, "windowFocusL", this.windowFocusListener);
            AWTEventMulticaster.save(s, "windowStateL", this.windowStateListener);
        }
        s.writeObject(null);
        serializable = this.ownedWindowList;
        synchronized (serializable) {
            for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                Window child = (Window)this.ownedWindowList.elementAt(i).get();
                if (child == null) continue;
                s.writeObject("ownedL");
                s.writeObject(child);
            }
        }
        s.writeObject(null);
        if (this.icons != null) {
            for (Image i : this.icons) {
                if (!(i instanceof Serializable)) continue;
                s.writeObject(i);
            }
        }
        s.writeObject(null);
    }

    private void initDeserializedWindow() {
        this.setWarningString();
        this.inputContextLock = new Object();
        this.visible = false;
        this.weakThis = new WeakReference<Window>(this);
        this.anchor = new Object();
        Disposer.addRecord(this.anchor, new WindowDisposerRecord(this.appContext, this));
        this.addToWindowList();
    }

    private void deserializeResources(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        String key;
        Object keyOrNull;
        this.ownedWindowList = new Vector();
        if (this.windowSerializedDataVersion < 2) {
            if (this.focusMgr != null && this.focusMgr.focusOwner != null) {
                KeyboardFocusManager.setMostRecentFocusOwner(this, this.focusMgr.focusOwner);
            }
            this.focusableWindowState = true;
        }
        while (null != (keyOrNull = s.readObject())) {
            key = ((String)keyOrNull).intern();
            if ("windowL" == key) {
                this.addWindowListener((WindowListener)s.readObject());
                continue;
            }
            if ("windowFocusL" == key) {
                this.addWindowFocusListener((WindowFocusListener)s.readObject());
                continue;
            }
            if ("windowStateL" == key) {
                this.addWindowStateListener((WindowStateListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        try {
            while (null != (keyOrNull = s.readObject())) {
                key = ((String)keyOrNull).intern();
                if ("ownedL" == key) {
                    this.connectOwnedWindow((Window)s.readObject());
                    continue;
                }
                s.readObject();
            }
            Object obj = s.readObject();
            this.icons = new ArrayList<Image>();
            while (obj != null) {
                if (obj instanceof Image) {
                    this.icons.add((Image)obj);
                }
                obj = s.readObject();
            }
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.initDeserializedWindow();
        ObjectInputStream.GetField f = s.readFields();
        this.syncLWRequests = f.get("syncLWRequests", systemSyncLWRequests);
        this.state = f.get("state", 0);
        this.focusableWindowState = f.get("focusableWindowState", true);
        this.windowSerializedDataVersion = f.get("windowSerializedDataVersion", 1);
        this.locationByPlatform = f.get("locationByPlatform", locationByPlatformProp);
        this.focusMgr = (FocusManager)f.get("focusMgr", null);
        Dialog.ModalExclusionType et = (Dialog.ModalExclusionType)((Object)f.get("modalExclusionType", (Object)Dialog.ModalExclusionType.NO_EXCLUDE));
        this.setModalExclusionType(et);
        boolean aot = f.get("alwaysOnTop", false);
        if (aot) {
            this.setAlwaysOnTop(aot);
        }
        this.deserializeResources(s);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig == null && !GraphicsEnvironment.isHeadless()) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            return this.graphicsConfig;
        }
    }

    @Override
    void resetGC() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setGCFromPeer();
            if (this.graphicsConfig == null) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("+ Window.resetGC(): new GC is \n+ " + this.graphicsConfig + "\n+ this is " + this);
            }
        }
    }

    public void setLocationRelativeTo(Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = this.getSize();
            Point centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            this.setLocation(centerPoint.x - paneSize.width / 2, centerPoint.y - paneSize.height / 2);
        } else {
            Dimension invokerSize = c.getSize();
            Point invokerScreenLocation = c.getLocationOnScreen();
            Rectangle windowBounds = this.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Rectangle ss = root.getGraphicsConfiguration().getBounds();
            if (dy + windowBounds.height > ss.y + ss.height) {
                dy = ss.y + ss.height - windowBounds.height;
                dx = invokerScreenLocation.x - ss.x + invokerSize.width / 2 < ss.width / 2 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.x + ss.width) {
                dx = ss.x + ss.width - windowBounds.width;
            }
            if (dx < ss.x) {
                dx = ss.x;
            }
            if (dy < ss.y) {
                dy = ss.y;
            }
            this.setLocation(dx, dy);
        }
    }

    void deliverMouseWheelToAncestor(MouseWheelEvent e) {
    }

    @Override
    boolean dispatchMouseWheelToAncestor(MouseWheelEvent e) {
        return false;
    }

    @Override
    public void createBufferStrategy(int numBuffers) {
        super.createBufferStrategy(numBuffers);
    }

    @Override
    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        super.createBufferStrategy(numBuffers, caps);
    }

    @Override
    public BufferStrategy getBufferStrategy() {
        return super.getBufferStrategy();
    }

    Component getTemporaryLostComponent() {
        return this.temporaryLostComponent;
    }

    Component setTemporaryLostComponent(Component component) {
        Component previousComp = this.temporaryLostComponent;
        this.temporaryLostComponent = component == null || component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable() ? component : null;
        return previousComp;
    }

    @Override
    boolean canContainFocusOwner(Component focusOwnerCandidate) {
        return super.canContainFocusOwner(focusOwnerCandidate) && this.isFocusableWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationByPlatform(boolean locationByPlatform) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (locationByPlatform && this.isShowing()) {
                throw new IllegalComponentStateException("The window is showing on screen.");
            }
            this.locationByPlatform = locationByPlatform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocationByPlatform() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.locationByPlatform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getBoundsOp() == 1 || this.getBoundsOp() == 3) {
                this.locationByPlatform = false;
            }
            super.setBounds(x, y, width, height);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    boolean isRecursivelyVisible() {
        return this.visible;
    }

    @Override
    final Container getContainer() {
        return null;
    }

    @Override
    final void applyCompoundShape(Region shape) {
    }

    @Override
    final void applyCurrentShape() {
    }

    @Override
    final void mixOnReshaping() {
    }

    @Override
    final Point getLocationOnWindow() {
        return new Point(0, 0);
    }

    static {
        String s;
        systemSyncLWRequests = false;
        allWindows = new IdentityArrayList();
        nameCounter = 0;
        log = Logger.getLogger("java.awt.Window");
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Window.initIDs();
        }
        systemSyncLWRequests = (s = AccessController.doPrivileged(new GetPropertyAction("java.awt.syncLWRequests"))) != null && s.equals("true");
        s = AccessController.doPrivileged(new GetPropertyAction("java.awt.Window.locationByPlatform"));
        locationByPlatformProp = s != null && s.equals("true");
        beforeFirstWindowShown = new AtomicBoolean(true);
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        protected AccessibleAWTWindow() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Window.this.getFocusOwner() != null) {
                states.add(AccessibleState.ACTIVE);
            }
            return states;
        }
    }

    static class WindowDisposerRecord
    implements DisposerRecord {
        final WeakReference<Window> owner;
        final WeakReference weakThis;
        final AppContext context;

        WindowDisposerRecord(AppContext context, Window victim) {
            this.owner = new WeakReference<Window>(victim.getOwner());
            this.weakThis = victim.weakThis;
            this.context = context;
        }

        public void dispose() {
            Window parent = (Window)this.owner.get();
            if (parent != null) {
                parent.removeOwnedWindow(this.weakThis);
            }
            Window.removeFromWindowList(this.context, this.weakThis);
        }
    }
}

