/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import sun.security.util.Password;

public class TextCallbackHandler
implements CallbackHandler {
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ConfirmationCallback confirmation = null;
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                String text;
                TextOutputCallback tc = (TextOutputCallback)callbacks[i];
                switch (tc.getMessageType()) {
                    case 0: {
                        text = "";
                        break;
                    }
                    case 1: {
                        text = "Warning: ";
                        break;
                    }
                    case 2: {
                        text = "Error: ";
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbacks[i], "Unrecognized message type");
                    }
                }
                String message = tc.getMessage();
                if (message != null) {
                    text = text + message;
                }
                if (text == null) continue;
                System.err.println(text);
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                if (nc.getDefaultName() == null) {
                    System.err.print(nc.getPrompt());
                } else {
                    System.err.print(nc.getPrompt() + " [" + nc.getDefaultName() + "] ");
                }
                System.err.flush();
                String result = this.readLine();
                if (result.equals("")) {
                    result = nc.getDefaultName();
                }
                nc.setName(result);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                System.err.print(pc.getPrompt());
                System.err.flush();
                pc.setPassword(Password.readPassword(System.in));
                continue;
            }
            if (callbacks[i] instanceof ConfirmationCallback) {
                confirmation = (ConfirmationCallback)callbacks[i];
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
        if (confirmation != null) {
            this.doConfirmation(confirmation);
        }
    }

    private String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private void doConfirmation(ConfirmationCallback confirmation) throws IOException, UnsupportedCallbackException {
        int result;
        class OptionInfo {
            String name;
            int value;

            OptionInfo(String name, int value) {
                this.name = name;
                this.value = value;
            }
        }
        OptionInfo[] options;
        String prefix;
        int messageType = confirmation.getMessageType();
        switch (messageType) {
            case 1: {
                prefix = "Warning: ";
                break;
            }
            case 2: {
                prefix = "Error: ";
                break;
            }
            case 0: {
                prefix = "";
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmation, "Unrecognized message type: " + messageType);
            }
        }
        int optionType = confirmation.getOptionType();
        switch (optionType) {
            case 0: {
                options = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1)};
                break;
            }
            case 1: {
                options = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1), new OptionInfo("Cancel", 2)};
                break;
            }
            case 2: {
                options = new OptionInfo[]{new OptionInfo("OK", 3), new OptionInfo("Cancel", 2)};
                break;
            }
            case -1: {
                String[] optionStrings = confirmation.getOptions();
                options = new OptionInfo[optionStrings.length];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = new OptionInfo(optionStrings[i], i);
                }
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmation, "Unrecognized option type: " + optionType);
            }
        }
        int defaultOption = confirmation.getDefaultOption();
        String prompt = confirmation.getPrompt();
        if (prompt == null) {
            prompt = "";
        }
        if (!(prompt = prefix + prompt).equals("")) {
            System.err.println(prompt);
        }
        for (int i = 0; i < options.length; ++i) {
            if (optionType == -1) {
                System.err.println(i + ". " + options[i].name + (i == defaultOption ? " [default]" : ""));
                continue;
            }
            System.err.println(i + ". " + options[i].name + (options[i].value == defaultOption ? " [default]" : ""));
        }
        System.err.print("Enter a number: ");
        System.err.flush();
        try {
            result = Integer.parseInt(this.readLine());
            if (result < 0 || result > options.length - 1) {
                result = defaultOption;
            }
            result = options[result].value;
        }
        catch (NumberFormatException e) {
            result = defaultOption;
        }
        confirmation.setSelectedIndex(result);
    }
}

