/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509SKIResolver.class.getName());
    private Element[] _x509childNodes = null;
    private XMLX509SKI[] _x509childObject = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return false;
        }
        this._x509childNodes = XMLUtils.selectDsNodes(element, "X509SKI");
        if (this._x509childNodes != null && this._x509childNodes.length > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Yes Sir, I can");
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I can't");
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            boolean weCanResolve;
            if (!(this._x509childNodes != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509childNodes != null)) {
                return null;
            }
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SKI"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "", ex);
                }
                throw ex;
            }
            this._x509childObject = new XMLX509SKI[this._x509childNodes.length];
            for (int i = 0; i < this._x509childNodes.length; ++i) {
                this._x509childObject[i] = new XMLX509SKI(this._x509childNodes[i], BaseURI);
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SKI certSKI = new XMLX509SKI(element.getOwnerDocument(), cert);
                for (int i = 0; i < this._x509childObject.length; ++i) {
                    if (!certSKI.equals(this._x509childObject[i])) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Return PublicKey from " + cert.getSubjectDN().getName());
                    }
                    return cert;
                }
            }
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("empty", ex);
        }
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

