/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.AudioSynthesizer;
import com.sun.media.sound.AudioSynthesizerPropertyInfo;
import com.sun.media.sound.EmergencySoundbank;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelInstrumentComparator;
import com.sun.media.sound.ModelMappedInstrument;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ReferenceCountingDevice;
import com.sun.media.sound.SF2Soundbank;
import com.sun.media.sound.SoftAudioPusher;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftChannelProxy;
import com.sun.media.sound.SoftCubicResampler;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftJitterCorrector;
import com.sun.media.sound.SoftLanczosResampler;
import com.sun.media.sound.SoftLinearResampler;
import com.sun.media.sound.SoftLinearResampler2;
import com.sun.media.sound.SoftMainMixer;
import com.sun.media.sound.SoftPointResampler;
import com.sun.media.sound.SoftReceiver;
import com.sun.media.sound.SoftResampler;
import com.sun.media.sound.SoftSincResampler;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftSynthesizer
implements AudioSynthesizer,
ReferenceCountingDevice {
    protected static final String INFO_NAME = "Gervill";
    protected static final String INFO_VENDOR = "OpenJDK";
    protected static final String INFO_DESCRIPTION = "Software MIDI Synthesizer";
    protected static final String INFO_VERSION = "1.0";
    protected static final MidiDevice.Info info = new Info();
    private static SourceDataLine testline = null;
    private static Soundbank defaultSoundBank = null;
    protected WeakAudioStream weakstream = null;
    protected Object control_mutex = this;
    protected int voiceIDCounter = 0;
    protected int voice_allocation_mode = 0;
    protected boolean reverb_light = true;
    protected boolean reverb_on = true;
    protected boolean chorus_on = true;
    protected boolean agc_on = true;
    protected SoftChannel[] channels;
    protected SoftChannelProxy[] external_channels = null;
    private boolean largemode = false;
    private int gmmode = 0;
    private int deviceid = 0;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private SourceDataLine sourceDataLine = null;
    private SoftAudioPusher pusher = null;
    private AudioInputStream pusher_stream = null;
    private float controlrate = 147.0f;
    private boolean open = false;
    private boolean implicitOpen = false;
    private String resamplerType = "linear";
    private SoftResampler resampler = new SoftLinearResampler();
    private int number_of_midi_channels = 16;
    private int maxpoly = 64;
    private long latency = 200000L;
    private boolean jitter_correction = false;
    private SoftMainMixer mainmixer;
    private SoftVoice[] voices;
    private Map<String, SoftTuning> tunings = new HashMap<String, SoftTuning>();
    private Map<String, SoftInstrument> inslist = new HashMap<String, SoftInstrument>();
    private Map<String, ModelInstrument> availlist = new HashMap<String, ModelInstrument>();
    private Map<String, ModelInstrument> loadedlist = new HashMap<String, ModelInstrument>();
    private ArrayList<Receiver> recvslist = new ArrayList();

    private void getBuffers(ModelInstrument instrument, List<ModelByteBuffer> buffers) {
        for (ModelPerformer performer : instrument.getPerformers()) {
            if (performer.getOscillators() == null) continue;
            for (ModelOscillator osc : performer.getOscillators()) {
                if (!(osc instanceof ModelByteBufferWavetable)) continue;
                ModelByteBufferWavetable w = (ModelByteBufferWavetable)osc;
                ModelByteBuffer buff = w.getBuffer();
                if (buff != null) {
                    buffers.add(buff);
                }
                if ((buff = w.get8BitExtensionBuffer()) == null) continue;
                buffers.add(buff);
            }
        }
    }

    private boolean loadSamples(List<ModelInstrument> instruments) {
        if (this.largemode) {
            return true;
        }
        ArrayList<ModelByteBuffer> buffers = new ArrayList<ModelByteBuffer>();
        for (ModelInstrument instrument : instruments) {
            this.getBuffers(instrument, buffers);
        }
        try {
            ModelByteBuffer.loadAll(buffers);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadInstruments(List<ModelInstrument> instruments) {
        if (!this.isOpen()) {
            return false;
        }
        if (!this.loadSamples(instruments)) {
            return false;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.channels != null) {
                for (SoftChannel c : this.channels) {
                    c.current_instrument = null;
                }
            }
            for (ModelInstrument instrument : instruments) {
                String pat = this.patchToString(instrument.getPatch());
                this.availlist.remove(pat);
                SoftInstrument softins = new SoftInstrument(instrument);
                this.inslist.put(pat, softins);
                this.loadedlist.put(pat, instrument);
            }
        }
        return true;
    }

    private void processPropertyInfo(Map<String, Object> info) {
        AudioSynthesizerPropertyInfo[] items = this.getPropertyInfo(info);
        String resamplerType = (String)items[0].value;
        if (resamplerType.equalsIgnoreCase("point")) {
            this.resampler = new SoftPointResampler();
            this.resamplerType = "point";
        } else if (resamplerType.equalsIgnoreCase("linear")) {
            this.resampler = new SoftLinearResampler2();
            this.resamplerType = "linear";
        } else if (resamplerType.equalsIgnoreCase("linear1")) {
            this.resampler = new SoftLinearResampler();
            this.resamplerType = "linear1";
        } else if (resamplerType.equalsIgnoreCase("linear2")) {
            this.resampler = new SoftLinearResampler2();
            this.resamplerType = "linear2";
        } else if (resamplerType.equalsIgnoreCase("cubic")) {
            this.resampler = new SoftCubicResampler();
            this.resamplerType = "cubic";
        } else if (resamplerType.equalsIgnoreCase("lanczos")) {
            this.resampler = new SoftLanczosResampler();
            this.resamplerType = "lanczos";
        } else if (resamplerType.equalsIgnoreCase("sinc")) {
            this.resampler = new SoftSincResampler();
            this.resamplerType = "sinc";
        }
        this.setFormat((AudioFormat)items[2].value);
        this.controlrate = ((Float)items[1].value).floatValue();
        this.latency = (Long)items[3].value;
        this.deviceid = (Integer)items[4].value;
        this.maxpoly = (Integer)items[5].value;
        this.reverb_on = (Boolean)items[6].value;
        this.chorus_on = (Boolean)items[7].value;
        this.agc_on = (Boolean)items[8].value;
        this.largemode = (Boolean)items[9].value;
        this.number_of_midi_channels = (Integer)items[10].value;
        this.jitter_correction = (Boolean)items[11].value;
        this.reverb_light = (Boolean)items[12].value;
    }

    private String patchToString(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            return "p." + patch.getProgram() + "." + patch.getBank();
        }
        return patch.getProgram() + "." + patch.getBank();
    }

    private void setFormat(AudioFormat format) {
        if (format.getChannels() > 2) {
            throw new IllegalArgumentException("Only mono and stereo audio supported.");
        }
        if (AudioFloatConverter.getConverter(format) == null) {
            throw new IllegalArgumentException("Audio format not supported.");
        }
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReceiver(Receiver recv) {
        boolean perform_close = false;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.recvslist.remove(recv) && this.implicitOpen && this.recvslist.isEmpty()) {
                perform_close = true;
            }
        }
        if (perform_close) {
            this.close();
        }
    }

    protected SoftMainMixer getMainMixer() {
        if (!this.isOpen()) {
            return null;
        }
        return this.mainmixer;
    }

    protected SoftInstrument findInstrument(int program, int bank, int channel) {
        if (bank >> 7 == 120 || bank >> 7 == 121) {
            SoftInstrument current_instrument = this.inslist.get(program + "." + bank);
            if (current_instrument != null) {
                return current_instrument;
            }
            String p_plaf = bank >> 7 == 120 ? "p." : "";
            current_instrument = this.inslist.get(p_plaf + program + "." + ((bank & 0x80) << 7));
            if (current_instrument != null) {
                return current_instrument;
            }
            current_instrument = this.inslist.get(p_plaf + program + "." + (bank & 0x80));
            if (current_instrument != null) {
                return current_instrument;
            }
            current_instrument = this.inslist.get(p_plaf + program + ".0");
            if (current_instrument != null) {
                return current_instrument;
            }
            current_instrument = this.inslist.get(p_plaf + program + "0.0");
            if (current_instrument != null) {
                return current_instrument;
            }
            return null;
        }
        String p_plaf = channel == 9 ? "p." : "";
        SoftInstrument current_instrument = this.inslist.get(p_plaf + program + "." + bank);
        if (current_instrument != null) {
            return current_instrument;
        }
        current_instrument = this.inslist.get(p_plaf + program + ".0");
        if (current_instrument != null) {
            return current_instrument;
        }
        current_instrument = this.inslist.get(p_plaf + "0.0");
        if (current_instrument != null) {
            return current_instrument;
        }
        return null;
    }

    protected int getVoiceAllocationMode() {
        return this.voice_allocation_mode;
    }

    protected int getGeneralMidiMode() {
        return this.gmmode;
    }

    protected void setGeneralMidiMode(int gmmode) {
        this.gmmode = gmmode;
    }

    protected int getDeviceID() {
        return this.deviceid;
    }

    protected float getControlRate() {
        return this.controlrate;
    }

    protected SoftVoice[] getVoices() {
        return this.voices;
    }

    protected SoftTuning getTuning(Patch patch) {
        String t_id = this.patchToString(patch);
        SoftTuning tuning = this.tunings.get(t_id);
        if (tuning == null) {
            tuning = new SoftTuning(patch);
            this.tunings.put(t_id, tuning);
        }
        return tuning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatency() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.latency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPolyphony() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.maxpoly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiChannel[] getChannels() {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.external_channels == null) {
                this.external_channels = new SoftChannelProxy[16];
                for (int i = 0; i < this.external_channels.length; ++i) {
                    this.external_channels[i] = new SoftChannelProxy();
                }
            }
            MidiChannel[] ret = this.isOpen() ? new MidiChannel[this.channels.length] : new MidiChannel[16];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.external_channels[i];
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoiceStatus[] getVoiceStatus() {
        if (!this.isOpen()) {
            VoiceStatus[] tempVoiceStatusArray = new VoiceStatus[this.getMaxPolyphony()];
            for (int i = 0; i < tempVoiceStatusArray.length; ++i) {
                VoiceStatus b = new VoiceStatus();
                b.active = false;
                b.bank = 0;
                b.channel = 0;
                b.note = 0;
                b.program = 0;
                b.volume = 0;
                tempVoiceStatusArray[i] = b;
            }
            return tempVoiceStatusArray;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            VoiceStatus[] tempVoiceStatusArray = new VoiceStatus[this.voices.length];
            for (int i = 0; i < this.voices.length; ++i) {
                SoftVoice a = this.voices[i];
                VoiceStatus b = new VoiceStatus();
                b.active = a.active;
                b.bank = a.bank;
                b.channel = a.channel;
                b.note = a.note;
                b.program = a.program;
                b.volume = a.volume;
                tempVoiceStatusArray[i] = b;
            }
            return tempVoiceStatusArray;
        }
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        for (Instrument ins : soundbank.getInstruments()) {
            if (ins instanceof ModelInstrument) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        if (instrument == null || !(instrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument);
        }
        ArrayList<ModelInstrument> instruments = new ArrayList<ModelInstrument>();
        instruments.add((ModelInstrument)instrument);
        return this.loadInstruments(instruments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadInstrument(Instrument instrument) {
        if (instrument == null || !(instrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument);
        }
        if (!this.isOpen()) {
            return;
        }
        String pat = this.patchToString(instrument.getPatch());
        Object object = this.control_mutex;
        synchronized (object) {
            for (SoftChannel c : this.channels) {
                c.current_instrument = null;
            }
            this.inslist.remove(pat);
            this.loadedlist.remove(pat);
            this.availlist.remove(pat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remapInstrument(Instrument from, Instrument to) {
        if (from == null) {
            throw new NullPointerException();
        }
        if (to == null) {
            throw new NullPointerException();
        }
        if (!(from instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + from.toString());
        }
        if (!(to instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + to.toString());
        }
        if (!this.isOpen()) {
            return false;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.loadedlist.containsValue(to) && !this.availlist.containsValue(to)) {
                throw new IllegalArgumentException("Instrument to is not loaded.");
            }
            this.unloadInstrument(from);
            ModelMappedInstrument mfrom = new ModelMappedInstrument((ModelInstrument)to, from.getPatch());
            return this.loadInstrument(mfrom);
        }
    }

    @Override
    public synchronized Soundbank getDefaultSoundbank() {
        if (defaultSoundBank == null) {
            try {
                File gm_dls;
                File javahome = new File(System.getProperties().getProperty("java.home"));
                File libaudio = new File(new File(javahome, "lib"), "audio");
                if (libaudio.exists()) {
                    File foundfile = null;
                    File[] files = libaudio.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            String lname;
                            File file = files[i];
                            if (!file.isFile() || !(lname = file.getName().toLowerCase()).endsWith(".sf2") && !lname.endsWith(".dls") || foundfile != null && file.length() <= foundfile.length()) continue;
                            foundfile = file;
                        }
                    }
                    if (foundfile != null) {
                        try {
                            Soundbank sbk;
                            defaultSoundBank = sbk = MidiSystem.getSoundbank(foundfile);
                            return defaultSoundBank;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (System.getProperties().getProperty("os.name").startsWith("Windows") && (gm_dls = new File(System.getenv("SystemRoot") + "\\system32\\drivers\\gm.dls")).exists()) {
                    try {
                        Soundbank sbk;
                        defaultSoundBank = sbk = MidiSystem.getSoundbank(gm_dls);
                        return defaultSoundBank;
                    }
                    catch (Exception e) {}
                }
            }
            catch (AccessControlException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            File userhome = null;
            File emg_soundbank_file = null;
            try {
                Soundbank sbk;
                userhome = new File(System.getProperty("user.home"), ".gervill");
                emg_soundbank_file = new File(userhome, "soundbank-emg.sf2");
                defaultSoundBank = sbk = MidiSystem.getSoundbank(emg_soundbank_file);
                return defaultSoundBank;
            }
            catch (AccessControlException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                defaultSoundBank = EmergencySoundbank.createSoundbank();
                if (defaultSoundBank != null) {
                    if (!userhome.exists()) {
                        userhome.mkdirs();
                    }
                    if (!emg_soundbank_file.exists()) {
                        ((SF2Soundbank)defaultSoundBank).save(emg_soundbank_file);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultSoundBank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrument[] getAvailableInstruments() {
        if (!this.isOpen()) {
            Soundbank defsbk = this.getDefaultSoundbank();
            if (defsbk == null) {
                return new Instrument[0];
            }
            return defsbk.getInstruments();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            Instrument[] inslist_array = new ModelInstrument[this.availlist.values().size()];
            this.availlist.values().toArray(inslist_array);
            Arrays.sort(inslist_array, new ModelInstrumentComparator());
            return inslist_array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrument[] getLoadedInstruments() {
        if (!this.isOpen()) {
            return new Instrument[0];
        }
        Object object = this.control_mutex;
        synchronized (object) {
            Instrument[] inslist_array = new ModelInstrument[this.loadedlist.values().size()];
            this.loadedlist.values().toArray(inslist_array);
            Arrays.sort(inslist_array, new ModelInstrumentComparator());
            return inslist_array;
        }
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        ArrayList<ModelInstrument> instruments = new ArrayList<ModelInstrument>();
        for (Instrument ins : soundbank.getInstruments()) {
            if (ins == null || !(ins instanceof ModelInstrument)) {
                throw new IllegalArgumentException("Unsupported instrument: " + ins);
            }
            instruments.add((ModelInstrument)ins);
        }
        return this.loadInstruments(instruments);
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
        if (soundbank == null || !this.isSoundbankSupported(soundbank)) {
            throw new IllegalArgumentException("Unsupported soundbank: " + soundbank);
        }
        if (!this.isOpen()) {
            return;
        }
        for (Instrument ins : soundbank.getInstruments()) {
            if (!(ins instanceof ModelInstrument)) continue;
            this.unloadInstrument(ins);
        }
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        ArrayList<ModelInstrument> instruments = new ArrayList<ModelInstrument>();
        for (Patch patch : patchList) {
            Instrument ins = soundbank.getInstrument(patch);
            if (ins == null || !(ins instanceof ModelInstrument)) {
                throw new IllegalArgumentException("Unsupported instrument: " + ins);
            }
            instruments.add((ModelInstrument)ins);
        }
        return this.loadInstruments(instruments);
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
        if (soundbank == null || !this.isSoundbankSupported(soundbank)) {
            throw new IllegalArgumentException("Unsupported soundbank: " + soundbank);
        }
        if (!this.isOpen()) {
            return;
        }
        for (Patch pat : patchList) {
            Instrument ins = soundbank.getInstrument(pat);
            if (!(ins instanceof ModelInstrument)) continue;
            this.unloadInstrument(ins);
        }
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return info;
    }

    @Override
    public AudioSynthesizerPropertyInfo[] getPropertyInfo(Map<String, Object> info) {
        ArrayList<AudioSynthesizerPropertyInfo> list = new ArrayList<AudioSynthesizerPropertyInfo>();
        boolean o = info == null && this.open;
        AudioSynthesizerPropertyInfo item = new AudioSynthesizerPropertyInfo("interpolation", o ? this.resamplerType : "linear");
        item.choices = new String[]{"linear", "linear1", "linear2", "cubic", "lanczos", "sinc", "point"};
        item.description = "Interpolation method";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("control rate", Float.valueOf(o ? this.controlrate : 147.0f));
        item.description = "Control rate";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("format", o ? this.format : new AudioFormat(44100.0f, 16, 2, true, false));
        item.description = "Default audio format";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("latency", o ? this.latency : 120000L);
        item.description = "Default latency";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("device id", o ? this.deviceid : 0);
        item.description = "Device ID for SysEx Messages";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("max polyphony", o ? this.maxpoly : 64);
        item.description = "Maximum polyphony";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("reverb", o ? this.reverb_on : true);
        item.description = "Turn reverb effect on or off";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("chorus", o ? this.chorus_on : true);
        item.description = "Turn chorus effect on or off";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("auto gain control", o ? this.agc_on : true);
        item.description = "Turn auto gain control on or off";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("large mode", o ? this.largemode : false);
        item.description = "Turn large mode on or off.";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("midi channels", o ? this.channels.length : 16);
        item.description = "Number of midi channels.";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("jitter correction", o ? this.jitter_correction : true);
        item.description = "Turn jitter correction on or off.";
        list.add(item);
        item = new AudioSynthesizerPropertyInfo("light reverb", o ? this.reverb_light : true);
        item.description = "Turn light reverb mode on or off";
        list.add(item);
        AudioSynthesizerPropertyInfo[] items = list.toArray(new AudioSynthesizerPropertyInfo[list.size()]);
        if (info != null) {
            for (AudioSynthesizerPropertyInfo item2 : items) {
                Object v = info.get(item2.name);
                Class c = item2.valueClass;
                if (v == null || !c.isInstance(v)) continue;
                item2.value = v;
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws MidiUnavailableException {
        if (this.isOpen()) {
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = false;
            }
            return;
        }
        this.open(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(SourceDataLine line, Map<String, Object> info) throws MidiUnavailableException {
        if (this.isOpen()) {
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = false;
            }
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            Exception causeException = null;
            try {
                if (line != null) {
                    this.setFormat(line.getFormat());
                }
                AudioInputStream ais = this.openStream(this.getFormat(), info);
                this.weakstream = new WeakAudioStream(ais);
                ais = this.weakstream.getAudioInputStream();
                if (line == null) {
                    line = testline != null ? testline : AudioSystem.getSourceDataLine(this.getFormat());
                }
                double latency = this.latency;
                if (!line.isOpen()) {
                    int bufferSize = this.getFormat().getFrameSize() * (int)((double)this.getFormat().getFrameRate() * (latency / 1000000.0));
                    line.open(this.getFormat(), bufferSize);
                    this.sourceDataLine = line;
                }
                if (!line.isActive()) {
                    line.start();
                }
                int controlbuffersize = 512;
                try {
                    controlbuffersize = ais.available();
                }
                catch (IOException e) {
                    // empty catch block
                }
                int buffersize = line.getBufferSize();
                buffersize -= buffersize % controlbuffersize;
                if (buffersize < 3 * controlbuffersize) {
                    buffersize = 3 * controlbuffersize;
                }
                if (this.jitter_correction) {
                    ais = new SoftJitterCorrector(ais, buffersize, controlbuffersize);
                    if (this.weakstream != null) {
                        this.weakstream.jitter_stream = ais;
                    }
                }
                this.pusher = new SoftAudioPusher(line, ais, controlbuffersize);
                this.pusher_stream = ais;
                this.pusher.start();
                if (this.weakstream != null) {
                    this.weakstream.pusher = this.pusher;
                    this.weakstream.sourceDataLine = this.sourceDataLine;
                }
            }
            catch (LineUnavailableException e) {
                causeException = e;
            }
            catch (IllegalArgumentException e) {
                causeException = e;
            }
            catch (SecurityException e) {
                causeException = e;
            }
            if (causeException != null) {
                if (this.isOpen()) {
                    this.close();
                }
                MidiUnavailableException ex = new MidiUnavailableException("Can not open line");
                ex.initCause(causeException);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream openStream(AudioFormat targetFormat, Map<String, Object> info) throws MidiUnavailableException {
        if (this.isOpen()) {
            throw new MidiUnavailableException("Synthesizer is already open");
        }
        Object object = this.control_mutex;
        synchronized (object) {
            int i;
            Soundbank defbank;
            this.gmmode = 0;
            this.voice_allocation_mode = 0;
            this.processPropertyInfo(info);
            this.open = true;
            this.implicitOpen = false;
            if (targetFormat != null) {
                this.setFormat(targetFormat);
            }
            if ((defbank = this.getDefaultSoundbank()) != null) {
                this.loadAllInstruments(defbank);
                this.availlist.putAll(this.loadedlist);
                this.loadedlist.clear();
            }
            this.voices = new SoftVoice[this.maxpoly];
            for (i = 0; i < this.maxpoly; ++i) {
                this.voices[i] = new SoftVoice(this);
            }
            this.mainmixer = new SoftMainMixer(this);
            this.channels = new SoftChannel[this.number_of_midi_channels];
            for (i = 0; i < this.channels.length; ++i) {
                this.channels[i] = new SoftChannel(this, i);
            }
            if (this.external_channels == null) {
                this.external_channels = this.channels.length < 16 ? new SoftChannelProxy[16] : new SoftChannelProxy[this.channels.length];
                for (i = 0; i < this.external_channels.length; ++i) {
                    this.external_channels[i] = new SoftChannelProxy();
                }
            } else if (this.channels.length > this.external_channels.length) {
                int i2;
                SoftChannelProxy[] new_external_channels = new SoftChannelProxy[this.channels.length];
                for (i2 = 0; i2 < this.external_channels.length; ++i2) {
                    new_external_channels[i2] = this.external_channels[i2];
                }
                for (i2 = this.external_channels.length; i2 < new_external_channels.length; ++i2) {
                    new_external_channels[i2] = new SoftChannelProxy();
                }
            }
            for (int i3 = 0; i3 < this.channels.length; ++i3) {
                this.external_channels[i3].setChannel(this.channels[i3]);
            }
            for (SoftVoice voice : this.getVoices()) {
                voice.resampler = this.resampler.openStreamer();
            }
            for (Receiver recv : this.getReceivers()) {
                SoftReceiver srecv = (SoftReceiver)recv;
                srecv.open = this.open;
                srecv.mainmixer = this.mainmixer;
                srecv.midimessages = this.mainmixer.midimessages;
            }
            return this.mainmixer.getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        SoftAudioPusher pusher_to_be_closed = null;
        AudioInputStream pusher_stream_to_be_closed = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.pusher != null) {
                pusher_to_be_closed = this.pusher;
                pusher_stream_to_be_closed = this.pusher_stream;
                this.pusher = null;
                this.pusher_stream = null;
            }
        }
        if (pusher_to_be_closed != null) {
            pusher_to_be_closed.stop();
            try {
                pusher_stream_to_be_closed.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer != null) {
                this.mainmixer.close();
            }
            this.open = false;
            this.implicitOpen = false;
            this.mainmixer = null;
            this.voices = null;
            this.channels = null;
            if (this.external_channels != null) {
                for (int i = 0; i < this.external_channels.length; ++i) {
                    this.external_channels[i].setChannel(null);
                }
            }
            if (this.sourceDataLine != null) {
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
            this.inslist.clear();
            this.availlist.clear();
            this.loadedlist.clear();
            this.tunings.clear();
            while (this.recvslist.size() != 0) {
                this.recvslist.get(this.recvslist.size() - 1).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMicrosecondPosition() {
        if (!this.isOpen()) {
            return 0L;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mainmixer.getMicrosecondPosition();
        }
    }

    @Override
    public int getMaxReceivers() {
        return -1;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        Object object = this.control_mutex;
        synchronized (object) {
            SoftReceiver receiver = new SoftReceiver(this);
            receiver.open = this.open;
            this.recvslist.add(receiver);
            return receiver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Receiver> getReceivers() {
        Object object = this.control_mutex;
        synchronized (object) {
            ArrayList<Receiver> recvs = new ArrayList<Receiver>();
            recvs.addAll(this.recvslist);
            return recvs;
        }
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("No transmitter available");
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return new ArrayList<Transmitter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiverReferenceCounting() throws MidiUnavailableException {
        if (!this.isOpen()) {
            this.open();
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = true;
            }
        }
        return this.getReceiver();
    }

    @Override
    public Transmitter getTransmitterReferenceCounting() throws MidiUnavailableException {
        throw new MidiUnavailableException("No transmitter available");
    }

    private static class Info
    extends MidiDevice.Info {
        public Info() {
            super(SoftSynthesizer.INFO_NAME, SoftSynthesizer.INFO_VENDOR, SoftSynthesizer.INFO_DESCRIPTION, SoftSynthesizer.INFO_VERSION);
        }
    }

    protected static class WeakAudioStream
    extends InputStream {
        private volatile AudioInputStream stream;
        public SoftAudioPusher pusher = null;
        public AudioInputStream jitter_stream = null;
        public SourceDataLine sourceDataLine = null;
        public volatile long silent_samples = 0L;
        private int framesize = 0;
        private WeakReference<AudioInputStream> weak_stream_link;
        private AudioFloatConverter converter;
        private float[] silentbuffer = null;
        private int samplesize;

        public void setInputStream(AudioInputStream stream) {
            this.stream = stream;
        }

        public int available() throws IOException {
            AudioInputStream local_stream = this.stream;
            if (local_stream != null) {
                return local_stream.available();
            }
            return 0;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            AudioInputStream local_stream = this.stream;
            if (local_stream != null) {
                return local_stream.read(b, off, len);
            }
            int flen = len / this.samplesize;
            if (this.silentbuffer == null || this.silentbuffer.length < flen) {
                this.silentbuffer = new float[flen];
            }
            this.converter.toByteArray(this.silentbuffer, flen, b, off);
            this.silent_samples += (long)(len / this.framesize);
            if (this.pusher != null && this.weak_stream_link.get() == null) {
                Runnable runnable = new Runnable(){
                    SoftAudioPusher _pusher;
                    AudioInputStream _jitter_stream;
                    SourceDataLine _sourceDataLine;
                    {
                        this._pusher = WeakAudioStream.this.pusher;
                        this._jitter_stream = WeakAudioStream.this.jitter_stream;
                        this._sourceDataLine = WeakAudioStream.this.sourceDataLine;
                    }

                    public void run() {
                        this._pusher.stop();
                        if (this._jitter_stream != null) {
                            try {
                                this._jitter_stream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (this._sourceDataLine != null) {
                            this._sourceDataLine.close();
                        }
                    }
                };
                this.pusher = null;
                this.jitter_stream = null;
                this.sourceDataLine = null;
                new Thread(runnable).start();
            }
            return len;
        }

        public WeakAudioStream(AudioInputStream stream) {
            this.stream = stream;
            this.weak_stream_link = new WeakReference<AudioInputStream>(stream);
            this.converter = AudioFloatConverter.getConverter(stream.getFormat());
            this.samplesize = stream.getFormat().getFrameSize() / stream.getFormat().getChannels();
            this.framesize = stream.getFormat().getFrameSize();
        }

        public AudioInputStream getAudioInputStream() {
            return new AudioInputStream(this, this.stream.getFormat(), -1L);
        }

        public void close() throws IOException {
            AudioInputStream astream = (AudioInputStream)this.weak_stream_link.get();
            if (astream != null) {
                astream.close();
            }
        }
    }
}

