/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

final class LdapAttribute
extends BasicAttribute {
    static final long serialVersionUID = -4288716561020779584L;
    private transient DirContext baseCtx = null;
    private Name rdn = new CompositeName();
    private String baseCtxURL;
    private Hashtable baseCtxEnv;

    public Object clone() {
        LdapAttribute attr = new LdapAttribute(this.attrID, this.baseCtx, this.rdn);
        attr.values = (Vector)this.values.clone();
        return attr;
    }

    public boolean add(Object attrVal) {
        this.values.addElement(attrVal);
        return true;
    }

    LdapAttribute(String id) {
        super(id);
    }

    private LdapAttribute(String id, DirContext baseCtx, Name rdn) {
        super(id);
        this.baseCtx = baseCtx;
        this.rdn = rdn;
    }

    void setParent(DirContext baseCtx, Name rdn) {
        this.baseCtx = baseCtx;
        this.rdn = rdn;
    }

    private DirContext getBaseCtx() throws NamingException {
        if (this.baseCtx == null) {
            if (this.baseCtxEnv == null) {
                this.baseCtxEnv = new Hashtable(3);
            }
            this.baseCtxEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.baseCtxEnv.put("java.naming.provider.url", this.baseCtxURL);
            this.baseCtx = new InitialDirContext(this.baseCtxEnv);
        }
        return this.baseCtx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.setBaseCtxInfo();
        out.defaultWriteObject();
    }

    private void setBaseCtxInfo() {
        Hashtable realEnv = null;
        Hashtable secureEnv = null;
        if (this.baseCtx != null) {
            realEnv = ((LdapCtx)this.baseCtx).envprops;
            this.baseCtxURL = ((LdapCtx)this.baseCtx).getURL();
        }
        if (realEnv != null && realEnv.size() > 0) {
            Enumeration keys = realEnv.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.indexOf("security") == -1) continue;
                if (secureEnv == null) {
                    secureEnv = (Hashtable)realEnv.clone();
                }
                secureEnv.remove(key);
            }
        }
        this.baseCtxEnv = secureEnv == null ? realEnv : secureEnv;
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        DirContext schema = this.getBaseCtx().getSchema(this.rdn);
        DirContext attrDef = (DirContext)schema.lookup("AttributeDefinition/" + this.getID());
        Attribute syntaxAttr = attrDef.getAttributes("").get("SYNTAX");
        if (syntaxAttr == null || syntaxAttr.size() == 0) {
            throw new NameNotFoundException(this.getID() + "does not have a syntax associated with it");
        }
        String syntaxName = (String)syntaxAttr.get();
        return (DirContext)schema.lookup("SyntaxDefinition/" + syntaxName);
    }

    public DirContext getAttributeDefinition() throws NamingException {
        DirContext schema = this.getBaseCtx().getSchema(this.rdn);
        return (DirContext)schema.lookup("AttributeDefinition/" + this.getID());
    }
}

