/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.EntryChangeResponseControl;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortResponseControl;

public class DefaultResponseControlFactory
extends ControlFactory {
    public Control getControlInstance(Control ctl) throws NamingException {
        String id = ctl.getID();
        try {
            if (id.equals("1.2.840.113556.1.4.474")) {
                return new SortResponseControl(id, ctl.isCritical(), ctl.getEncodedValue());
            }
            if (id.equals("1.2.840.113556.1.4.319")) {
                return new PagedResultsResponseControl(id, ctl.isCritical(), ctl.getEncodedValue());
            }
            if (id.equals("2.16.840.1.113730.3.4.7")) {
                return new EntryChangeResponseControl(id, ctl.isCritical(), ctl.getEncodedValue());
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return null;
    }
}

