/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.ServerTableEntry;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;

public class ProcessMonitorThread
extends Thread {
    private HashMap serverTable;
    private int sleepTime;
    private static ProcessMonitorThread instance = null;

    private ProcessMonitorThread(HashMap ServerTable, int SleepTime) {
        this.serverTable = ServerTable;
        this.sleepTime = SleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Iterator serverList;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                break;
            }
            HashMap hashMap = this.serverTable;
            synchronized (hashMap) {
                serverList = this.serverTable.values().iterator();
            }
            try {
                this.checkServerHealth(serverList);
            }
            catch (ConcurrentModificationException e) {
                break;
            }
        }
    }

    private void checkServerHealth(Iterator serverList) {
        if (serverList == null) {
            return;
        }
        while (serverList.hasNext()) {
            ServerTableEntry entry = (ServerTableEntry)serverList.next();
            entry.checkProcessHealth();
        }
    }

    static void start(HashMap serverTable) {
        int sleepTime = 1000;
        String pollingTime = System.getProperties().getProperty("com.sun.CORBA.activation.ServerPollingTime");
        if (pollingTime != null) {
            try {
                sleepTime = Integer.parseInt(pollingTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        instance = new ProcessMonitorThread(serverTable, sleepTime);
        instance.setDaemon(true);
        instance.start();
    }

    static void interruptThread() {
        instance.interrupt();
    }
}

