/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.EUC_TW;

public class CharToByteEUC_TW
extends CharToByteConverter {
    private final byte MSB = (byte)-128;
    private final byte SS2 = (byte)-114;
    private final byte P2 = (byte)-94;
    private final byte P3 = (byte)-93;
    private static final EUC_TW nioCoder = new EUC_TW();
    private static String uniTab1 = nioCoder.getUniTab1();
    private static String uniTab2 = nioCoder.getUniTab2();
    private static String uniTab3 = nioCoder.getUniTab3();
    private static String cnsTab1 = nioCoder.getCNSTab1();
    private static String cnsTab2 = nioCoder.getCNSTab2();
    private static String cnsTab3 = nioCoder.getCNSTab3();
    private char[] UniTab1 = uniTab1.toCharArray();
    private char[] UniTab2 = uniTab2.toCharArray();
    private char[] UniTab3 = uniTab3.toCharArray();
    private char[] CNSTab1 = cnsTab1.toCharArray();
    private char[] CNSTab2 = cnsTab2.toCharArray();
    private char[] CNSTab3 = cnsTab3.toCharArray();

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        this.reset();
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    public boolean canConvert(char ch) {
        return (0xFF00 & ch) != 0 && this.getNative(ch) != -1;
    }

    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        byte[] tmpbuf = new byte[4];
        this.byteOff = outOff;
        this.charOff = inOff;
        while (this.charOff < inEnd) {
            int outputSize;
            byte[] outputByte = tmpbuf;
            if (input[this.charOff] < '\u0080') {
                outputSize = 1;
                outputByte[0] = (byte)(input[this.charOff] & 0x7F);
            } else {
                outputSize = this.unicodeToEUC(input[this.charOff], outputByte);
            }
            if (outputSize == -1) {
                if (this.subMode) {
                    outputByte = this.subBytes;
                    outputSize = this.subBytes.length;
                } else {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
            }
            if (outEnd - this.byteOff < outputSize) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            ++this.charOff;
        }
        return this.byteOff - outOff;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public String getCharacterEncoding() {
        return "EUC_TW";
    }

    protected int getNative(char unicode) {
        if (unicode < this.UniTab2[0]) {
            int i = this.searchTab(unicode, this.UniTab1);
            if (i == -1) {
                return -1;
            }
            int cns = (this.CNSTab1[2 * i] << 16) + this.CNSTab1[2 * i + 1];
            return cns;
        }
        if (unicode < this.UniTab3[0]) {
            int i = this.searchTab(unicode, this.UniTab2);
            if (i == -1) {
                return -1;
            }
            int cns = (this.CNSTab2[2 * i] << 16) + this.CNSTab2[2 * i + 1];
            return cns;
        }
        int i = this.searchTab(unicode, this.UniTab3);
        if (i == -1) {
            return -1;
        }
        int cns = (this.CNSTab3[2 * i] << 16) + this.CNSTab3[2 * i + 1];
        return cns;
    }

    protected int searchTab(char code, char[] table) {
        int i = 0;
        int l = 0;
        int h = table.length - 1;
        while (l < h) {
            if (table[l] == code) {
                i = l;
                break;
            }
            if (table[h] == code) {
                i = h;
                break;
            }
            i = (l + h) / 2;
            if (table[i] == code) break;
            if (table[i] < code) {
                l = i + 1;
                continue;
            }
            h = i - 1;
        }
        if (code == table[i]) {
            return i;
        }
        return -1;
    }

    private int unicodeToEUC(char unicode, byte[] ebyte) {
        int cns = this.getNative(unicode);
        if (cns >> 16 == 1) {
            ebyte[0] = (byte)((cns & 0xFF00) >> 8 | 0xFFFFFF80);
            ebyte[1] = (byte)(cns & 0xFF | 0xFFFFFF80);
            return 2;
        }
        byte cnsPlane = (byte)(cns >> 16);
        if (cnsPlane >= 2) {
            ebyte[0] = -114;
            ebyte[1] = (byte)(cnsPlane | 0xFFFFFFA0);
            ebyte[2] = (byte)((cns & 0xFF00) >> 8 | 0xFFFFFF80);
            ebyte[3] = (byte)(cns & 0xFF | 0xFFFFFF80);
            return 4;
        }
        return -1;
    }

    protected int unicodeToEUC(char unicode) {
        if (unicode <= '\u007f') {
            return unicode;
        }
        int cns = this.getNative(unicode);
        int plane = cns >> 16;
        int euc = cns & 0xFFFF | 0x8080;
        if (plane == 1) {
            return euc;
        }
        if (plane == 2) {
            return 0x8EA20000 | euc;
        }
        if (plane == 3) {
            return 0x8EA30000 | euc;
        }
        return -1;
    }
}

