/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalOutputStream
extends ObjectOutputStream {
    public MarshalOutputStream(OutputStream out) throws IOException {
        this(out, 1);
    }

    public MarshalOutputStream(OutputStream out, int protocolVersion) throws IOException {
        super(out);
        this.useProtocolVersion(protocolVersion);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MarshalOutputStream.this.enableReplaceObject(true);
                return null;
            }
        });
    }

    @Override
    protected final Object replaceObject(Object obj) throws IOException {
        Target target;
        if (obj instanceof Remote && !(obj instanceof RemoteStub) && (target = ObjectTable.getTarget((Remote)obj)) != null) {
            return target.getStub();
        }
        return obj;
    }

    @Override
    protected void annotateClass(Class<?> cl) throws IOException {
        this.writeLocation(RMIClassLoader.getClassAnnotation(cl));
    }

    @Override
    protected void annotateProxyClass(Class<?> cl) throws IOException {
        this.annotateClass(cl);
    }

    protected void writeLocation(String location) throws IOException {
        this.writeObject(location);
    }
}

