/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.JarURLConnection;

public class Handler
extends URLStreamHandler {
    private static final String separator = "!/";

    protected URLConnection openConnection(URL u) throws IOException {
        return new JarURLConnection(u, this);
    }

    private int indexOfBangSlash(String spec) {
        int indexOfBang = spec.length();
        while ((indexOfBang = spec.lastIndexOf(33, indexOfBang)) != -1) {
            if (indexOfBang != spec.length() - 1 && spec.charAt(indexOfBang + 1) == '/') {
                return indexOfBang + 1;
            }
            --indexOfBang;
        }
        return -1;
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        boolean refOnly;
        String file = null;
        String ref = null;
        int refPos = spec.indexOf(35, limit);
        boolean bl = refOnly = refPos == start;
        if (refPos > -1) {
            ref = spec.substring(refPos + 1, spec.length());
            if (refOnly) {
                file = url.getFile();
            }
        }
        boolean absoluteSpec = false;
        if (spec.length() >= 4) {
            absoluteSpec = spec.substring(0, 4).equalsIgnoreCase("jar:");
        }
        spec = spec.substring(start, limit);
        if (absoluteSpec) {
            file = this.parseAbsoluteSpec(spec);
        } else if (!refOnly) {
            file = this.parseContextSpec(url, spec);
            int bangSlash = this.indexOfBangSlash(file);
            String toBangSlash = file.substring(0, bangSlash);
            String afterBangSlash = file.substring(bangSlash);
            ParseUtil canonizer = new ParseUtil();
            afterBangSlash = canonizer.canonizeString(afterBangSlash);
            file = toBangSlash + afterBangSlash;
        }
        this.setURL(url, "jar", "", -1, file, ref);
    }

    private String parseAbsoluteSpec(String spec) {
        URL url = null;
        int index = -1;
        index = this.indexOfBangSlash(spec);
        if (index == -1) {
            throw new NullPointerException("no !/ in spec");
        }
        try {
            String innerSpec = spec.substring(0, index - 1);
            url = new URL(innerSpec);
        }
        catch (MalformedURLException e) {
            throw new NullPointerException("invalid url: " + spec + " (" + e + ")");
        }
        return spec;
    }

    private String parseContextSpec(URL url, String spec) {
        String ctxFile = url.getFile();
        if (spec.startsWith("/")) {
            int bangSlash = this.indexOfBangSlash(ctxFile);
            if (bangSlash == -1) {
                throw new NullPointerException("malformed context url:" + url + ": no !/");
            }
            ctxFile = ctxFile.substring(0, bangSlash);
        }
        if (!ctxFile.endsWith("/") && !spec.startsWith("/")) {
            int lastSlash = ctxFile.lastIndexOf(47);
            if (lastSlash == -1) {
                throw new NullPointerException("malformed context url:" + url);
            }
            ctxFile = ctxFile.substring(0, lastSlash + 1);
        }
        return ctxFile + spec;
    }
}

